#!/usr/local/bin/octave -qf

###Function that extracts value of a,b,c,d from equation
function [a,b,c,d] = extract_numbers(equation)
	a=0;
	b=0;
	c=0;
	d=0;
	length_of_equation=columns(equation);
    number='';
    variable='';
    current_location=1;
    while(current_location<=length_of_equation)
		#printf("Read character %s\n",equation(current_location));
		if(isdigit(equation(current_location)) || ((equation(current_location)=='-') && (strcmp(number, '')==1) && (strcmp(variable,'')==1)) || equation(current_location)=='.')
			number=[char(number),equation(current_location)];
			#printf("Number is now %s\n", number);
		elseif(isalpha(equation(current_location)))
			variable=[variable, equation(current_location)];
			#printf("Variable is now %s\n", variable);
		elseif((equation(current_location)=='+') || (equation(current_location)=='=') || (equation(current_location)=='-'))
			[a,b,c,d,number,variable]=assign_value(a,b,c,d,number,variable,equation(current_location));
		endif
		current_location++;
    endwhile

	if(strcmp(number,'')==0)
	    number=str2num(number);
	else
		number=0;
	endif
	d=number;
	#printf("Returning a=%d, b=%d, c=%d and d=%d\n",a,b,c,d);
endfunction

function [a,b,c,d,number,variable]=assign_value(a,b,c,d,number,variable,current_char)
	if(strcmp(number,'-')==1)
		number=-1;
	elseif(strcmp(number,'')==0)
	    number=str2num(number);
	else
		#If no coefficient is written then assume it to be 1
		number=1;
	endif
	#printf("Found opertor and number is %d and variable is %s\n", number, variable);

	switch(variable)
		case 'x'
			a=number;
			#printf("Got value for a as %d, resetting number, variable\n", number);
		case 'y'
			b=number;
			#printf("Got value for b as %d, resetting number,variable,\n", number);
		case 'z'
			c=number;
			#printf("Got value for c as %d, resetting number,variable\n", number);
		otherwise
			printf("Found variable %s, expecting either x, y or z\n. Terminating.\n",variable);
			exit(-1);
	endswitch

	if(strcmp(current_char,'-')==0)
		number='';
		else
		number='-';
	endif
	variable='';
endfunction


printf("Please enter equation with only integer coefficients and constants\n");
equation1 = input("Enter first equation in a1x+b1y+c1z=d1 format: ", 's');
equation2 = input("Enter second equation in a2x+b2y+c2z=d2 format: ", 's');
equation3 = input("Enter third equation in a3x+b3y+c3z=d3 format: ", 's');

[a1,b1,c1,d1]=extract_numbers(equation1);
[a2,b2,c2,d2]=extract_numbers(equation2);
[a3,b3,c3,d3]=extract_numbers(equation3);

matrix1=[a1,b1,c1;a2,b2,c2;a3,b3,c3];
matrix2=[d1;d2;d3];
answers=matrix1  \ matrix2;

printf("Value of x is %f\n", answers(1));
printf("Value of y is %f\n", answers(2));
printf("Value of z is %f\n", answers(3));

exit(0);

