#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>


#define INPUT_STREAM 0
#define OUTPUT_STREAM 1
#define ERROR_STREAM 2
#define BUFFER 4096
#define LARGE_BUFFER 4224


int main(int argc, char *argv[])
{
    int sample_file_descriptor;
    char message[LARGE_BUFFER];
    char sentence[BUFFER];
    int characters_read;
   
    if(argc==1)
    {
	sprintf(message, "Syntax: %s <filename>\n", argv[0]);
	write(ERROR_STREAM, message, strlen(message));
	exit(EXIT_FAILURE);
    }

    sample_file_descriptor=open(argv[1], O_WRONLY | O_CREAT | O_TRUNC, 00666 );
    if(sample_file_descriptor<0)
    {
	sprintf(message, "Cant open file '%s' for writing\n", argv[1]);
	strcat(message, strerror(errno));
	strcat(message, "\n");
	write(ERROR_STREAM, message, strlen(message));
	exit(EXIT_FAILURE);
    }

    sprintf(message, "Enter sentence to be written into file : ");
    write(OUTPUT_STREAM, message, strlen(message));
    //readline(sentence, BUFFER);
    characters_read=read(INPUT_STREAM, sentence, BUFFER-1);
    sentence[characters_read]='\0';

    write(sample_file_descriptor, sentence, strlen(sentence));
    sprintf(message, "Sentence '%s' has been written to file '%s'\n", sentence, argv[1]);
    write(OUTPUT_STREAM, message, strlen(message));

    close(sample_file_descriptor);
    sprintf(message, "Closed file '%s'\n", argv[1]);
    write(OUTPUT_STREAM, message, strlen(message));


    //Reading part
    sprintf(message, "Opening file '%s' for reading\n", argv[1]);
    write(OUTPUT_STREAM, message, strlen(message));
    
    sample_file_descriptor=open(argv[1], O_RDONLY);
    if(sample_file_descriptor<0)
    {
	sprintf(message, "Cant open file '%s' for reading\n", argv[1]);
	strcat(message, strerror(errno));
	strcat(message, "\n");
	write(ERROR_STREAM, message, strlen(message));
	exit(EXIT_FAILURE);
    }

    characters_read=read(sample_file_descriptor, sentence, BUFFER-1);
    sentence[characters_read]='\0';
    sprintf(message, "Read sentence '%s' from file\n", sentence);
    write(OUTPUT_STREAM, message, strlen(message));

    close(sample_file_descriptor);
    sprintf(message, "Closed file  '%s'\n", argv[1]);
    write(OUTPUT_STREAM, message, strlen(message));

    exit(EXIT_SUCCESS);
    return 0;
}

