#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 

#define BUFFER_SIZE 4096
#define LISTEN_PORT 9999

//used to store file descriptor of port we are listing to
int listen_file_descriptor;

void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(listen_file_descriptor);

    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(EXIT_FAILURE);
    }

    printf("Shutdown complete.\n");
    exit(0);
}
    

/**
  * Used to create a example for blocking input. The program will listen on some
  * port defined in LISTEN_PORT (default 9999)  at top and call read with large
  * value (default sizeof(BUFFER)).
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{
    int connection_file_descriptor; 
    char input_data[BUFFER_SIZE];
    struct sockaddr_in server_address;
    int return_value;
    struct sigaction act1;
    int characters_read;
    
    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;

    sigaction(SIGINT, &act1, 0);
    
    listen_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);
    if(listen_file_descriptor < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(LISTEN_PORT);
    return_value = bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(EXIT_FAILURE);
    }

    return_value = listen(listen_file_descriptor, 5);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(EXIT_FAILURE);
    }
    
    while(1)
    {
	connection_file_descriptor = accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);
	if(connection_file_descriptor < 0)
	{
	    perror("accept() failed.");
	    exit(EXIT_FAILURE);
	}

	characters_read=read(connection_file_descriptor, input_data, BUFFER_SIZE-1);
	while(characters_read > 0)
	{
	    input_data[characters_read]='\0';
	    printf("Received %d bytes: %s\n", characters_read, input_data);
	    characters_read=read(connection_file_descriptor, input_data, BUFFER_SIZE-1);
	}

	if(characters_read<0)
	{
	    perror("read failed");
	    exit(EXIT_FAILURE);
	}

	return_value = close(connection_file_descriptor);

	if(return_value <0)
	{
	    perror("close failed");
	    exit(EXIT_FAILURE);
	}
    }
        
    return 0;
}

