/** This program is created for course project in Software Technology. 
  * It will create a gtk_window which will be used as GUI for interacting 
  * with proxy server
  * @file main_gtk_proxy_server
  * @author Yogendra Sao & Amit Kumar Gupta
  */

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include  <sys/types.h>
#include <unistd.h>
#include <signal.h>     /* signal name macros, and the kill() prototype */
#include <sqlite3.h>
#include <netdb.h>          /* hostent struct, gethostbyname() */
#include <arpa/inet.h>      /* inet_ntoa() to format IP address */
#include <netinet/in.h>	//for struct sockaddr_in,

#define BUFFER 4096

sqlite3 *db1;

pid_t  pid;	//fork PID
char *zErrMsg = 0;
int rc;
char sql_query[BUFFER];
GtkTextBuffer *buffer;
GtkTextIter end_iter;
GtkWidget *start,*stop;
char str[BUFFER];

//It is the 
void proxy_server_main();

/** This is a callback function for sqlite. It is called when any SELECT query
  * is executed in sql database. It prints all the values in a record.
  * @param argc no. of tuples in a record which is passed automatically by sqlite
  * @param argv values in a record which is also passed automatically by sqlite
  *
  */
static int callback (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    int i;
    for (i = 0; i < argc; i++)
    {
	printf ("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf ("\n");
    return 0;
}

/** This is a callback function for sqlite. It is called by display_log() and display_usage().
  * It displays the SELECT * query result in text_view. 
  * @param argc no. of tuples in a record which is passed automatically by sqlite
  * @param argv values in a record which is also passed automatically by sqlite
  *
  */
static int callback2 (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    int i;
    for (i = 0; i < argc; i++)
    {
	if((i==2 || i==3) && (atoi(argv[i]))%1000 == 0)
		sprintf (str," %s   \t\t", argv[i] ? argv[i] : "NULL");
	else
		sprintf (str," %s   \t", argv[i] ? argv[i] : "NULL");
	gtk_text_buffer_get_end_iter(buffer, &end_iter);
	gtk_text_buffer_insert(buffer, &end_iter, str, -1);
    }
    sprintf (str,"\n");
    gtk_text_buffer_get_end_iter(buffer, &end_iter);
    gtk_text_buffer_insert(buffer, &end_iter, str, -1);
    return 0;
}

/** This function is called when clicks on Block IP button.
  * It will insert IP/url entry in table blocked_ip in database.
  * @param widget1 Widget that generated the event
  * @param data IP/url to be blocked is passed through gtkentry
  *
  */
void block(GtkWidget *widget1, gpointer data)
{
	const gchar * text = gtk_entry_get_text(data);
	char host_ip[100];
	struct hostent *host_struct;
    	struct in_addr h_addr;    /* internet address */
	host_struct = (struct hostent *)gethostbyname(text);
    	if (host_struct == NULL)
	{
        	fprintf(stderr,"ERROR, no such host\n");
        	//return -1;
    	}
        h_addr.s_addr = *((unsigned long *) host_struct->h_addr_list[0]);
	strcpy(host_ip, inet_ntoa(h_addr));

	sprintf(sql_query, "INSERT INTO blocked_ip values('%s')", host_ip);
	rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
	sprintf(sql_query, "INSERT INTO blocked_ip values('%s')", text);
	rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
}

/** This function is called when clicks on Unblock IP button.
  * It will delete IP/url entry from database from blocked_ip table.
  * @param widget1 Widget that generated the event
  * @param data IP/url to be unblocked is passed through gtkentry
  *
  */
void unblock(GtkWidget *widget1, gpointer data)
{
	const gchar * text = gtk_entry_get_text(data);
	char host_ip[100];
	struct hostent *host_struct;
    	struct in_addr h_addr;    /* internet address */
	host_struct = (struct hostent *)gethostbyname(text);
    	if (host_struct == NULL)
	{
        	fprintf(stderr,"ERROR, no such host\n");
        	//return -1;
    	}
        h_addr.s_addr = *((unsigned long *) host_struct->h_addr_list[0]);
	strcpy(host_ip, inet_ntoa(h_addr));
	sprintf(sql_query, "DELETE from blocked_ip where blocked_ip='%s' ", host_ip);
	rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
	sprintf(sql_query, "DELETE from blocked_ip where blocked_ip='%s'", text);
	rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
}

/** This function is called when clicks on View Log button.
  * It will access database and display logs of each request with date/time,
  * requested url, client' IP, and bytes transfered in the request
  * @param widget1 Widget that generated the event
  * @param data Additional data passed by widget while generating the signal
  *
  */
void display_log(GtkWidget *widget1, gpointer data)
{
	gtk_text_buffer_set_text (data, " Client_IP  \t\t\t\t Time \t\t  Downloads\tUploads \t\tURL_Requested\n----------------------------------------------------------------------------------------------------------------------------\n", -1);

	sprintf(sql_query, "SELECT * from log_details");
	rc = sqlite3_exec (db1, sql_query, callback2, 0, &zErrMsg);
}

/** This function is called when clicks on IP Statistics button.
  * It will access database and display per IP statistics of network usage.
  * @param widget1 Widget that generated the event
  * @param data Additional data passed by widget while generating the signal
  *
  */
void display_usage(GtkWidget *widget1, gpointer data)
{
	gtk_text_buffer_set_text (data, " Client_IP  \t\tDownloads \t  Uploads\n-------------------------------------------------------------\n", -1);
	sprintf(sql_query, "SELECT * from usage_details");
	rc = sqlite3_exec (db1, sql_query, callback2, 0, &zErrMsg);
}

/** This function is called when someone tries to close top level window.
  * It will also kill proxy server running as its child.
  * @param widget1 Widget that generated the event
  * @param data Additional data passed by widget while generating the signal
  *
  */
void on_window_destroy (GtkWidget *widget, gpointer data)
{
	kill(pid, SIGTERM);
  	gtk_main_quit ();
}

/** This function is called when someone clicks on Start Server button
  * It will run proxy server as its child. It will disable Start button
  * @param widget1 Widget that generated the event
  * @param data Port no. for listen passed as string from gtkentry 
  *
  */
void start_server(GtkWidget *widget1, gpointer data)
{
     const gchar * text_port = gtk_entry_get_text(data);
     int port = atoi(text_port);
     pid = fork();
     if (pid == 0) 
     {
          proxy_server_main(port);
     }
     else
     {
	  //disabling start button
	  gtk_widget_set_sensitive(widget1, FALSE);
	  gtk_widget_set_sensitive(stop, TRUE);
	  if(port > 0)
	  	sprintf(str, "Proxy Server Started Listening on Port %d\n",port);
	  else
		sprintf(str, "Proxy Server Started Listening on Port 8080\n");
	  gtk_text_buffer_set_text (buffer, str ,-1);
     }
}

/** This function is called when someone clicks on Stop Server button
  * It will kill proxy server running as its child.
  * It will disable Stop button and enable Start button
  * @param widget1 Widget that generated the event
  * @param data Port no. for listen passed as string from gtkentry 
  *
  */
void stop_server(GtkWidget *widget1, gpointer data)
{
     kill(pid, SIGTERM);
     gtk_text_buffer_set_text (buffer, "Server Stopped..." ,-1);
     //disabling stop button
     gtk_widget_set_sensitive(widget1, FALSE);
     gtk_widget_set_sensitive(start, TRUE);
}

/**This is where program starts. This creates a window with labels, buttons, gtkentry, text_view in it.
  * This program creates User Interface for accessing various services provided by Proxy Server.
  * The Services are, block any website to access, per user IP statistics with logging.
  * The proxy server service is started and stopped using this Interface.
  * @param argc Number of arguments passed to program
  * @param argv Array of arugments passed to program
  *
  */
int main( int argc, char *argv[])
{

  	GtkWidget *window;
	GtkWidget *text_view;
	GtkWidget *entry,*port;
	GtkWidget *vbox;
  	GtkWidget *bbox;
	GtkWidget *table;
	GtkWidget *scroll_window;
	GtkWidget *label,*label1,*label2;
	GtkWidget *block_ip,*unblock_ip,*log,*ip_stats;

	//Opening database connection
	rc = sqlite3_open ("proxyDB.sqlite", &db1);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db1));
		sqlite3_close (db1);
		exit (1);
	}
  
  	gtk_init (&argc, &argv);

  	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  	gtk_window_set_title (GTK_WINDOW (window), "Proxy Server");
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  	gtk_window_set_default_size (GTK_WINDOW (window), 500, 500);
  	g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (on_window_destroy), NULL);	
	
	scroll_window = gtk_scrolled_window_new(NULL, NULL);

	
	entry = gtk_entry_new();
  	gtk_entry_set_text(GTK_ENTRY(entry), "0.0.0.0");
	

	port = gtk_entry_new();
  	gtk_entry_set_text(GTK_ENTRY(port), "8080");
	
	label1 = gtk_label_new("IP Address/Website");
	label2 = gtk_label_new("Port");
	

	vbox = gtk_vbox_new (FALSE, 2);
  	gtk_container_add (GTK_CONTAINER (window), vbox);
	
	label=gtk_label_new("\nIn order to configure  Proxy Server to a particular port give 'Port Number',\n          to Block/Unblock IP/destinataions give 'IP Address/Website', \n                and to View Logs and Per IP Statistitcs Press Buttons. \n\n");
	gtk_box_pack_start (GTK_BOX (vbox), label, 0, 0, 0);
	
	table = gtk_table_new(1, 1, TRUE);
	gtk_box_pack_start(GTK_BOX(vbox), table, 0, 0, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), label1, 0, 1, 0, 1 );	
	gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, 0, 1 );
  	gtk_table_attach_defaults(GTK_TABLE(table), label2, 2.5, 3, 0, 1 );	
	gtk_table_attach_defaults(GTK_TABLE(table), port, 3, 4, 0, 1 );
  
	

 	bbox = gtk_hbutton_box_new ();
  	gtk_box_pack_start (GTK_BOX (vbox), bbox, 0, 0, 0);


	text_view = gtk_text_view_new ();
	gtk_container_add (GTK_CONTAINER (scroll_window), text_view);
  	gtk_box_pack_start (GTK_BOX (vbox), scroll_window, 1, 1, 0);
  	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));

	block_ip = gtk_button_new_with_label ("Block IP");
	g_signal_connect(G_OBJECT(block_ip),"clicked",G_CALLBACK(block), (gpointer)entry);
  	gtk_container_add (GTK_CONTAINER (bbox), block_ip);

	unblock_ip = gtk_button_new_with_label ("UnBlock IP");
	g_signal_connect(G_OBJECT(unblock_ip),"clicked",G_CALLBACK(unblock), (gpointer)entry);
  	gtk_container_add (GTK_CONTAINER (bbox), unblock_ip);

	log = gtk_button_new_with_label ("View Log");
	g_signal_connect(G_OBJECT(log),"clicked",G_CALLBACK(display_log), (gpointer)buffer);
  	gtk_container_add (GTK_CONTAINER (bbox), log);

	ip_stats = gtk_button_new_with_label ("IP Statistics");
	g_signal_connect(G_OBJECT(ip_stats),"clicked",G_CALLBACK(display_usage), (gpointer)buffer);
  	gtk_container_add (GTK_CONTAINER (bbox), ip_stats);

	start = gtk_button_new_with_label ("Start Server");
	g_signal_connect(G_OBJECT(start),"clicked",G_CALLBACK(start_server), (gpointer)port);
  	gtk_container_add (GTK_CONTAINER (bbox), start);

	stop = gtk_button_new_with_label ("Stop Server");
	g_signal_connect(G_OBJECT(stop),"clicked",G_CALLBACK(stop_server), (gpointer)start);
  	gtk_container_add (GTK_CONTAINER (bbox), stop);
	gtk_widget_set_sensitive(stop, FALSE);

	gtk_widget_show_all (window);

  	gtk_main ();
  	return 0;
}

	
  	
