#include <unistd.h>	//for close(), write(), read(), fstat(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(), atoi(),
#include <string.h>	//for strlen(),strcpy()
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(), fstat(), open()
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <sys/stat.h>	//for fstat(), open()
#include <fcntl.h>	//for open(),
#include <netdb.h>          /* hostent struct, gethostbyname() */
#include <arpa/inet.h>      /* inet_ntoa() to format IP address */
#include <gtk/gtk.h>	//since port no. is passed through gtk entry, for creating object GtkWidget *widget1
#include <sqlite3.h>

#define BUFFER 4096
#define MAX_QUEUE_SIZE 32
#define SERVER_PORT 8080
#define MAX_URL_SIZE 256 	//maximum url length

typedef struct queue Queue;

sqlite3 *db2;
char *zErrMsg1 = 0;
int rc1;
char sql_query1[BUFFER];
int flag;

/** This is a callback function for sqlite. It is called when any SELECT query
  * is executed in sql database. Here it is used to detect if any record satisfying the query 
  * exists in database or not.
  * @param argc no. of tuples in a record which is passed automatically by sqlite
  * @param argv values in a record which is also passed automatically by sqlite
  *
  */
static int callback1 (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    int i;
    flag = 1;
    if(argc)
    {
	flag=0;
    }
    for (i = 0; i < argc; i++)
    {
	printf ("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf ("\n");
    return 0;
}

/** To check whether ip is blocked or not
  *
  */
int is_blocked(char *host_ip)
{
    flag = 1;
    sprintf(sql_query1, "SELECT blocked_ip from blocked_ip where blocked_ip='%s'", host_ip);
    rc1 = sqlite3_exec (db2, sql_query1, callback1, 0, &zErrMsg1);
    if (rc1 != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg1);
	// This will free zErrMsg if assigned 
	if (zErrMsg1)
	    sqlite3_free (zErrMsg1);
    }

    if(flag)
    {
	//no records found... Not blocked
	return 1;
    }
    else
    {
	//ip blocked
	return 0;
    }
}

/** It will update database table usage_details, where network usage per IP statistics is updated.
  *
  */
int update_usage(char *client_ip, unsigned long long int bytes_downloaded, unsigned long long int bytes_uploaded)
{
    flag = 1;
    sprintf(sql_query1, "SELECT client_ip from usage_details where client_ip='%s'", client_ip);
    rc1 = sqlite3_exec (db2, sql_query1, callback1, 0, &zErrMsg1);
    if (rc1 != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg1);
	// This will free zErrMsg if assigned 
	if (zErrMsg1)
	    sqlite3_free (zErrMsg1);
    }

    if(flag)
    {
	//no records found... Need to insert
	    sprintf(sql_query1, "INSERT into usage_details values('%s', %llu, %llu)", client_ip, bytes_downloaded, bytes_uploaded);
	    rc1 = sqlite3_exec (db2, sql_query1, callback1, 0, &zErrMsg1);
	    if (rc1 != SQLITE_OK)
	    {
		fprintf (stderr, "SQL error: %s\n", zErrMsg1);
		// This will free zErrMsg if assigned 
		if (zErrMsg1)
		    sqlite3_free (zErrMsg1);
	    }	
	return 1;
    }
    else
    {
	//record present ... Need to update
	    sprintf(sql_query1, "UPDATE usage_details SET downloads = downloads + %llu, uploads = uploads + %llu where client_ip='%s'", bytes_downloaded, bytes_uploaded, client_ip);
	    rc1 = sqlite3_exec (db2, sql_query1, callback1, 0, &zErrMsg1);
	    if (rc1 != SQLITE_OK)
	    {
		fprintf (stderr, "SQL error: %s\n", zErrMsg1);
		// This will free zErrMsg if assigned 
		if (zErrMsg1)
		    sqlite3_free (zErrMsg1);
	    }	
	return 0;
    }

}

struct queue
{
	int data[MAX_QUEUE_SIZE];
	int front;
	int back;
}; 

int listen_file_descriptor;
char filename[100];///="index.html";
char path[BUFFER];

int enqueue(Queue *q, int elt)
{
	if((q->back+1)%MAX_QUEUE_SIZE == q->front) return 0;
	
	q->data[q->back] = elt;
	q->back = (q->back+1) % MAX_QUEUE_SIZE;
	return 1;
}

int dequeue(Queue *q)
{
	if(q->back == q->front) return -1;
	
	int ret = q->data[q->front];
	q->front = (q->front+1) % MAX_QUEUE_SIZE;
	return ret; 
}

//This function returns char * of IP Address string of a sockfd supplied otherwise NULL is returned
char *get_ip_from_sockfd(int sockfd)
{
	struct sockaddr_in addr;
	//initialize struct server_address to all zeros.
    	bzero(&addr, sizeof(addr));
	socklen_t addrlen = sizeof(addr);
	if(getsockname (sockfd, (struct sockaddr *) &addr, &addrlen)<0) return NULL;
	printf("Inside get_ip_from_sockfd : Ip is %s\n", inet_ntoa(addr.sin_addr));
	return inet_ntoa(addr.sin_addr);
}

void Close(int fd)
{
    int return_value;
    return_value=close(fd);
    if(return_value<0)
    {
	fprintf(stderr, "Cannot close\n");
	perror("REASON");
	//return return_value;
    }
}


void close_properly(int signal)
{
    printf("Shutting down...\n");
    Close(listen_file_descriptor);
    printf("Shutdown complete.\n");
    exit(0);
}


ssize_t Write(int fd, const void *buf, size_t count)
{
    ssize_t return_value;
    return_value=write(fd,buf,count);
    if(return_value < 0)
    {
	perror("Write failed\n");
	return -1;
    }
    return return_value;
}


int Socket(int domain, int type, int protocol)
{
    int return_value;
    return_value = socket(domain, type, protocol);
    if(return_value < 0)
    {
	fprintf(stderr, "Cannot open socket.\n");
	perror("REASON");
	exit(1);
    }
    return return_value;
}


void check_argument(int argc, char *argv[])
{
    if(argc < 2)
    {
	fprintf(stderr, "usage: %s <port_number> \n", argv[0]);
	exit(1);
    }
}


void Bind(int  sockfd,  const  struct  sockaddr *my_addr, socklen_t addrlen)
{
    int return_value;
    return_value= bind(sockfd,my_addr,addrlen);
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(1);
    }
}


void Listen(int sockfd, int backlog)
{
    int return_value;
    return_value = listen(sockfd, backlog);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(1);
    }
}


int Open(const char *pathname, int flags)
{
    int file_descriptor;
    file_descriptor=open(pathname,flags);
    if(file_descriptor < 0)
    {
	fprintf(stderr, "Cannot open file\n");
	perror("REASON");
	//exit(1);
    }
    return file_descriptor;
}
   

void Fstat(int filedes, struct stat *buf)
{
    int return_value;
    return_value = fstat(filedes,buf);
    if(return_value == -1)
    {
	fprintf(stderr, "Cannot read file status\n");
	perror("REASON");
	exit(1);
    }
}


int Accept(int sockfd, struct sockaddr *addr, socklen_t *addrlen)
{
    int file_descriptor;
    file_descriptor = accept(sockfd, addr, addrlen);
    if(file_descriptor < 0)
    {
	perror("accept() failed.");
	return -1;
    }
    return file_descriptor;
}


ssize_t Read(int fd, void *buf, size_t count)
{
    ssize_t characters_read;
    characters_read = read(fd, buf, count);
    if(characters_read < 0)
    {
	perror("Can't read");
	return -1;
    }
    return characters_read;
}

/** This function is called from proxy_server_main() to get file_descriptor of host
  * It reads the client's url request header and connects to destination using proxy.iiit.ac.in,
  * If website is in intranet then it directly connects to web server.
  *
  */
int get_host_file_descriptor(int connection_file_descriptor, char *host_url)
{
    int host_file_descriptor;
    int linecnt=0;
    char *token;
    char host[BUFFER] = "Host:";	//for strtok to break Host
    char *delim = host;
    char *heystack, *needle = host;
    struct hostent *host_struct;
    struct in_addr h_addr;    /* internet address */
    struct in_addr ip_10, ip_172, ip_192;
    struct in_addr mask_10, mask_172, mask_192;
    struct sockaddr_in host_address;
    char host_ip[256];
    int is_intranet = 0;
    int host_port = 80;
    char request_buffer[100][BUFFER];
    int characters_read;
    int i,j;
	
	//initialization for next connection starts here
	linecnt = 0;
	strcpy(host,"Host:");
	delim = host;
	needle = host;
	is_intranet = 0;
     	host_port = 80;
	
	printf("____________________________\n\n");
	
	//storing the whole request in an array of strings.
	do
	{
		characters_read = Read(connection_file_descriptor, &request_buffer[linecnt], 4094);
		if(characters_read <= 0)
			break;
		request_buffer[linecnt][characters_read] = '\0';
		///printf("%s",request_buffer[linecnt]);
		linecnt++;
		//printf("No. of line read = %d No. of characters read = %d\n", linecnt,characters_read);
		token = strtok(request_buffer[linecnt], "\r\n\r\n");
		if(token == NULL)
			break;
		
	}while(characters_read > 0);

	//Getting Host name and converting to its ip
	for(i=0;i<linecnt;i++)
	{
		heystack = &request_buffer[i][0];
		token = strstr(heystack, needle);	//delim already initialised at declaration above delim->"Host:"
		if(token!=NULL)
		{
			//copying exact host url to host
			for(j=6; token[j]!='\r' && token[j]!='\r'; j++)	//host string starts from 6th char to \n or \r
			{
				host[j-6] = token[j];
			}
			host[j-6] = '\0';
			printf("Host=%s\n", host);
			//copying host url 
			strcpy(host_url, host);

			break;	//break for outer for loop
		}
	}

	//Converting host address to its IP
	if (token == NULL) {
          fprintf(stderr, "Can not get host information\n");
          return -1;
        }
        host_struct = (struct hostent *)gethostbyname(host);
    	if (host_struct == NULL)
	{
        	fprintf(stderr,"ERROR, no such host\n");
        	return -1;
    	}
        h_addr.s_addr = *((unsigned long *) host_struct->h_addr_list[0]);
	strcpy(host_ip, inet_ntoa(h_addr));
        fprintf(stdout, "Host IP=%s\n", inet_ntoa(h_addr));
	
	if(is_blocked(host_ip) == 0 || is_blocked(host_url) == 0)	//if ip is blocked
	{
		printf("This Website is blocked.. IP:%s\n",host_ip);
		return -1;
	}
		

	//now checking IP if available in intranet 10... 172.. 192..
	inet_aton("10.0.0.0", &ip_10);
	inet_aton("172.16.0.0", &ip_172);
	inet_aton("192.168.0.0", &ip_192);
	inet_aton("255.0.0.0", &mask_10);
	inet_aton("255.240.0.0", &mask_172);
	inet_aton("255.255.0.0", &mask_192);
	if(	((h_addr.s_addr & mask_10.s_addr) == ip_10.s_addr)
		|| ((h_addr.s_addr & mask_172.s_addr) == ip_172.s_addr)
		|| ((h_addr.s_addr & mask_192.s_addr) == ip_192.s_addr)
		   )
	{
		is_intranet = 1;
	}
	
	//If not an intranet website(is_intranet=0), then host will be proxy.iiit.ac.in
	if(is_intranet == 0)
	{
		host_struct = (struct hostent *)gethostbyname("proxy.iiit.ac.in");
    		if (host_struct == NULL)
		{
        		fprintf(stderr,"ERROR, no such host proxy.iiit.ac.in\n");
        		return -1;
    		}
        	h_addr.s_addr = *((unsigned long *) host_struct->h_addr_list[0]);	//host ip = ip of proxy.iiit.ac.in
		strcpy(host_ip, inet_ntoa(h_addr));
        	
		host_port = 8080;	//host port = 8080 port of proxy
	}

	//procedure of coonecting to host
	//try to open socket
    	host_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);

   	//if socket opening failed then print error message and quit
    	if(host_file_descriptor < 0)
    	{
		fprintf(stderr, ": cannot open socket.\n");
		return -1;
    	}

	//initialize struct server_address to all zeros.
    	bzero(&host_address, sizeof(host_address));

    	//set the protocol used to be ipv4
    	host_address.sin_family = AF_INET;

    	//set the port to be 80 0r 8080 stored in host_port, by default tcp day time servers
    	host_address.sin_port = htons(host_port);

    	//set the ip address of server
	//host_address.sin_addr = h_addr;
	if(inet_pton(AF_INET, inet_ntoa(h_addr), &host_address.sin_addr) <= 0)	//where inet_ntoa(h_addr) will return IP in string 
    	{
		fprintf(stderr, ": the supplied ipv4 address  is incorrect.\n");
		return -1;
    	}

	//connecting to host
	if(connect(host_file_descriptor, (struct sockaddr *) &host_address, sizeof(host_address)) < 0)
    	{
		fprintf(stderr, ": cannot connect to host %s\n", inet_ntoa(h_addr));
		return -1;
    	}
   
	//write the request packet came from client to host which is already stored in char request_buffer[][]
	for(i=0; i<linecnt; i++)
	{
		write(host_file_descriptor, request_buffer[i], strlen(request_buffer[i]));
	}
	return host_file_descriptor;
}

/** This is where proxy server execution starts. It is called when clicked on Start Server 
  * button from GUI, and stops when Stop Server is clicked.
  * @param server_port it will be used to configure the server to listen on this port
  *
  */
int proxy_server_main(int server_port)
{
    int connection_file_descriptor[MAX_QUEUE_SIZE]; 
    int host_file_descriptor[MAX_QUEUE_SIZE];
    unsigned long long int total_bytes_sent[MAX_QUEUE_SIZE];
    unsigned long long int total_bytes_received[MAX_QUEUE_SIZE];
    int connection_count = 0;
    char input_data[BUFFER];
   
    char host_url[MAX_QUEUE_SIZE][MAX_URL_SIZE];
    struct sockaddr_in server_address;
    struct sigaction act1;
    struct sockaddr_in client_addr[MAX_QUEUE_SIZE];
    socklen_t addrlen = sizeof(client_addr[0]);
    int characters_read;
    
    fd_set read_file_descriptor_set;
    int read_descriptor;
    int write_descriptor;
    int return_value;
    int optval = 1;	//used to handle bind error
    
    time_t ticks;	//used to store time in ticks temporarily
    char time_string[BUFFER];

    int highsock;	//for slecect function's first argumrnt highsock+1
    Queue q;	//structure of queue type
    q.front = 0;	//initialization
    q.back = 0;		//queue is empty
    int i,j;
    
    
    //get port name 
    if(server_port <= 0)		//checking valid port is given
    {
    	server_port = SERVER_PORT;	
    }

    //Opening database connection
    rc1 = sqlite3_open ("proxyDB.sqlite", &db2);
    if (rc1)
    {
	fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db2));
	sqlite3_close (db2);
    }

    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;
    sigaction(SIGINT, &act1, 0);

    
    listen_file_descriptor = Socket(AF_INET, SOCK_STREAM, 0);
    setsockopt(listen_file_descriptor, SOL_SOCKET, SO_REUSEADDR, (void *)&optval, sizeof(optval));	//used to handle bind error TIME-WAIT

    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(server_port);
    Bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    Listen(listen_file_descriptor, MAX_QUEUE_SIZE);
    


	//Now select function will work inside while loop for read and write
	while(1)
	{
	    //should be under while loop 
	    //as select would modify this set and clear fds where we cant read without getting blocked
	    FD_ZERO(&read_file_descriptor_set);
	    FD_SET(listen_file_descriptor, &read_file_descriptor_set);
	    highsock = listen_file_descriptor;
	    for(j=0; j<connection_count; j++)
	    {
		i = (j+q.front) % MAX_QUEUE_SIZE;	//i is index in Queue
		if(connection_file_descriptor[i] == -1)
			continue;
	    	FD_SET(connection_file_descriptor[i], &read_file_descriptor_set);
		if(highsock<connection_file_descriptor[i])
			highsock = connection_file_descriptor[i];
	    	FD_SET(host_file_descriptor[i], &read_file_descriptor_set);
		if(highsock<host_file_descriptor[i])
			highsock = host_file_descriptor[i];
	    }

	    //block till can read from one of the two file descriptors
	    return_value =select(highsock+1, &read_file_descriptor_set, NULL, NULL, NULL);
	    if(return_value<0)
	    {
		perror("Select failed");
		exit(EXIT_FAILURE);
	    }

	    //see if listen_socket can be read that means we have new connection in queue, so accept it
	    if(FD_ISSET(listen_file_descriptor, &read_file_descriptor_set))
	    {
		addrlen = sizeof(client_addr[q.back]);	//for passing it to accept()

		//[q.back] is the ith connection  and extrcting IP of client using accept()
		connection_file_descriptor[q.back] = accept(listen_file_descriptor, (struct sockaddr *) &client_addr[q.back],&addrlen);	

		if(connection_file_descriptor[q.back] < 0)
		{
		    perror("accept() failed.");
		    //exit(EXIT_FAILURE);
		}
		else
		{
		    //User defined function for getting actual host file descriptor
		    host_file_descriptor[q.back] = get_host_file_descriptor(connection_file_descriptor[q.back], host_url[q.back]);	
		    
		    if(host_file_descriptor[q.back] < 0)	//if unable to get host_file_descriptor
		    {
			fprintf(stderr, ": can not connect to host.\n");
			Close(connection_file_descriptor[q.back]);
			printf("Connection to client closed\n");
			connection_file_descriptor[q.back] = -1;
			//return -1;
		    }
		    else
		    {
			    total_bytes_sent[q.back] = 0;	//total bytes uploaded=0
			    total_bytes_received[q.back] = 0;	//total bytes downloaded=0
			    connection_count++;			//incrementing Counter no. of clients connected
			    if(enqueue(&q,1) != 1)
				printf("Error:Queue size exceeds\n");
			    printf("Got client%d for connection1. HostFD=%d ConnectionFD=%d\n",connection_count,host_file_descriptor[q.back-1], connection_file_descriptor[q.back-1]);
		    }
		}
	    }	

	    for(j=0; j<connection_count; j++)
	    {
		    i = (j+q.front) % MAX_QUEUE_SIZE;	//i is index in Queue
		    if(connection_file_descriptor[i] == -1)	//for safety purpose checking invalid descriptor
			continue;
		    //see from which descriptor we can read and set variables
		    //read_descriptor and write_descriptor appropriately
		    if(FD_ISSET(host_file_descriptor[i], &read_file_descriptor_set))
		    {
			    read_descriptor=host_file_descriptor[i];
			    write_descriptor=connection_file_descriptor[i];

			    //read from read_descriptor and write to write_descriptor
			    characters_read=read(read_descriptor, input_data, BUFFER-1);
			    if(characters_read > 0)
			    {
				input_data[characters_read]='\0';
				write(write_descriptor, input_data, characters_read);
				total_bytes_received[i] = total_bytes_received[i] + characters_read;
			    }
			    else if(characters_read<0)
			    {
				perror("Read failed");
				break;
			    }
			    else
			    {
				// characters_read=0, and return on blocking IO means connection1 closed.
				printf("Connection seems to be closed\n");
				
				//closing connections
				Close(host_file_descriptor[i]);
				printf("Connection to host closed\n");
				Close(connection_file_descriptor[i]);
				printf("Connection to client closed\n");

				//making timestamp
				ticks = time(NULL);	
				snprintf(time_string, sizeof(time_string), "%.24s", ctime(&ticks));
		
				sprintf(sql_query1, "INSERT into log_details values('%s', '%s', %llu, %llu, '%s')", inet_ntoa(client_addr[i].sin_addr), time_string, total_bytes_received[i], total_bytes_sent[i], host_url[i]);
				rc1 = sqlite3_exec (db2, sql_query1, callback1, 0, &zErrMsg1);
				if (rc1 != SQLITE_OK)
				{
					fprintf (stderr, "SQL error: %s\n", zErrMsg1);
					// This will free zErrMsg if assigned 
					if (zErrMsg1)
					    sqlite3_free (zErrMsg1);
				}

				//updating per user IP statistics
				update_usage(inet_ntoa(client_addr[i].sin_addr), total_bytes_received[i], total_bytes_sent[i]);

				connection_count--;
				if(dequeue(&q) == -1)
					printf("Error: Queue is empty\n");
				connection_file_descriptor[i] = -1;	//to detect in array this is invalid FD
				break;
			    }
		    }
		    if(FD_ISSET(connection_file_descriptor[i], &read_file_descriptor_set))
		    {
			    read_descriptor=connection_file_descriptor[i];
			    write_descriptor=host_file_descriptor[i];
			    
			    //read from read_descriptor and write to write_descriptor
			    characters_read=read(read_descriptor, input_data, BUFFER-1);
			    if(characters_read > 0)
			    {
				input_data[characters_read]='\0';
				write(write_descriptor, input_data, characters_read);
				total_bytes_sent[i] = total_bytes_sent[i] + characters_read;	
			    }
			    else if(characters_read<0)
			    {
				perror("Read failed");
				break;
			    }
			    else
			    {
				// characters_read=0, and return on blocking IO means connection1 closed.
				printf("Connection seems to be closed\n");
				
				//closing connections
				Close(host_file_descriptor[i]);
				printf("Connection to host closed\n");
				Close(connection_file_descriptor[i]);
				printf("Connection to client closed\n");
				
				//making timestamp
				ticks = time(NULL);	
				snprintf(time_string, sizeof(time_string), "%.24s", ctime(&ticks));
			
				sprintf(sql_query1, "INSERT into log_details values('%s', '%s', %llu, %llu, '%s')", inet_ntoa(client_addr[i].sin_addr), time_string, total_bytes_received[i], total_bytes_sent[i], host_url[i]);
				rc1 = sqlite3_exec (db2, sql_query1, callback1, 0, &zErrMsg1);
				if (rc1 != SQLITE_OK)
				{
					fprintf (stderr, "SQL error: %s\n", zErrMsg1);
					// This will free zErrMsg if assigned 
					if (zErrMsg1)
					    sqlite3_free (zErrMsg1);
				}

				//updating per user IP statistics
				update_usage(inet_ntoa(client_addr[i].sin_addr), total_bytes_received[i], total_bytes_sent[i]);

				connection_count--;	//decrementing counter
				if(dequeue(&q) == -1)	//removing FD entry from queue
					printf("Error: Queue is empty\n");
				connection_file_descriptor[i] = -1;	//to detect in array this is invalid FD
				break;
			    }
		    }    
	    }
	}

    return 0;
}

