/**
 * compile with the following command
 * gcc -Wall -g hello.c -o hello `pkg-config --cflags gtk+-2.0` `pkg-config --libs gtk+-2.0`
 */
/**
  @author P.ANIL REDDY
 */
#include <gtk/gtk.h>
#include <gtk/gtk.h>
#include <stdio.h> //for printf(),
#include <unistd.h> //for close(),
#include <stdlib.h> //for exit(),
#include <string.h> //for strcpy(), strlen()
#include <strings.h> //for bzero(),
#include <sys/socket.h> //for socket(), inet_pton()
#include <sys/types.h> //for socket(), inet_pton()
#include <arpa/inet.h> //for htons(), inet_pton()
#include <netinet/in.h> //for struct sockaddr_in,
#define LISTEN_PORT 9999
#define BUFFER_SIZE 4096*1000
#define WAIT_TIME 10

int  login_window();
int  welcome();
int  useracc();
char uname[100];
char pwd[100];
char name[100];
char pass[100];
char login[100];
char orga[100];
char email[100];
char srch[100];
char uplod[100];
char file[1000];
char fnd[1000];
char ip[100];
char new[1000];
char msg0[1000],msg1[1000],msg2[1000],msg3[1000],msg4[BUFFER_SIZE],msg5[1000];
GtkWidget *window1;
GtkWidget *window2;
GtkWidget *windowL;
GtkWidget *window3;
char input_data[BUFFER_SIZE];
int socket_file_descriptor; 

/** connect the server
 * @param output_data
 * @param ip 
 */

char* connect_server(char* output_data,char *ip)
{
	int character_written;
	struct sockaddr_in server_address;


	socket_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);

	bzero(&server_address, sizeof(server_address));
	server_address.sin_family = AF_INET;
	server_address.sin_port = htons(LISTEN_PORT);
	if(inet_pton(AF_INET, ip, &server_address.sin_addr) <= 0)
	{
		printf("Error;the supplied ipv4 address is incorrect\n");
		exit(EXIT_FAILURE);
	}

	if(connect(socket_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address)) < 0)
	{
		printf("cannot connect to server \n");
		exit(EXIT_FAILURE);
	}
	character_written = write(socket_file_descriptor, output_data, strlen(output_data));
	if(character_written < 0)
	{
		printf("Write error\n");
		exit(EXIT_FAILURE);
	}
	int characters_read=0;
	
	characters_read=read(socket_file_descriptor, input_data, BUFFER_SIZE-1);
	if(characters_read > 0)
	{
		input_data[characters_read]='\0';
		printf("Received %d bytes from connection1 : %s\n", characters_read, input_data);
	}
	// printf("\n");
	return input_data;
}

/** Delete Event processing, returning FALSE allows the window to be destroyed, TRUE would stop further processing and window remains.
 *@param widget
 *@param event
 *@param usre_data
 */
gboolean delete1 (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	return FALSE;
}

/**  Exit the Gtk Main Loop
 *@param object
 *@param usre_data
 */
void destroy1 (GtkObject *object, gpointer user_data)
{

	//   gtk_main_quit();   // Exit the Gtk Main Loop
}

/** Perform the update of the label of username
 *@param entry1
 *@param event
 *@param label1
 */
gboolean update1 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("0 ", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(uname,str);

		g_free(str);
	}
	else 
	{
		gtk_label_set_text(GTK_LABEL(label1), NULL);
	}

	return TRUE;
}
/** Perform the update of the label of password
 *@param entry1
 *@param event
 *@param label1
 */
gboolean update2 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{
	gtk_entry_set_visibility(entry1,FALSE);
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(pwd,str);
		g_free(str);
	}
	else
	{
		gtk_label_set_text(GTK_LABEL(label1), NULL);
	}

	return TRUE;
}
/** Perform the update of the label of user fullname
 *@param entry1
 *@param event
 *@param label1
 */
gboolean fun1 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{  
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(name,str);
		g_free(str);
	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform the update of the label of email-id
 *@param entry1
 *@param event
 *@param label1
 */
gboolean fun2 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{

	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(email,str);
		g_free(str);
	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}

/** Perform the update of the label of login-id
 *@param entry1
 *@param event
 *@param label1
 */
gboolean fun3 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{  
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(login,str);
		g_free(str);
	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform the update of the label of password
 *@param entry1
 *@param event
 *@param label1
 */
gboolean fun4 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{  
	gtk_entry_set_visibility(entry1,FALSE);
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(pass,str);
		g_free(str);
	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform the update of the label of organization
 *@param entry1
 *@param event
 *@param label1
 */
gboolean fun5 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{  
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(orga,str);
		g_free(str);
	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform the update of the label of search Query
 *@param entry1
 *@param event
 *@param label1
 */
gboolean funs1 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{ 
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(srch,str);
		g_free(str);
	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform the update of the label of filename to upload
 *@param entry1
 *@param event
 *@param label1
 */
gboolean funs2 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{ 
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(uplod,str);
		g_free(str);

	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform the update of the label of download a file
 *@param entry1
 *@param event
 *@param label1
 */
gboolean funs3 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{ 
	if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
	{
		gchar *str = NULL;
		str = g_strconcat("", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);
		strcpy(fnd,str);
		g_free(str);

	}
	else 
		gtk_label_set_text(GTK_LABEL(label1), NULL);

	return TRUE;
}
/** Perform when click the submit button 
 *@param widget
 *@param window
 */
void submit1( GtkWidget *widget, gpointer   window )
{
	msg1[0]='\0';
	strcat(msg1,"1 ");
	strcat(msg1,name);
	strcat(msg1," ");
	strcat(msg1,email);
	strcat(msg1," ");
	strcat(msg1,login);
	strcat(msg1," ");
	strcat(msg1,pass);
	strcat(msg1," ");
	strcat(msg1,orga);
	printf("msg1=%s\n",msg1);

	if(strlen(name)==0 || strlen(pass)==0 || strlen(login)==0 || strlen(orga)==0 || strlen(email)==0)
	{
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Fill All fields", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	}
	else if(strlen(pass)<6)
	{
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Password Length must be > 6 charecters", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	}
	else
	{
		char* result=connect_server(msg1,ip);
		printf("The result is...%s\n",result);
		if(!strcmp(result,"success"))
		{
			printf("The result is...");
			gtk_widget_destroy(window1);
			GtkWidget *dialog;
			dialog = gtk_message_dialog_new(window,
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_INFO,
					GTK_BUTTONS_OK,
					"Successfully Registered", "title");
			gtk_window_set_title(GTK_WINDOW(dialog), "Welcome");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
		}
		else
		{
			GtkWidget *dialog;
			dialog = gtk_message_dialog_new(window,
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_INFO,
					GTK_BUTTONS_OK,
					result, "title");
			gtk_window_set_title(GTK_WINDOW(dialog), "Fail");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
		}

	}
}


/** Perform when click the close button
 *@param widget
 *@param window
 */
void clos1( GtkWidget *widget, gpointer   data )
{
	gtk_widget_destroy(window1);

}

/** Perform when click the submit button
 *@param widget
 *@param window
 */
void submit( GtkWidget *widget, gpointer   window )
{
	msg0[0]='\0';
	strcat(msg0,uname);
	strcat(msg0," ");
	strcat(msg0,pwd);
	printf("msg0=%s\n",msg0);
	if(strlen(uname)==0 || strlen(pwd)==0)
	{
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Incorrect UserName and password", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	}
	else
	{
		//connect to server....and user id password
		char *result=connect_server(msg0,ip);
		printf("The result is:%s\n",result);
		if(!strcmp(result,"success"))
		{
			gtk_widget_destroy(windowL);
			useracc();
		}
		else
		{
			GtkWidget *dialog;
			dialog = gtk_message_dialog_new(window,
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_INFO,
					GTK_BUTTONS_OK,
					result, "title");
			gtk_window_set_title(GTK_WINDOW(dialog), "Fail");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
		}

		
	}
}

/** Perform when click the close button
 *@param widget
 *@param data
 */
void clos( GtkWidget *widget, gpointer   data )
{
	gtk_main_quit();  
}

/** Perform when click the newuser button
 *@param widget
 *@param data
 */
void newuser( GtkWidget *widget, gpointer   data )
{
	welcome();
}
/** Perform when click the search button
 *@param widget
 *@param window
 */
void search( GtkWidget *widget, gpointer   window )
{
	if(strlen(srch)!=0)
	{
		msg2[0]='\0';
		strcat(msg2,"2 ");
		strcat(msg2,srch);
		printf("msg2=%s\n",msg2);
		char* result=connect_server(msg2,ip);
		printf("RECIVED:%s\n",result);
		strcpy(new,result);
		search_window();
	}
	else
	{
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Enter Any Query", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	}
}

/** Perform when click the upload button
 *@param widget
 *@param window
 */
void upload( GtkWidget *widget, gpointer   window )
{
	if(strlen(uplod)==0)
	{
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Incorrect", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	}
	else
	{
		msg3[0]='\0';
		strcat(msg3,"3 ");
		int i=0,j=0;
		FILE * hFile;
		hFile = fopen( uplod, "r");
		if(hFile==NULL)
		{
			GtkWidget *dialog;
			dialog = gtk_message_dialog_new(window,
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_INFO,
					GTK_BUTTONS_OK,
					"File not present!", "title");
			gtk_window_set_title(GTK_WINDOW(dialog), "Error");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
		}
		else
		{
			char c;
			msg4[0]='\0';
			strcat(msg4,"4 ");
			i=2;
			while((c=getc(hFile))!=EOF) 
			{
				msg4[i++]=c;
			}
			msg4[i]=EOF;
			msg4[i+1]='\0';
			printf("msg4=%s\n",msg4);
			for(i=strlen(uplod)-1,j=0;i>=0;i--,j++)
			{
				if(uplod[i]=='/')
					break;
				file[j]=uplod[i];
			}
			for(i=strlen(file)-1,j=0;i>=0;i--,j++)
			{
				uplod[j]=file[i];
			}
			uplod[j]='\0';
			strcat(msg3,uplod);
			printf("msg3=%s\n",msg3);
			//input_data[0]='\0';
			char* result=connect_server(msg3,ip);
			printf("Result is:%s\n",result);
			//input_data[0]='\0';
			GtkWidget *dialog;
			dialog = gtk_message_dialog_new(window,
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_INFO,
					GTK_BUTTONS_OK,
					"Upload successfull", "title");
			gtk_window_set_title(GTK_WINDOW(dialog), "upload");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
			result=connect_server(msg4,ip);
			printf("Result is:%s\n",result);
			

		}  
	}
}
/** Perform when click the logout button
 *@param widget
 *@param window
 */
void logout( GtkWidget *widget, gpointer   window )
{
	char msg[]="6";
	char *result=connect_server(msg,ip);
	close(socket_file_descriptor);
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new(window,
	GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				result, "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "enjoy");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	gtk_main_quit();
}
/** Perform when click the download button
 *@param widget
 *@param window
 */
void find( GtkWidget *widget, gpointer   window )
{
	if(strlen(fnd)==0)
	{

		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Incorrect", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	}
	else
	{
		msg5[0]='\0';
		strcat(msg5,"5 ");	
		strcat(msg5,fnd);
		
		char new_one[100];	
		strcpy(new_one,fnd);

		//printf("MSG5=%s		DESTINATION:%s\n",msg5,new_one);
		char* result=connect_server(msg5,ip);
//		printf("RESULT iiiis:\n%s\n",result);
		if(strcmp(result,"fail")==0)
		{

		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Select the file in list", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	       }
		else
		{
		FILE *fp=fopen(new_one,"w");
		int i=0;
		for(i=0;result[i]!='\0' && result[i]!=EOF && i<7000;i++)
		{
			//printf("%d ",i);
			putc(result[i],fp);
		}
		fflush(fp);
		fclose(fp);
		//gtk_widget_destroy(window3);
//		printf("msg5=%s\n",msg5);
       }
}
}
/** Perform when click the search button
 */
int search_window()
{
	GtkWidget *window3;
	GtkWidget *table;

	GtkWidget *title;
	GtkWidget *halign;
	GtkWidget *wins;
	GtkWidget *label;
	GtkWidget *label1;
	GtkWidget *ok;

	window3 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(window3), GTK_WIN_POS_CENTER);
	gtk_widget_set_size_request (window3, 300, 250);
	gtk_window_set_resizable(GTK_WINDOW(window3), FALSE);

	gtk_window_set_title(GTK_WINDOW(window3), "Search A File");

	gtk_container_set_border_width(GTK_CONTAINER(window3), 15);

	table = gtk_table_new(8, 4, FALSE);
	gtk_table_set_col_spacings(GTK_TABLE(table), 3);

	title = gtk_label_new("Files");
	halign = gtk_alignment_new(0, 0, 0, 0);
	gtk_container_add(GTK_CONTAINER(halign), title);
	gtk_table_attach(GTK_TABLE(table), halign, 0, 1, 0, 1, 
			GTK_FILL, GTK_FILL, 0, 0);

	wins = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(wins), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(wins), FALSE);
	GtkTextBuffer *buffer;
	int x=0,y=0;
	for(x=0;x<strlen(new)&&y<10;x++)
           {
		if(new[x]==' ')
			{
                          new[x]='\n';
			  y++;
			}
	   }

	if(new[0]=='f' &&new[1]=='a' && new[2]=='i' && new[3]=='l')
          {
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new(window3,
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_OK,
				"Invalid Query", "title");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
	 }
        else
         {
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(wins));
	gtk_text_buffer_set_text(GTK_TEXT_BUFFER(buffer),new,strlen(new));
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(wins),GTK_TEXT_BUFFER(buffer));

	gtk_table_attach(GTK_TABLE(table), wins, 0, 2, 1, 3,
			GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);

	ok = gtk_button_new_with_label("Download");
	gtk_widget_set_size_request(ok, 70, 30);
	gtk_table_attach(GTK_TABLE(table), ok, 3, 4, 4, 5, 
			GTK_FILL, GTK_FILL, 0, 0);
	label1 = gtk_label_new (NULL);
	gtk_signal_connect (GTK_OBJECT (ok), "clicked",GTK_SIGNAL_FUNC (find), NULL);
	label = gtk_entry_new();
	gtk_widget_set_size_request(label, 200, 30);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 4, 5, 
			GTK_FILL, GTK_FILL, 0, 0);
	g_signal_connect(G_OBJECT(label), "key-release-event", G_CALLBACK(funs3), label1);
	gtk_container_add(GTK_CONTAINER(window3), table);
	gtk_widget_show_all(window3);
	}
	return 0;
}

/** new user login window
 */
int welcome()
{


	GtkWidget *box,*label1;
	GtkWidget *t1,*entry1;   
	GtkWidget *t2,*entry2;   
	GtkWidget *t3,*entry3;   
	GtkWidget *t4,*entry4;   
	GtkWidget *t5,*entry5;   
	GtkWidget *ok;
	GtkWidget *close;
	GtkWidget *halign;
	GtkWidget *hbox;

	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);                // Create the window
	gtk_container_set_border_width(GTK_CONTAINER(window1),10);     // Set a border around the edges
	gtk_window_set_urgency_hint (GTK_WINDOW(window1), TRUE);       // Send the urgency signal to the window
	gtk_window_set_title (GTK_WINDOW(window1),"Regestration");       // Set the window title
	gtk_widget_show  (window1);                                    // Display the window

	g_signal_connect(G_OBJECT(window1), "delete_event", G_CALLBACK(delete1), NULL);
	// g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(destroy1), NULL);
	box = gtk_vbox_new (FALSE, 0);                                // Create the vbox
	gtk_container_add(GTK_CONTAINER(window1), box);                // Add the vbox to the window
	gtk_widget_show(box);                                         // Display the vbox (although you can't

	t1 = gtk_label_new ("FullName:");   
	gtk_box_pack_start (GTK_BOX (box), t1, TRUE, TRUE, 5);  
	gtk_widget_show(t1);                                   

	entry1 = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry1, TRUE, TRUE, 5);     
	gtk_widget_show(entry1);
	gtk_widget_grab_focus(entry1);
	label1 = gtk_label_new (NULL);
	g_signal_connect(G_OBJECT(entry1), "key-release-event", G_CALLBACK(fun1), label1);

	t2 = gtk_label_new ("Email-id");   
	gtk_box_pack_start (GTK_BOX (box), t2, TRUE, TRUE, 5);  
	gtk_widget_show(t2);                                   

	entry2 = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry2, TRUE, TRUE, 5);     
	gtk_widget_show(entry2);
	gtk_widget_grab_focus(entry2);

	g_signal_connect(G_OBJECT(entry2), "key-release-event", G_CALLBACK(fun2), label1);

	t3 = gtk_label_new ("Login-id");   
	gtk_box_pack_start (GTK_BOX (box), t3, TRUE, TRUE, 5);  
	gtk_widget_show(t3);                                   

	entry3 = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry3, TRUE, TRUE, 5);     
	gtk_widget_show(entry3);
	gtk_widget_grab_focus(entry3);

	g_signal_connect(G_OBJECT(entry3), "key-release-event", G_CALLBACK(fun3), label1);

	t4 = gtk_label_new ("Password");   
	gtk_box_pack_start (GTK_BOX (box), t4, TRUE, TRUE, 5);  
	gtk_widget_show(t4);                                   

	entry4 = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry4, TRUE, TRUE, 5);     
	gtk_widget_show(entry4);
	gtk_widget_grab_focus(entry4);

	g_signal_connect(G_OBJECT(entry4), "key-release-event", G_CALLBACK(fun4), label1);

	t5 = gtk_label_new ("Organization");   
	gtk_box_pack_start (GTK_BOX (box), t5, TRUE, TRUE, 5);  
	gtk_widget_show(t5);                                   

	entry5 = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry5, TRUE, TRUE, 5);     
	gtk_widget_show(entry5);
	gtk_widget_grab_focus(entry5);

	g_signal_connect(G_OBJECT(entry5), "key-release-event", G_CALLBACK(fun5), label1);

	hbox = gtk_hbox_new(TRUE, 3);
	ok = gtk_button_new_with_label("Submit");
	gtk_widget_set_size_request(ok, 70, 30);
	gtk_signal_connect (GTK_OBJECT (ok), "clicked",GTK_SIGNAL_FUNC (submit1), NULL);
	gtk_container_add(GTK_CONTAINER(hbox), ok);
	close = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (close), "clicked",GTK_SIGNAL_FUNC (clos1), NULL);
	gtk_container_add(GTK_CONTAINER(hbox), close);
	halign = gtk_alignment_new(1, 0, 0, 0);
	gtk_container_add(GTK_CONTAINER(halign), hbox);
	gtk_box_pack_start(GTK_BOX(box), halign, FALSE, FALSE, 0);

	gtk_widget_show_all(window1);

	return 0;
}
/** login with user name and password.function for the user window
 */

int useracc()
{

	GtkWidget *table;

	GtkWidget *button1;
	GtkWidget *button2;

	GtkWidget *entry1;
	GtkWidget *entry2;
	GtkWidget *ok;
	GtkWidget *label1;


	window2 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(window2), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(window2), "User Account");
	gtk_container_set_border_width(GTK_CONTAINER(window2), 10);

	table = gtk_table_new(3, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(window2), table);

	entry1 = gtk_entry_new();
	entry2 = gtk_entry_new();

	gtk_table_attach(GTK_TABLE(table), entry1, 0, 1, 0, 1, 
			GTK_FILL | GTK_SHRINK, GTK_FILL | GTK_SHRINK, 5, 5);
	gtk_table_attach(GTK_TABLE(table), entry2, 0, 1, 1, 2, 
			GTK_FILL | GTK_SHRINK, GTK_FILL | GTK_SHRINK, 5, 5);

	button1 = gtk_button_new_with_label("search");
	button2 = gtk_button_new_with_label("upload");

	gtk_signal_connect (GTK_OBJECT (button1), "clicked",GTK_SIGNAL_FUNC (search), NULL);
	gtk_signal_connect (GTK_OBJECT (button2), "clicked",GTK_SIGNAL_FUNC (upload), NULL);
	label1 = gtk_label_new (NULL);
	g_signal_connect(G_OBJECT(entry1), "key-release-event", G_CALLBACK(funs1), label1);
	g_signal_connect(G_OBJECT(entry2), "key-release-event", G_CALLBACK(funs2), label1);
	gtk_table_attach(GTK_TABLE(table), button1, 1, 2, 0, 1, 
			GTK_FILL | GTK_SHRINK, GTK_FILL | GTK_SHRINK, 5, 5);
	gtk_table_attach(GTK_TABLE(table), button2, 1, 2, 1, 2, 
			GTK_FILL | GTK_SHRINK, GTK_FILL | GTK_SHRINK, 5, 5);
	ok = gtk_button_new_with_label("Logout");
	gtk_table_attach(GTK_TABLE(table), ok, 1, 2, 2, 3,
			GTK_FILL | GTK_SHRINK, GTK_FILL | GTK_SHRINK, 5, 5);
	gtk_signal_connect (GTK_OBJECT (ok), "clicked",GTK_SIGNAL_FUNC (logout), NULL);

	gtk_widget_show(table);

	gtk_widget_show(button1);
	gtk_widget_show(button2);
	gtk_widget_show(ok);


	gtk_widget_show(entry1);
	gtk_widget_show(entry2);

	gtk_widget_show(window2);
	return 0;
}
/** main function
 *@param argc
 *@param argv
 */

int main( int   argc, char *argv[] )
{
	if(argc<2){ printf("Please give ip address\n"); return 0;}

	strcpy(ip,argv[1]);
	gtk_init (&argc, &argv);
	login_window();
	return 0;
}

int login_window()
{
	GtkWidget *instruct;   // GtkLabel "Enter Your Name:"
	GtkWidget *entry;      // GtkEntry box
	GtkWidget *instruct1;   // GtkLabel "Enter Your Name:"
	GtkWidget *label1;      // GtkLabel used for Output
	GtkWidget *entry1;      // GtkEntry box
	GtkWidget *box;        // Vertical box for packing widgets in the window

	GtkWidget *ok;
	GtkWidget *close;
	GtkWidget *new;
	GtkWidget *halign;
	GtkWidget *hbox;


	// Create the top-level window
	windowL = gtk_window_new (GTK_WINDOW_TOPLEVEL);                // Create the window
	gtk_container_set_border_width(GTK_CONTAINER(windowL),10);     // Set a border around the edges
	gtk_window_set_urgency_hint (GTK_WINDOW(windowL), TRUE);       // Send the urgency signal to the window manager (e.g make the taskbar entry flash)
	gtk_window_set_title (GTK_WINDOW(windowL),"Login Page");       // Set the window title
	gtk_widget_show  (windowL);                                    // Display the window

	g_signal_connect(G_OBJECT(windowL), "delete_event", G_CALLBACK(delete1), NULL);
	g_signal_connect(G_OBJECT(windowL), "destroy", G_CALLBACK(destroy1), NULL);


	box = gtk_vbox_new (FALSE, 0);                                // Create the vbox
	gtk_container_add(GTK_CONTAINER(windowL), box);                // Add the vbox to the window
	gtk_widget_show(box);                                         // Display the vbox (although you can't actually see anything)
	instruct = gtk_label_new ("UserName:");   
	gtk_box_pack_start (GTK_BOX (box), instruct, TRUE, TRUE, 5);  // Add the widget to the vbox (first item)

	entry = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry, TRUE, TRUE, 5);     // Add the widget to the vbox (second item)
	gtk_widget_grab_focus(entry);
	label1 = gtk_label_new (NULL);
	gtk_box_pack_start (GTK_BOX (box), label1, TRUE, TRUE, 5);
	g_signal_connect(G_OBJECT(entry), "key-release-event", G_CALLBACK(update1), label1);
	instruct1 = gtk_label_new ("Password:");               
	gtk_box_pack_start (GTK_BOX (box), instruct1, TRUE, TRUE, 5);  // Add the widget to the vbox (first item)
	entry1 = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (box), entry1, TRUE, TRUE, 5);     // Add the widget to the vbox (second item)
	gtk_widget_grab_focus(entry1);
	label1 = gtk_label_new (NULL);
	gtk_box_pack_start (GTK_BOX (box), label1, TRUE, TRUE, 5);    // Add the widget to the vbox (third item)
	gtk_widget_show_all(box);
	g_signal_connect(G_OBJECT(entry1), "key-release-event", G_CALLBACK(update2), label1);

	hbox = gtk_hbox_new(TRUE, 3);

	ok = gtk_button_new_with_label("Login");
	gtk_widget_set_size_request(ok, 70, 30);
	gtk_signal_connect (GTK_OBJECT (ok), "clicked",GTK_SIGNAL_FUNC (submit), NULL);
	gtk_container_add(GTK_CONTAINER(hbox), ok);
	close = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (close), "clicked",GTK_SIGNAL_FUNC (clos), NULL);
	gtk_container_add(GTK_CONTAINER(hbox), close);
	new = gtk_button_new_with_label("New User!");
	gtk_signal_connect (GTK_OBJECT (new), "clicked",GTK_SIGNAL_FUNC (newuser), NULL);
	gtk_container_add(GTK_CONTAINER(hbox), new);


	halign = gtk_alignment_new(1, 0, 0, 0);
	gtk_container_add(GTK_CONTAINER(halign), hbox);

	gtk_box_pack_start(GTK_BOX(box), halign, FALSE, FALSE, 0);


	gtk_widget_show_all(windowL);



	gtk_main (); // Start the Gtk Main Loop

	return 0;
}
