#include<stdlib.h>
#include<stdio.h>
#include<ctype.h>
#include<mysql/mysql.h>
#include<string.h>
#include<gtk/gtk.h>

/** mainProject.c generates the GUI using which the events can be added,edited and suitably deleted and also writes them into a database.
 * @file mainProject.c
 * @version 1.0
 * @author Ankit Sharma, Rameez Meheboob
 **/


/*-----------------------Function to calculate day--------------------*/
typedef struct
{
    /*{*/
    int dd; /**< day of a date */
    int mm; /**< month of a date */
    int yy; /**< the year of a date */
    /*@}*/
}date;

/*------------------------Time calculating functions-------------------*/


/** week_calc return the day of a week for a given date
  * @returns void
  * @param tp structure variable to receive the date whose correspoding week has to be found
  * @param d pointer where day of the week will be returned
  */


void week_calc(date tp,char d[5])
{
	int mnts[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};
	char week[7][4];
	int maxday,flg;
	long int diff;
	date pd,t1,t2;
	pd.dd=4;pd.mm=9;pd.yy=2005;
	if(pd.yy>tp.yy)
	{
		t1.dd=tp.dd;t1.mm=tp.mm;t1.yy=tp.yy;
		t2.dd=pd.dd;t2.mm=pd.mm;t2.yy=pd.yy;
		flg=1;
	}
	else if(tp.yy>pd.yy)
	{
		t1.dd=pd.dd;t1.mm=pd.mm;t1.yy=pd.yy;
		t2.dd=tp.dd;t2.mm=tp.mm;t2.yy=tp.yy;
		flg=2;
	}
	else if(tp.yy==pd.yy)
	{
		if(pd.mm>tp.mm)
		{
			t1.dd=tp.dd;t1.mm=tp.mm;t1.yy=tp.yy;
			t2.dd=pd.dd;t2.mm=pd.mm;t2.yy=pd.yy;
			flg=1;
		}
		else if(tp.mm>pd.mm)
		{
			t1.dd=pd.dd;t1.mm=pd.mm;t1.yy=pd.yy;
			t2.dd=tp.dd;t2.mm=tp.mm;t2.yy=tp.yy;
			flg=2;
		}
		else if(tp.mm==pd.mm)
		{
			if(pd.dd>tp.dd)
			{
				t1.dd=tp.dd;t1.mm=tp.mm;t1.yy=tp.yy;
				t2.dd=pd.dd;t2.mm=pd.mm;t2.yy=pd.yy;
				flg=1;
			}
			else if(tp.dd>pd.dd)
			{
				t1.dd=pd.dd;t1.mm=pd.mm;t1.yy=pd.yy;
				t2.dd=tp.dd;t2.mm=tp.mm;t2.yy=tp.yy;
				flg=2;
			}
			else if(pd.dd==tp.dd)
			{
				t1.dd=tp.dd;t1.mm=tp.mm;t1.yy=tp.yy;
				t2.dd=pd.dd;t2.mm=pd.mm;t2.yy=pd.yy;
				flg=1;
			}
		}
	}
	strcpy(week[0],"Mon");
	strcpy(week[1],"Tue");
	strcpy(week[2],"Wed");
	strcpy(week[3],"Thu");
	strcpy(week[4],"Fri");
	strcpy(week[5],"Sat");
	strcpy(week[6],"Sun");
	if(flg==1)
	{
		diff=6;
		while(t2.dd!=t1.dd || t2.mm!=t1.mm || t2.yy!=t1.yy)
		{
			if(t2.mm==1 && t2.dd<=1)
			{
				t2.yy--;
				t2.mm=12;
				t2.dd=31;
				diff--;
				if(diff<0)
					diff=6;
			}
			else if(t2.dd<=1 && t2.mm!=1)
			{
				t2.mm--;
				if(t2.yy%100==0)
				{
					if(t2.yy%400==0)
						mnts[2]=29;
				}
				else if(t2.yy%4==0)
					mnts[2]=29;
				maxday=mnts[t2.mm];
				mnts[2]=28;
				t2.dd=maxday;
				diff--;
				if(diff<0)
					diff=6;
			}
			else
			{
				t2.dd--;
				diff--;
				if(diff<0)
					diff=6;
			}
		}
	}
	else if(flg==2)
	{
		diff=6;
		while(t1.dd!=t2.dd || t1.mm!=t2.mm || t1.yy!=t2.yy)
		{
			if(t1.yy%100==0)
			{
				if(t1.yy%400==0)
					mnts[2]=29;
			}
			else if(t1.yy%4==0)
				mnts[2]=29;
			maxday=mnts[t1.mm];
			mnts[2]=28;
			if(t1.mm==12 && t1.dd>=31)
			{
				t1.yy++;
				t1.mm=1;
				t1.dd=1;
				diff++;
				if(diff>6)
					diff=0;
			}
			else if(t1.dd>=maxday && t1.mm!=12)
			{
				t1.mm++;
				t1.dd=1;
				diff++;
				if(diff>6)
					diff=0;
			}
			else
			{
				t1.dd++;
				diff++;
				if(diff>6)
					diff=0;
			}
		}
	}
	strcpy(d,week[diff]);
}


/*-------------------------Function Ends------------------------------*/


/*-----------Variables needed for GTK---------------*/

char answer[10];
gint temp;
int radio_flag=0,parent_flag=0,update_add=0,del_form=0,show_all=0;

GtkWidget *vbox;
GtkWidget *menu_bar;
static GtkWidget *create_view_and_model();
int pid=0;


/*-----------Variables needed for MYSQL--------------*/

MYSQL *connection1;
MYSQL_RES *result;
MYSQL_ROW sqlrow,sqlrow1;
int check_flag=0;


/*-------------------MYSQL Functions------------------*/

/**display_row displays the result set returned by Select Command
 * @returns void
 * @param void
 */

void display_row ()
{
	unsigned int field_count;
	field_count = 0;
	check_flag=1;
	while (field_count < mysql_field_count (connection1))
	{
		printf ("%s ", sqlrow[field_count]);
		field_count++;
	}
}

/** ret_one_day_less subtracts one day from a given date and returns the new date
 * @returns void
 * @param dat_register is the date from which one day is to be subtracted
 * @param dat is the pointer in which newly formed date will be returned
 */

void ret_one_day_less(char dat[15],char dt_register[15])
{
        int return_value;
	char qq[50];
	sprintf(qq,"select DATE_SUB('%s',INTERVAL 1 DAY)",dt_register);
        return_value =  mysql_query (connection1,qq);

        if (return_value)
        {
                printf ("select failed as : %s\n", mysql_error (connection1));
        }
        else
        {
                result = mysql_use_result(connection1);
                if (result)
                {
                        while ((sqlrow = mysql_fetch_row (result)))
                        {
                                strcpy(dat,sqlrow[0]);
                        }
                }
                mysql_free_result(result);
        }
}

/** create_connection creates a database connection with the background database used(MYSQL)
 *@params void
 *@returns void
  */

void create_connection()
{
	FILE *fp;
	int r=0,k=0;
	int res,create_table=0;
	char query[1000],query1[100],ch,p_id[10];

	r=system("./poll");
        if(r==-1)
                printf("./poll not invoked");

	system("ps -C poll -o pid|tail -1|sed 's/ //' > temp.txt");
        fp=fopen("temp.txt","r");
        if(fp)
        {
                while((ch=fgetc(fp))!=EOF)
                {
                        p_id[k]=ch;
                        k++;
                }
                p_id[k]='\0';
        }
        pid=atoi(p_id);
	printf("PID NOW %d\n",pid);
	
	
	/*---Creating Table---*/
	strcpy(query,"create table ers(dt date,day varchar(5),hour integer,min integer,event varchar(100),o integer,d integer,w integer,m integer,y integer,eo integer,ed date,ew date,em integer,ey integer,id MEDIUMINT NOT NULL AUTO_INCREMENT,primary key(id))");
	connection1 = mysql_init(NULL);
	if (mysql_real_connect (connection1, "localhost", "alarm_user", "alarm_password", "alarm", 0, NULL, 0))
	{
		printf ("Connection successful\n");

		strcpy(query1,"select 'ers' from information_schema.tables where table_schema='alarm'");
		res=mysql_query(connection1,query1);
		if (res)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
			result = mysql_use_result (connection1);
			if (result)
			{
				while ((sqlrow = mysql_fetch_row (result)))
					display_row ();

				if (mysql_errno (connection1))
				{
					printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
				}
			}
			if(check_flag==0)
			{
				printf("GO GO CREATE TABLE\n");
				create_table=1;
			}
			check_flag=0;
			mysql_free_result(result);
		}	

		if(create_table==1)
		{
			res = mysql_query(connection1,query);    	             
			if (res==0)                
			{
				printf ("Table created successfully.\n");
			}
			else
			{
				fprintf (stderr,"Could not create table as %d: %s\n",mysql_errno (connection1),mysql_error (connection1));
				mysql_close (connection1);
			}
		}
	}														
	else
	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
			fprintf (stderr, "Connection error %d: %s\n",mysql_errno (connection1),mysql_error(connection1));
		}
	}

}


/*--------Global data used in the code-----------*/

int a=0,b=0,day1,month1,year1,combo_cnt=0,g_hour=0,g_min=0,g_once=0,g_daily=0,g_weekly=0,g_monthly=0,g_yearly=0,id=0,month_init=0,year_init=0;
const gchar *g_event;
gchar *g_dd,*g_mm,*g_yy,*g_am_pm;
GtkWidget *disp,*window1,*window;
char str[50],curdate[50],eve[100],g_event_upd[100],yy_upd[6],mm_upd[6],dd_upd[6];
static GtkTreeModel *create_and_fill_model();
static GtkWidget *create_view_and_model();

/*-------------Global data ends------------------*/



/*-------------------------Function to refresh screen,delete all extra widgets-------------------------*/


/** box_remove is a function to refresh screen,delete all extra widgets barring the widget pointed by *btn
  * @returns void
  * @param btn is the widget that should not be deleted
  * @param box is a pointer to the vertical box used for widget alignment
  */

void box_remove(GtkWidget *btn, GtkBox *box)
{     
	/* Remove all widgets in the Box*/      
	GtkWidget *widget=NULL;
	GtkBoxChild *child,*needed_box;
	GList *ptr=box->children;
	int len=g_list_length(box->children);
	int i=0;
	g_assert(btn!=NULL && box!=NULL);
	gtk_widget_freeze_child_notify (btn);
	if(len <= 1)
		return;

	for(i=0;i<len;i++,ptr=ptr->next)
	{
		child=(GtkBoxChild *)ptr->data;
		widget=child->widget;
		if(GTK_IS_LABEL(widget))
		{
		}

		if(widget!=btn && widget!=NULL)
		{
			gtk_widget_unparent(widget);
		}                     
		else
		{
			needed_box=child;
		}
	}

	gtk_widget_thaw_child_notify (btn);
	g_list_free(box->children);
	box->children=g_list_alloc();
	box->children->data=needed_box;
	gtk_container_check_resize(GTK_CONTAINER(box));
	len=g_list_length(box->children);
}

/** display_dialog displays a dialog box with a Custom message 
  * @returns void
  * @param msg is the message to be displayed 
  */

void display_dialog(char msg[])
{
	GtkWidget *dialog;
    	dialog = gtk_message_dialog_new(NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"%s",msg);
    	gtk_dialog_run (GTK_DIALOG(dialog));
    	gtk_widget_destroy (dialog);
}


/*-----------LEVELS--------*/
/*Window holds Menus--->Contains a VBOX---->Contains a scrollable frame---->Conatins a frame--->Contains entire form*/



/*-----------------------------Spinner Button---------------------------*/

/** grab_int_value_hour is the handler for Spinner buttons used,it grabs the "Hour" value of time
  * @returns void
  * @param a_spinner is pointing to the spinner widget
  * @param user_data is data sent to this callback function
  */

void grab_int_value_hour(GtkSpinButton *a_spinner, gpointer user_data)
{
	temp=gtk_spin_button_get_value_as_int (a_spinner);
	g_hour=temp;
}

/** grab_int_value_min is the handler for Spinner buttons used,it grabs the "Min" value of time
  * @returns void
  * @param a_spinner is pointing to the spinner widget
  * @param user_data is data sent to this callback function
  */

void grab_int_value_min(GtkSpinButton *a_spinner, gpointer user_data)
{
	temp=gtk_spin_button_get_value_as_int (a_spinner);
	g_min=temp;
}

/** create_integer_spin_button_hours creates the Spinner buttons for "Hours"
  * @returns the newly created widget spinner
  * @param void
  */

GtkWidget *create_integer_spin_button_hours(void)
{
	GtkWidget *spinner;
	GtkAdjustment *spinner_adj;
	spinner_adj = (GtkAdjustment *) gtk_adjustment_new (0.0,1.0,12.0, 1.0, 0.0, 0.0);

	/* creates the spinner, with no decimal places */
	spinner=gtk_spin_button_new (spinner_adj, 1.0, 0);
	gtk_signal_connect(GTK_OBJECT(spinner), "value-changed",GTK_SIGNAL_FUNC(grab_int_value_hour),NULL);
	return spinner;
}

/** create_integer_spin_button_mins creates the Spinner buttons for "Mins" 
  * @returns the newly created widget spinner
  * @param void
  */

GtkWidget *create_integer_spin_button_mins(void)
{
	GtkWidget *spinner;
	GtkAdjustment *spinner_adj;
	spinner_adj = (GtkAdjustment *) gtk_adjustment_new(0.0,0.0,59.0, 1.0, 0.0, 0.0);

	/* creates the spinner, with no decimal places */
	spinner=gtk_spin_button_new (spinner_adj, 1.0, 0);
	

gtk_signal_connect(GTK_OBJECT(spinner), "value-changed",GTK_SIGNAL_FUNC(grab_int_value_min),NULL);
	return spinner;
}

//---------------------------- Spinner Button ends------------------------//


//-----------------------------Combo Box added here------------------------//

char *months[]=
{
	"January",
	"February",
	"March",	
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"Novemeber",
	"December"
};

/** cb_changed_dd is the handler for the Day combobox,retrieves the "Day" selected from the Combobox 
  * @returns void 
  * @param combo is the pointer to the combobox that renders day. 
  * @param data is data sent when the Changed signal is generated  
  */

void cb_changed_dd( GtkComboBox *combo,gpointer data)
{
	gchar *string = gtk_combo_box_get_active_text(combo);
	g_dd=string;
}

/** cb_changed_mm is the handler for the Month combobox,retrieves the "Month" selected from the Combobox
  * @returns void
  * @param combo is the pointer to the combobox that renders Month.
  * @param data is data sent to the function when the "Changed" signal is generated 
  */

void cb_changed_mm( GtkComboBox *combo,gpointer data)
{
	gchar *string = gtk_combo_box_get_active_text(combo);
	g_mm=string;
}

/** cb_changed_yy is the handler for the Year combobox,retrieves the "Year" selected from the Combobox
  * @returns void
  * @param combo is the pointer to the combobox that renders Year.
  * @param data is data sent to the function when the "Changed" signal is generated.
  */

void cb_changed_yy( GtkComboBox *combo,gpointer data)
{
	gchar *string = gtk_combo_box_get_active_text(combo);
	g_yy=string;
}

/** cb_changed_AM_PM is the handler for the Year combobox,retrieves the "AM/PM type" selected from the Combobox
  * @returns void
  * @param combo is the pointer to the combobox that renders AM/PM.
  * @param data is data sent to the function when the "Changed" signal is generated.
  */

void cb_changed_AM_PM( GtkComboBox *combo,gpointer data)
{
	gchar *string = gtk_combo_box_get_active_text(combo);
	g_am_pm=string;
}

/** create_combobox_days creates the combobox for rendering days.
  * @returns the newly created Combobox widget 
  * @param void
  */

GtkWidget *create_combobox_days(void)
{
	GtkWidget *combo;
	int i;
	char t[3];
	/* creates the combobox, with no decimal places */
	combo = gtk_combo_box_new_text();
	for(i=1;i<=31;i++)
	{
		sprintf(t,"%d",i);
		gtk_combo_box_append_text( GTK_COMBO_BOX(combo),t);
	}

	/* Connect signal to tour handler function */
	g_signal_connect( G_OBJECT( combo ), "changed",G_CALLBACK(cb_changed_dd), NULL );

	return combo;
}

/** create_combobox_months creates the combobox for rendering Months
  * @returns the newly created Combobox widget.
  * @param void
  */

GtkWidget *create_combobox_months(void)
{
	GtkWidget *combo;
	int i;
	/* creates the combobox, with no decimal places */
	combo = gtk_combo_box_new_text();
	for(i=0;i<12;i++)
	{
		gtk_combo_box_append_text( GTK_COMBO_BOX(combo),months[i]);
	}

	/* Connect signal to tour handler function */
	g_signal_connect( G_OBJECT( combo ), "changed",G_CALLBACK(cb_changed_mm), NULL );

	return combo;
}

/** create_combobox_years creates the combobox for rendering Year.
  * @returns the newly created Combobox widget.
  * @param void
  */

GtkWidget *create_combobox_years(void)
{
	GtkWidget *combo;
	int i;
	char t[8];
	/* creates the combobox, with no decimal places */
	combo = gtk_combo_box_new_text();
	for(i=2010;i<=2020;i++)
	{
		sprintf(t,"%d",i);
		gtk_combo_box_append_text( GTK_COMBO_BOX(combo),t);
	}

	/* Connect signal to tour handler function */
	g_signal_connect( G_OBJECT( combo ), "changed",G_CALLBACK(cb_changed_yy), NULL );

	return combo;
}


/** create_combobox_AM_PM creates the combobox for rendering AM/PM.
  * @returns the newly created Combobox Widget.
  * @param void
  */

GtkWidget *create_combobox_AM_PM(void)
{
	GtkWidget *combo;
	/* creates the combobox, with no decimal places */
	combo = gtk_combo_box_new_text();
	gtk_combo_box_append_text( GTK_COMBO_BOX(combo),"AM");
	gtk_combo_box_append_text( GTK_COMBO_BOX(combo),"PM"); 

	/* Connect signal to tour handler function */
	g_signal_connect( G_OBJECT( combo ), "changed",G_CALLBACK(cb_changed_AM_PM), NULL );
	return combo;
}



/*----------------------------Combo Box added------------------------------------*/

/** delete_event is the callback that quits the Calendar
  * @returns FALSE so that the "destroy" Signal is emitted
  * @param widget that points to the calendar
  * @param event is the Signal that raised the event
  * @param data is the data sent to callback
  */

gint delete_event( GtkWidget *widget,GdkEvent  *event,gpointer   data )
{
	gtk_main_quit ();
	return(FALSE);
}

/** delete_event_master quits the master menu form
  * @returns FALSE so that the "destroy" Signal is emitted
  * @param widget that points to the master form 
  * @param event is the Signal that raised the event 
  * @param data is data sent to the Callback.
  */

gint delete_event_master( GtkWidget *widget,GdkEvent  *event,gpointer   data )
{
	parent_flag=0;
	gtk_widget_destroy(widget);
	return(FALSE);
}

/** callback for the radio button,sets the flag indicating which radio button is pressed.
  * @returns void 
  * @param widget that points to the radio button
  * @param data is the data sent to this callback
  */

void callback(GtkWidget *widget,gpointer data)
{
	strcpy(answer,data);
	if(strcmp(answer,"Once")==0)
	{
		radio_flag=1;
	}
	if(strcmp(answer,"Daily")==0)
	{
		radio_flag=2;
	}
	if(strcmp(answer,"Weekly")==0)
	{
		radio_flag=3;
	} 
	if(strcmp(answer,"Monthly")==0)
	{
		radio_flag=4;
	} 
	if(strcmp(answer,"Yearly")==0)
	{
		radio_flag=5;
	}
}


/** convert_to_num converts "month" to standard numeral format(a preceding 0 before a single digit number)
  * @returns a char pointer containing the result
  * @param month is the input parameter the (month name) 
  */

char *convert_to_num(char month[])
{
	if(strcmp(month,"January")==0)
		return "01";
	else if(strcmp(month,"February")==0)
		return "02";
	else if(strcmp(month,"March")==0)
		return "03";
	else if(strcmp(month,"April")==0)
		return "04";
	else if(strcmp(month,"May")==0)
		return "05";
	else if(strcmp(month,"June")==0)
		return "06";
	else if(strcmp(month,"July")==0)
		return "07";
	else if(strcmp(month,"August")==0)
		return "08";
	else if(strcmp(month,"September")==0)
		return "09";
	else if(strcmp(month,"October")==0)
		return "10";
	else if(strcmp(month,"November")==0)
		return "11";
	else if(strcmp(month,"December")==0)
		return "12";
	else 
		return "00";

}


/** match_answer is the caller function, when add/update button is pressed
  * @returns void 
  * @param widget is the button widget itself
  * @param data is the data sent to this function
  */

void match_answer( GtkWidget *widget,gpointer  data)
{
	FILE *fp;
	int i=0,k=0,res=0,pid,not_null_flag=0,garbage_flag=0;
	char t1[7],query[300],ch,p_id[6],*mnth,odl[20],not_null[100];
	date d1;
	

	system("ps -C poll -o pid|tail -1|sed 's/ //' > temp.txt");
	fp=fopen("temp.txt","r");
	if(fp)
	{
		while((ch=fgetc(fp))!=EOF)
		{
			p_id[k]=ch;		
			k++;
		}
		p_id[k]='\0';
	}
	pid=atoi(p_id);
	k=0;
	g_event=gtk_entry_get_text(GTK_ENTRY(disp));
	strcpy(not_null,g_event);

	if(strlen(not_null)==0)
	{
		display_dialog("Event cannot be null,Re-enter!!");
		not_null_flag=1;
	}
	else
		not_null_flag=0;

	for(i=0;not_null[i];i++)
	{
		if(isalnum(not_null[i])==0)
		{
			garbage_flag=1;
			break;	
		}	
	}
	if(garbage_flag==1)
		display_dialog("Event contains invalid characters!!");


	mnth=convert_to_num(g_mm);

	d1.dd=atoi(g_dd);
	d1.mm=atoi(mnth);
	d1.yy=atoi(g_yy);
	week_calc(d1,t1);	

	k=0;
	for(i=0;g_yy[i];i++)
	{
		str[k]=g_yy[i];
		k++;
	}
	str[k]='-';
	k++;
	for(i=0;mnth[i];i++)
	{
		str[k]=mnth[i];
		k++;
	}
	str[k]='-';
	k++;
	for(i=0;g_dd[i];i++)
	{
		str[k]=g_dd[i];
		k++;
	}
	str[k]='\0';


	if(strcmp(g_am_pm,"PM")==0 && g_hour>=1 && g_hour<=11)
	{
		g_print("PM LOOP\n");
		g_hour+=12;
	}

	if(strcmp(g_am_pm,"AM")==0 && g_hour==12)
        {
		g_print("AM LOOP\n");
                g_hour-=12;
        }
	
	if(radio_flag==1)
	{
		g_once=1;g_daily=0;g_weekly=0;g_monthly=0;g_yearly=0;
	}
	else if(radio_flag==2)
	{
                g_once=0;g_daily=1;g_weekly=0;g_monthly=0;g_yearly=0;
	}
	else if(radio_flag==3)
	{
                g_once=0;g_daily=0;g_weekly=1;g_monthly=0;g_yearly=0;
	}
	else if(radio_flag==4)
	{
                g_once=0;g_daily=0;g_weekly=0;g_monthly=1;g_yearly=0;
	}
	else if(radio_flag==5)
	{
                g_once=0;g_daily=0;g_weekly=0;g_monthly=0;g_yearly=1;
	}


	ret_one_day_less(odl,str);


	if(update_add==1)
	{
		sprintf(query,"update ers set dt='%s',day='%s',hour=%d,min=%d,event='%s',o=%d,d=%d,w=%d,m=%d,y=%d,eo=0,ed='%s',ew='%s',em=%d,ey=%d where id=%d",str,t1,g_hour,g_min,g_event,g_once,g_daily,g_weekly,g_monthly,g_yearly,odl,odl,month_init,year_init,id);
		res=mysql_query(connection1,query);
		if(res!=0)
			display_dialog("Updation Failed!!");
		else
		{
			printf("PID : %d",pid);
			kill(pid,SIGUSR1);
			display_dialog("Updation Successfull!!");
		}
	}
	else
	{
		if(not_null_flag==0 && garbage_flag==0)
		{
			sprintf(query,"insert into ers values('%s','%s',%d,%d,'%s',%d,%d,%d,%d,%d,0,'%s','%s',%d,%d,0)",str,t1,g_hour,g_min,g_event,g_once,g_daily,g_weekly,g_monthly,g_yearly,odl,odl,month_init,year_init);
			res=mysql_query(connection1,query);
			if (res!=0)
				display_dialog("Insertion Failed!!");
			else
			{
				kill(pid,SIGUSR1);
				display_dialog("Insertion Successfull!!");
			}
		}
	}
}


/*-------------------------------------ADD EVENT FORM STARTS--------------------------------------*/


/** create_dialog_box creates the 'add event' form
  * @returns the frame on which the form is rendered
  * @param message is the message sent to this function
  */

GtkWidget *create_dialog_box(char message[20])
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *radbut0,*radbut1,*radbut2,*radbut3,*radbut4,*button;
	GtkWidget *label_question,*date1,*time1,*label_freq,*sep,*spinner1,*spinner2,*combo1,*combo2,*combo3,*combo4;

	/*Created a frame*/

	if(update_add==1)
		frame=gtk_frame_new( "Update Event" );
	else
		frame=gtk_frame_new( "Add Event" );
	gtk_widget_show(frame);

	/* Create a 5x5 table */
	table = gtk_table_new (5,5,TRUE);
	
	label_question=gtk_label_new("Event Details");


	/*Put the label in the first row*/
	gtk_table_attach_defaults (GTK_TABLE(table), label_question, 0, 5, 0, 1);
	gtk_widget_show (label_question);
	
	/*Note About The Reminder*/
	disp = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE (table), disp,0,5,1, 2);
	if(update_add==1)
		gtk_entry_set_text(GTK_ENTRY(disp),g_event_upd);

	gtk_widget_show(disp);

	date1=gtk_label_new("Event Date");
	gtk_table_attach_defaults(GTK_TABLE (table),date1,0,1,2, 3);
        gtk_widget_show(date1);
	
	/*Combo Box added*/
	
	combo1=create_combobox_days();
        gtk_table_attach_defaults(GTK_TABLE (table),combo1,2,3,2,3);
	if(update_add==1)
	{
		gtk_combo_box_set_active (GTK_COMBO_BOX(combo1),atoi(dd_upd)-1);		//Retrieve second argument 
	}
	else
	{
		gtk_combo_box_set_active (GTK_COMBO_BOX(combo1),day1-1);
	}
        gtk_widget_show(combo1);

	combo2=create_combobox_months();
        gtk_table_attach_defaults(GTK_TABLE (table),combo2,3,4,2,3);
	if(update_add==1)
	{
		gtk_combo_box_set_active (GTK_COMBO_BOX(combo2),atoi(mm_upd)-1);
	}
	 else
                gtk_combo_box_set_active (GTK_COMBO_BOX(combo2),month1-1);

        gtk_widget_show(combo2);

	combo3=create_combobox_years();
        gtk_table_attach_defaults(GTK_TABLE (table),combo3,4,5,2,3);
	if(update_add==1)
	{
                gtk_combo_box_set_active (GTK_COMBO_BOX(combo3),atoi(yy_upd)-2010);
	}
	else
                gtk_combo_box_set_active (GTK_COMBO_BOX(combo3),year1-2010);

        gtk_widget_show(combo3);
	

	time1=gtk_label_new("Event Time");
	gtk_table_attach_defaults(GTK_TABLE (table),time1,0,1,3, 4);
        gtk_widget_show(time1);

	/*Spinner Buttons added*/
	
	int temp_hr=0;
	temp_hr=g_hour;

	spinner1=create_integer_spin_button_hours();
        gtk_table_attach_defaults(GTK_TABLE (table),spinner1,2,3,3,4);
	if(update_add==1)								//Put value from database
	{
		if(g_hour > 12)
		{
			gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner1),g_hour-12);
		}
		else if(g_hour==0)
			gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner1),g_hour+12);
		
		else
			gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner1),g_hour);
	}
	else
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner1),0);

        gtk_widget_show(spinner1);

	spinner2=create_integer_spin_button_mins();
        gtk_table_attach_defaults(GTK_TABLE (table),spinner2,3,4,3,4);
	if(update_add==1)
	{
                gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner2),g_min);
	}
	else
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner1),0);
        gtk_widget_show(spinner2);
	
	combo4=create_combobox_AM_PM();
        gtk_table_attach_defaults(GTK_TABLE (table),combo4,4,5,3,4);

        if(update_add==1)
	{
		if(temp_hr>=12)
		{
                	gtk_combo_box_set_active (GTK_COMBO_BOX(combo4),1);
		}
		else
			gtk_combo_box_set_active (GTK_COMBO_BOX(combo4),0);
	}
	else
	{
		gtk_combo_box_set_active (GTK_COMBO_BOX(combo4),1);
	}
			
        gtk_widget_show(combo4);

	/*Horizontal Seperator added*/

	sep =gtk_hseparator_new ();
	gtk_table_attach_defaults(GTK_TABLE (table),sep,0,5,4,5);
        gtk_widget_show(sep);


	label_freq=gtk_label_new("Event Reminder frequency");
        gtk_table_attach_defaults(GTK_TABLE (table),label_freq,0,5,5,6);
        gtk_widget_show(label_freq);


	/*---------------------------------Radio buttons being added-------------------------*/


	/*Create first radio button*/
	radbut0 = gtk_radio_button_new_with_label(NULL,"Once");
	gtk_signal_connect (GTK_OBJECT (radbut0), "clicked", GTK_SIGNAL_FUNC (callback), (gpointer) "Once");
	gtk_table_attach_defaults (GTK_TABLE(table), radbut0, 0, 1, 6,7);
	if(update_add==1 && g_once==1) 
	{                                                                      //Put from database
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radbut0),TRUE);
	}
		
	gtk_widget_show (radbut0);

	/*Create second radio button*/
	radbut1 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON (radbut0)),"Daily");
	gtk_signal_connect (GTK_OBJECT (radbut1), "clicked",GTK_SIGNAL_FUNC (callback), (gpointer) "Daily");
	gtk_table_attach_defaults (GTK_TABLE(table), radbut1, 1, 2, 6,7);
	if(update_add==1 && g_daily==1)									//Put from database
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radbut1),TRUE);
	
	gtk_widget_show (radbut1);
	
	/*Create third radio button*/
	radbut2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON (radbut1)),"Weekly");
	gtk_signal_connect (GTK_OBJECT (radbut2), "clicked",GTK_SIGNAL_FUNC (callback), (gpointer) "Weekly");
	gtk_table_attach_defaults (GTK_TABLE(table), radbut2, 2, 3, 6,7);
	if(update_add==1 && g_weekly==1)                                                                       //Put from database
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radbut2),TRUE);
	gtk_widget_show (radbut2);

	/*Create fourth radio button*/
	radbut3 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON (radbut2)),"Monthly");
	gtk_signal_connect (GTK_OBJECT (radbut3), "clicked",GTK_SIGNAL_FUNC (callback), (gpointer) "Monthly");
	gtk_table_attach_defaults (GTK_TABLE(table), radbut3, 3, 4, 6,7);
	if(update_add==1 && g_monthly==1)                                                                       //Put from database
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radbut3),TRUE);
	gtk_widget_show (radbut3);
	
	/*Create fifth radio button*/
	radbut4 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON (radbut3)),"Yearly");
	gtk_signal_connect (GTK_OBJECT (radbut4), "clicked",GTK_SIGNAL_FUNC (callback), (gpointer) "Yearly");
	gtk_table_attach_defaults (GTK_TABLE(table), radbut4, 4, 5, 6, 7);
	if(update_add==1 && g_yearly==1)                                                                       //Put from database
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radbut4),TRUE);
	gtk_widget_show (radbut4);	


	/*-------------------------------------Radio buttons added---------------------------------*/


	/*Button to update record*/
	if(update_add==1)
		button = gtk_button_new_with_label ("Update Event");
	else
	        button = gtk_button_new_with_label ("Add Event");
	/*When the button is clicked, we call the "delete_event" function and the program exits*/
	gtk_signal_connect (GTK_OBJECT (button),"clicked",GTK_SIGNAL_FUNC (match_answer), NULL);
	/*Insert the quit button into the both lower quadrants of the table*/
	gtk_table_attach_defaults (GTK_TABLE(table), button, 0, 5, 7,8);
	gtk_widget_show (button); 

	/* Put the table in the main window */
	gtk_container_add (GTK_CONTAINER (frame),table);
	gtk_widget_show (table);
	
	return frame;			//FRAME RETURNED
}


/*------------------------------------------------ADD EVENT FORM OVER----------------------------------------*/

/*---------------------------------------DELETE/UPDATE/SHOW ALL EVENTS FORM STARTS--------------------------- */


enum
{
        COL_FIRST = 0,
        COL_SECOND,
	COL_THIRD
} ;


/** view_onRowActivated is the caller function called when a row on the list structure is clicked
  * @returns void
  * @param treeview is an instance of tree view created
  * @param path refers to the specific row that is clicked
  * @param col refers to the columns of the list
  * @param userdata is the data sent to this caller function
  */

void view_onRowActivated (GtkTreeView *treeview, GtkTreePath *path,GtkTreeViewColumn  *col,gpointer userdata)
{
	FILE *fp;
	GtkWidget *view,*frame2,*scroller;
	GtkWidget *frame1;
	GtkTreeModel *model;
	GtkTreeIter   iter;
	char time[10],type[10],p_id[6];
	int res=0,pid=0,k=0;
	char query[300],ch,r[5];

	system("ps -C poll -o pid|tail -1|sed 's/ //' > temp.txt");
        fp=fopen("temp.txt","r");
        if(fp)
        {
                while((ch=fgetc(fp))!=EOF)
                {
                        p_id[k]=ch;
                        k++;
                }
                p_id[k]='\0';
        }
        pid=atoi(p_id);
	k=0;

	model = gtk_tree_view_get_model(treeview);
	if (gtk_tree_model_get_iter(model, &iter, path))
	{
		gchar *name;
		gtk_tree_model_get(model, &iter,COL_FIRST, &name, -1);
		strcpy(time,name);
		gtk_tree_model_get(model, &iter, COL_SECOND, &name, -1);
		strcpy(eve,name);
		gtk_tree_model_get(model, &iter, COL_THIRD, &name, -1);
		strcpy(type,name);

		a=atoi(time);
		b=atoi(time+3);
		strcpy(r,time+6);

		if(strcmp(r,"PM")==0 && a>=1 && a<=11)
        	{
               	 	a+=12;
        	}

       	 	if(strcmp(r,"AM")==0 && a==12)
        	{
                	a-=12;
        	}



		if(del_form==1)		/*ONLY IF DELETE FORM*/
		{
			if(strcmp(type,"Once")==0)
			{
				sprintf(query,"delete from ers where hour=%d and min=%d and event='%s' and o=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Daily")==0)
			{
				sprintf(query,"delete from ers where hour=%d and min=%d and event='%s' and d=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Weekly")==0)
			{
				sprintf(query,"delete from ers where hour=%d and min=%d and event='%s' and w=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Monthly")==0)
			{
				sprintf(query,"delete from ers where hour=%d and min=%d and event='%s' and m=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Yearly")==0)
			{
				sprintf(query,"delete from ers where hour=%d and min=%d and event='%s' and y=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			

			if(res!=0)
				display_dialog("Deletion Failed!!");
			else 
			{		
				kill(pid,SIGUSR1);
				view = create_view_and_model();
				/*Create a frame*/
				frame2=gtk_frame_new( "Delete Event" );
				scroller=gtk_scrolled_window_new(NULL,NULL);
				gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),GTK_POLICY_ALWAYS,GTK_POLICY_ALWAYS);
				gtk_widget_set_size_request(scroller,200,250);
				gtk_container_add (GTK_CONTAINER (scroller),view);
				gtk_container_add (GTK_CONTAINER (frame2),scroller);
				/*Remove Extra Widgets*/
				box_remove(menu_bar,GTK_BOX(vbox));
				gtk_box_pack_start (GTK_BOX (vbox),frame2, FALSE, FALSE, 2);
				gtk_widget_show(view);
				gtk_widget_show(frame2);
				gtk_widget_show(scroller);
				display_dialog("Deletion Successfull!!");
			}
		}

		else if(update_add==1)			/*IF UPDATE FORM*/
		{

			if(strcmp(type,"Once")==0)
			{
				sprintf(query,"select id,dt,hour,min,event,o,d,w,m,y from ers where hour=%d and min=%d and event='%s' and o=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Daily")==0)
			{
				sprintf(query,"select id,dt,hour,min,event,o,d,w,m,y from ers where hour=%d and min=%d and event='%s' and d=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Weekly")==0)
			{
				sprintf(query,"select id,dt,hour,min,event,o,d,w,m,y from ers where hour=%d and min=%d and event='%s' and w=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Monthly")==0)
			{
				sprintf(query,"select id,dt,hour,min,event,o,d,w,m,y from ers where hour=%d and min=%d and event='%s' and m=1",a,b,eve);
				res=mysql_query(connection1,query);
			}
			else if(strcmp(type,"Yearly")==0)
			{
				sprintf(query,"select id,dt,hour,min,event,o,d,w,m,y from ers where hour=%d and min=%d and event='%s' and y=1",a,b,eve);
				res=mysql_query(connection1,query);
			}

			if(res!=0)
			{
				printf("SELECT FAILED");
			}
			else
			{
				result=mysql_use_result(connection1);
				if(result)
				{
					while ((sqlrow = mysql_fetch_row (result)))
					{
						id=atoi(sqlrow[0]);
						strcpy(str,sqlrow[1]);
						g_hour=atoi(sqlrow[2]);
						g_min=atoi(sqlrow[3]);
						strcpy(g_event_upd,sqlrow[4]);
						g_once=atoi(sqlrow[5]);
						g_daily=atoi(sqlrow[6]);
						g_weekly=atoi(sqlrow[7]);
						g_monthly=atoi(sqlrow[8]);		
						g_yearly=atoi(sqlrow[9]);
					}
                        	}
                        	mysql_free_result(result);
                	}
			/*Parsing Year,Month,Day from standard format*/

			int l=0,m=0,n=0;
			for(l=0;str[l]!='-';l++)
			{
				yy_upd[m]=str[l];
				m++;
			}
			yy_upd[m]='\0';
			m=0;
			l++;
			
			for(n=l;str[n]!='-';n++)
			{
				mm_upd[m]=str[n];
				m++;
			}
			mm_upd[m]='\0';
			m=0;
			n++;

			for(l=n;str[l];l++)
			{
				dd_upd[m]=str[l];
				m++;
			}
			dd_upd[m]='\0';
			m=0;
			n=0;
			l=0;
			
			frame1=create_dialog_box("Hi");
			box_remove(menu_bar,GTK_BOX(vbox));
			gtk_box_pack_start (GTK_BOX (vbox),frame1, FALSE, FALSE, 2);
		}
	}
}


/** create_and_fill_model populates the list structure created by create_view_and_model
  * @returns a populated tree store
  * @param void
  */

static GtkTreeModel *create_and_fill_model()
{
	GtkTreeStore  *treestore;
	GtkTreeIter    toplevel;
	int res=0,h=0,m=0;
	char query[300],r[5];

	char time_display[20],event_display[100],type_display[20];

	treestore = gtk_tree_store_new(3,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_UINT);
	sprintf(query,"select hour,min,event,o,d,w,m,y from ers where dt='%s' or (d=1 and dt<='%s') order by hour,min",curdate,curdate);
	res=mysql_query(connection1,query);
	if (res!=0)
	{
		printf("SELECT QUERY FAILED!!");
	}
	else
	{
		result=mysql_use_result (connection1);
		if(result)
		{
			while ((sqlrow = mysql_fetch_row (result)))
			{
				if(strcmp(sqlrow[3],"1")==0)
					strcpy(type_display,"Once");
				else if(strcmp(sqlrow[4],"1")==0)
					strcpy(type_display,"Daily");
				else if(strcmp(sqlrow[5],"1")==0)
					strcpy(type_display,"Weekly");
				else if(strcmp(sqlrow[6],"1")==0)
					strcpy(type_display,"Monthly");
				else if(strcmp(sqlrow[7],"1")==0)
					strcpy(type_display,"Yearly");
	
				strcpy(r,"AM");
				h=atoi(sqlrow[0]);
				m=atoi(sqlrow[1]);
				if(h==12)
					strcpy(r,"PM");
				else if(h >=13)
				{
					h-=12;
					strcpy(r,"PM");
				}
				else if(h==0)
					h+=12;
				
				if(h<10 && m<10)
					sprintf(time_display,"0%d:0%d %s",h,m,r);
				else if(h<10 && m>9)
                                        sprintf(time_display,"0%d:%d %s",h,m,r);
				else if(h>9 && m<10)
                                        sprintf(time_display,"%d:0%d %s",h,m,r);
				else 
                                        sprintf(time_display,"%d:%d %s",h,m,r);

				strcpy(event_display,sqlrow[2]);

				/* Append a top level row */	
				gtk_tree_store_append(treestore, &toplevel, NULL);
				gtk_tree_store_set(treestore, &toplevel,COL_FIRST,time_display,COL_SECOND,event_display,COL_THIRD,type_display,-1);
			}
		}
		mysql_free_result(result);	
	}
	return GTK_TREE_MODEL(treestore);
}


/** create_view_and_model creates a model for the list structure 
  * @returns an instance of tree view
  * @param void
  */

static GtkWidget *create_view_and_model()
{
	GtkTreeViewColumn   *col;
	GtkCellRenderer     *renderer;
	GtkWidget           *view;
	GtkTreeModel        *model;

	view = gtk_tree_view_new();

	/*----Column #1-------*/


	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "Time");
	/* pack tree view column into tree view */
	gtk_tree_view_append_column(GTK_TREE_VIEW(view), col);
	renderer = gtk_cell_renderer_text_new();
	/* pack cell renderer into tree view column */
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	/* connect 'text' property of the cell renderer to
	 *  model column that contains the last name */
	gtk_tree_view_column_add_attribute(col, renderer, "text", COL_FIRST);
	/* set 'weight' property of the cell renderer to
	   bold print (we want all last names in bold) */
	g_object_set(renderer,"weight", PANGO_WEIGHT_BOLD,"weight-set", TRUE,NULL);


	/* --- Column #2 --- */

	col = gtk_tree_view_column_new();
	/*Set tilte and alignment*/
	if(update_add==1)
		gtk_tree_view_column_set_title(col,"Double Click to Select Event to be Updated");
	else if(del_form==1)
		gtk_tree_view_column_set_title(col,"Double Click to Delete Event");
	else if(show_all==1)
		gtk_tree_view_column_set_title(col,"Events for Today");
	gtk_tree_view_column_set_alignment  (col,.5);
	/* pack tree view column into tree view */
	gtk_tree_view_append_column(GTK_TREE_VIEW(view), col);
	renderer = gtk_cell_renderer_text_new();
	/* pack cell renderer into tree view column */
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	/* connect 'text' property of the cell renderer to model column that contains the first name */
	gtk_tree_view_column_add_attribute(col, renderer, "text",COL_SECOND);

	
	/* --- Column #3 --- */

        col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "Scheduled");
        gtk_tree_view_column_set_alignment  (col,.5);
        /* pack tree view column into tree view */
        gtk_tree_view_append_column(GTK_TREE_VIEW(view), col);
        renderer = gtk_cell_renderer_text_new();
        /* pack cell renderer into tree view column */
        gtk_tree_view_column_pack_start(col, renderer, TRUE);
        /* connect 'text' property of the cell renderer to model column that contains the first name */
        gtk_tree_view_column_add_attribute(col, renderer, "text",COL_THIRD);

	/*Display grid lines*/

	gtk_tree_view_set_enable_tree_lines (GTK_TREE_VIEW(view),TRUE);
	gtk_tree_view_set_grid_lines(GTK_TREE_VIEW(view),GTK_TREE_VIEW_GRID_LINES_BOTH);
                                                         
	model = create_and_fill_model();
	gtk_tree_view_set_model(GTK_TREE_VIEW(view), model);
	if(del_form==1|| update_add==1)
		g_signal_connect(view, "row-activated", (GCallback) view_onRowActivated, NULL);

	g_object_unref(model); /* destroy model automatically with view */
	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(view)),GTK_SELECTION_NONE);

	return view;
}


/*-----------------------------------DELETE EVENT FORM OVER-----------------------------------------------*/

/*-----------------------------------MAIN MENU FORM STARTS------------------------------------------------*/

static void menuitem_response (gchar *);

/** create _master_form creates the main form (renders main menu)
  * @returns void
  * @param void
  */

void create_master_form()
{

	GtkWidget *root_menu1,*root_menu2,*root_menu3,*root_menu4;


	/* create a new window */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize (GTK_WIDGET (window), 500,300);
	gtk_window_set_title (GTK_WINDOW (window), "Event Registration Menu");
	gtk_window_set_transient_for(GTK_WINDOW(window),GTK_WINDOW(window1));

	gtk_window_set_destroy_with_parent(GTK_WINDOW(window),TRUE);
	gtk_window_set_resizable(GTK_WINDOW(window),FALSE);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",GTK_SIGNAL_FUNC (delete_event_master), NULL);


	root_menu1 = gtk_menu_item_new_with_label ("Add Event");
	root_menu2 = gtk_menu_item_new_with_label ("Update Event");
	root_menu3 = gtk_menu_item_new_with_label ("Delete Event");
	root_menu4 = gtk_menu_item_new_with_label ("Show Events for the Day");

	gtk_widget_show (root_menu1);
	gtk_widget_show (root_menu2);
	gtk_widget_show (root_menu3);
	gtk_widget_show (root_menu4);

	
	/* Now we specify that all root menus with no sub menu items*/
	gtk_signal_connect_object (GTK_OBJECT (root_menu1), "activate",GTK_SIGNAL_FUNC (menuitem_response), (gpointer)"FIRST");
	gtk_signal_connect_object (GTK_OBJECT (root_menu2), "activate",GTK_SIGNAL_FUNC (menuitem_response), (gpointer)"SECOND");
	gtk_signal_connect_object (GTK_OBJECT (root_menu3), "activate",GTK_SIGNAL_FUNC (menuitem_response), (gpointer)"THIRD");
	gtk_signal_connect_object (GTK_OBJECT (root_menu4), "activate",GTK_SIGNAL_FUNC (menuitem_response), (gpointer)"FOURTH");


	/* A vbox to put a menu and a button in: */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_widget_show (vbox);

	/* Create a menu-bar to hold the menus and add it to our main window */
	menu_bar = gtk_menu_bar_new ();
	gtk_box_pack_start (GTK_BOX (vbox), menu_bar, FALSE, FALSE, 2);
	gtk_widget_show (menu_bar);
	
	gtk_widget_show(menu_bar);

	/* And finally we append the menu-item to the menu-bar */
	gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu1);
	gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu2);
	gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu3);
	gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu4);

	/* always display the window as the last step so it all splashes on
	  the screen at once. */
	gtk_widget_show (window);

}

/** menuitem_response prints a string when a menu item is selected
  * @returns void
  * @param string is the string indicating which menu is pressed
  */

static void menuitem_response( gchar *string )
{
	GtkWidget *frame1,*view,*frame2,*scroller;
	if(strcmp(string,"FIRST")==0)		//Render add event
	{
		update_add=0;
		/*Create a frame*/
		frame1=create_dialog_box("Hi");
		box_remove(menu_bar,GTK_BOX(vbox));
		gtk_box_pack_start (GTK_BOX (vbox),frame1, FALSE, FALSE, 2);
	}
	else if(strcmp(string,"SECOND")==0)           //Render Update event
        {	
		update_add=1;
		show_all=0;
		del_form=0;
		view = create_view_and_model();
                /*Create a frame*/
                frame2=gtk_frame_new( "Update Event" );
		scroller=gtk_scrolled_window_new(NULL,NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),GTK_POLICY_ALWAYS,GTK_POLICY_ALWAYS);
		gtk_widget_set_size_request(scroller,200,250);
                gtk_container_add (GTK_CONTAINER (scroller),view);
		gtk_container_add (GTK_CONTAINER (frame2),scroller);
                /*Remove Extra Widgets*/
                box_remove(menu_bar,GTK_BOX(vbox));
                gtk_box_pack_start (GTK_BOX (vbox),frame2, FALSE, FALSE, 2);
                gtk_widget_show(view);
                gtk_widget_show(scroller);
		gtk_widget_show(frame2);
        }

	else if(strcmp(string,"THIRD")==0)		//Render delete event
	{
		update_add=0;
		show_all=0;
		del_form=1;
		view = create_view_and_model();
		/*Create a frame*/
		frame2=gtk_frame_new( "Delete Event" );
		scroller=gtk_scrolled_window_new(NULL,NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),GTK_POLICY_ALWAYS,GTK_POLICY_ALWAYS);
                gtk_widget_set_size_request(scroller,200,250);
                gtk_container_add (GTK_CONTAINER (scroller),view);
                gtk_container_add (GTK_CONTAINER (frame2),scroller);
		/*Remove Extra Widgets*/
		box_remove(menu_bar,GTK_BOX(vbox));		
		gtk_box_pack_start (GTK_BOX (vbox),frame2, FALSE, FALSE, 2);
		gtk_widget_show(view);
		gtk_widget_show(frame2);
		gtk_widget_show(scroller);
	}
	else if(strcmp(string,"FOURTH")==0)		//Render show event
	{
		update_add=0;
		del_form=0;
		show_all=1;
		view = create_view_and_model(1);
		/*Create a frame*/
		frame2=gtk_frame_new( "Show Events" );
		scroller=gtk_scrolled_window_new(NULL,NULL);
                gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),GTK_POLICY_ALWAYS,GTK_POLICY_ALWAYS);
                gtk_widget_set_size_request(scroller,200,250);
                gtk_container_add (GTK_CONTAINER (scroller),view);
                gtk_container_add (GTK_CONTAINER (frame2),scroller);
		//Remove Extra Widgets
		box_remove(menu_bar,GTK_BOX(vbox));		
		gtk_box_pack_start (GTK_BOX (vbox),frame2, FALSE, FALSE, 2);
		gtk_widget_show(view);
		gtk_widget_show(frame2);
		gtk_widget_show(scroller);
	}
}

/*-----------------------------------MAIN MENU FORM OVER----------------------------------------*/


/** calendar_day_double_clicked is the handler function called when a date on the calendar is double clicked
  * @returns TRUE on successs
  * @param cal is the the widget pointing to calendar.
  * @param data is the data sent to this callback function. 
  */

gint calendar_day_double_clicked(GtkCalendar *cal,gpointer  data)
{
	char message[20];
	guint day,month,year;
	char d[5],m[15],y[6];
	if(parent_flag==0)
	{
		gtk_calendar_get_date(cal,& year,& month,&day);
	
		month_init=month;
		year_init=year-1;

		sprintf(y,"%d",year);

		if(month+1==1)
			strcpy(m,"01");
		else if(month+1==2) 
			strcpy(m,"02");		
		else if(month+1==3)
			strcpy(m,"03"); 
		else if(month+1==4) 
			strcpy(m,"04");
		else if(month+1==5) 
			strcpy(m,"05");
		else if(month+1==6)
			strcpy(m,"06");
		else if(month+1==7)
			strcpy(m,"07");
		else if(month+1==8)
			strcpy(m,"08");
		else if(month+1==9)
			strcpy(m,"09");
		else 
			sprintf(m,"%d",month+1);

		if(day==1)
			strcpy(d,"01");
		else if(day==2)
			strcpy(d,"02");         
		else if(day==3) 
			strcpy(d,"03");
		else if(day==4) 
			strcpy(d,"04");
		else if(day==5) 
			strcpy(d,"05");
		else if(day==6)
			strcpy(d,"06");
		else if(day==7)
			strcpy(d,"07");
		else if(day==8)
			strcpy(d,"08");
		else if(day==9)
			strcpy(d,"09");
		else
			sprintf(d,"%d",day);

		int k=0,i=0;
		for(i=0;y[i];i++)
		{
			curdate[k]=y[i];
			k++;
		}
		curdate[k]='-';
		k++;
		for(i=0;m[i];i++)
		{
			curdate[k]=m[i];
			k++;
		}
		curdate[k]='-';
		k++;
		for(i=0;d[i];i++)
		{
			curdate[k]=d[i];
			k++;
		}
		curdate[k]='\0';	

		/*Setting Global Data*/

		day1=day;
		month1=month+1;
		year1=year;

		sprintf(message,"%d/%d/%d\n",day,month+1,year);

		parent_flag=1;
		create_master_form();
	}

	return TRUE;
}


/** main function where the program starts working
 * @return zero on success
 * @param argc number of command line arguments
 * @param argv actual command line arguments
 */

int main( int   argc,char *argv[] )
{
	GtkCalendar *calendar;
	GtkWidget *table;
	char comm[15];
	int f=0;

	create_connection();				//Create table
	gtk_init (&argc, &argv);
	/* Create a new window */
	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_resizable(GTK_WINDOW(window1),FALSE);
	gtk_window_set_position(GTK_WINDOW(window1),GTK_WIN_POS_CENTER_ALWAYS);
	/* Set the window title */
	gtk_window_set_title (GTK_WINDOW(window1), "Task Reminder System");
	/* Set a handler for delete_event that immediately exits GTK. */
	gtk_signal_connect (GTK_OBJECT (window1), "delete_event",GTK_SIGNAL_FUNC (delete_event), NULL);
	/* Sets the border width of the window. */
	gtk_container_set_border_width (GTK_CONTAINER (window1), 20);
	/* Create a 1x1 table */
	table = gtk_table_new (1, 1, TRUE);
	/* Put the table in the main window */
	gtk_container_add (GTK_CONTAINER (window1), table);
	/*Creating a new calendar*/
	calendar=GTK_CALENDAR(gtk_calendar_new());
	gtk_calendar_display_options (calendar,GTK_CALENDAR_SHOW_HEADING|GTK_CALENDAR_SHOW_DAY_NAMES);
	/*Put the label in the first row*/
	gtk_table_attach_defaults (GTK_TABLE(table), GTK_WIDGET(calendar), 0, 1, 0, 1);
	/*Handler for double clicking a date in the calendar*/
	gtk_signal_connect (GTK_OBJECT (calendar), "day_selected_double_click",GTK_SIGNAL_FUNC (calendar_day_double_clicked),NULL);
	gtk_widget_show (GTK_WIDGET(calendar));
	gtk_widget_show (table);
	gtk_widget_show (window1);
	

	gtk_main ();
	sprintf(comm,"kill %d",pid);
        f=system(comm);
        if(f==-1)
                printf("Command failed");

	mysql_close(connection1);
	
	return 0;
}
