/** Poll.c keeps track of the events that are to be notified
 * @file poll.c
 * @version 1.0
 * @author Ankit Sharma, Rameez Meheboob
 **/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <mysql/mysql.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <signal.h>

/** daemon_init() initializes the program as a daemon in the background
 * @returns void
 */
void daemon_init()
{
	int i;
	pid_t pid;
	char path[512];
	if((pid=fork())!=0)
	{
		exit(0);
	}
	setsid();
	signal(SIGHUP,SIG_IGN);
	if((pid=fork())!=0)
	{
		exit(0);
	}
	getcwd(path,512);
	chdir(path);
	umask(0);
	for(i=0;i<64;i++)
	{
		close(i);
	}
}

MYSQL *connection1;
MYSQL_RES *result;
MYSQL_ROW sqlrow;

int g_flag=0;

int mnts[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};

typedef struct
{
    /*{*/
	int dd; /**< day of a date */
	int mm; /**< month of a date */
	int yy; /**< the year of a date */
	/*@}*/
}date;

date fd,sd,temp;

/**readdata fills in values for date structure variables
 * @return void
 * @param d1 Day value for first date structure fd
 * @param m1 Month value for first date structure fd
 * @param y1 Year value for first date structure fd
 * @param d2 Day value for first date structure sd
 * @param m2 Month value for first date structure sd
 * @param Year Day value for first date structure sd
 */
void readdata(int d1,int m1,int y1,int d2,int m2,int y2)
{
	if(y2>y1)
	{
		fd.dd=d1;fd.mm=m1;fd.yy=y1;
		sd.dd=d2;sd.mm=m2;sd.yy=y2;
	}
	else if(y1>y2)
	{
		fd.dd=d2;fd.mm=m2;fd.yy=y2;
		sd.dd=d1;sd.mm=m1;sd.yy=y1;
	}
	else if(y1==y2)
	{
		if(m2>m1)
		{
			fd.dd=d1;fd.mm=m1;fd.yy=y1;
			sd.dd=d2;sd.mm=m2;sd.yy=y2;
		}
		else if(m1>m2)
		{
			fd.dd=d2;fd.mm=m2;fd.yy=y2;
			sd.dd=d1;sd.mm=m1;sd.yy=y1;
		}
		else if(m1==m2)
		{
			if(d2>d1)
			{
				fd.dd=d1;fd.mm=m1;fd.yy=y1;
				sd.dd=d2;sd.mm=m2;sd.yy=y2;
			}
			else if(d1>d2)
			{
				fd.dd=d2;fd.mm=m2;fd.yy=y2;
				sd.dd=d1;sd.mm=m1;sd.yy=y1;
			}
			else if(d1==d2)
			{
				fd.dd=d1;fd.mm=m1;fd.yy=y1;
				sd.dd=d2;sd.mm=m2;sd.yy=y2;
			}
		}
	}
}

/**diff_date calculates the difference of days between two dates
 * @returns Returns the difference between two dates
 * @param void
 */
long int diff_date()
{
	long int diff=0;
	int maxday;
	while(temp.dd!=sd.dd || temp.mm!=sd.mm || temp.yy!=sd.yy)
	{
		if(temp.yy%100==0)
		{
			if(temp.yy%400==0)
				mnts[2]=29;
		}
		else if(temp.yy%4==0)
			mnts[2]=29;
		maxday=mnts[temp.mm];
		mnts[2]=28;
		if(temp.mm==12 && temp.dd>=31)
		{
			temp.yy++;
			temp.mm=1;
			temp.dd=1;
			diff++;
		}
		else if(temp.dd>=maxday && temp.mm!=12)
		{
			temp.mm++;
			temp.dd=1;
			diff++;
		}
		else
		{
			temp.dd++;
			diff++;
		}



	}
	return diff;
}

/** handler is the function to receive a sytem signal from the GUI Interface
 * @returns void
 * @param sig Is the value of the signal which is caught
 */
void handler(int sig)
{
	printf("\nInside Handler!!\n");
	g_flag=1;
}

/** months returns the vaue in integer given a month
 * @returns Returns an integer value between 1-12 corresponding to a month
 * @param m The month for which the integer value is to be returned
 */
int months(char m[5])
{
	if(strcmp(m,"Jan")==0)return 1;
	else if(strcmp(m,"Feb")==0)return 2;
	else if(strcmp(m,"Mar")==0)return 3;
	else if(strcmp(m,"Apr")==0)return 4;
	else if(strcmp(m,"May")==0)return 5;
	else if(strcmp(m,"Jun")==0)return 6;
	else if(strcmp(m,"Jul")==0)return 7;
	else if(strcmp(m,"Aug")==0)return 8;
	else if(strcmp(m,"Sep")==0)return 9;
	else if(strcmp(m,"Oct")==0)return 10;
	else if(strcmp(m,"Nov")==0)return 11;
	else if(strcmp(m,"Dec")==0)return 12;
	else return -1;
}

void display_row()
{
	unsigned int field_count;
	field_count = 0;
	printf("\ndisplay_row()<");
	while (field_count < mysql_field_count (connection1))
	{
		printf ("%s ", sqlrow[field_count]);
		field_count++;
	}
	printf (">\n");
}

/** databaseconnect estabilishes a connection to the database
 * @returns Variable connection1 corressponding to database connection is updated
 * @param void
 */
void databaseconnect()
{
	char server[30],dbuser[30],dbpassword[30],dbname[30];
	strcpy(server,"localhost");
	strcpy(dbuser,"alarm_user");
	strcpy(dbpassword,"alarm_password");
	strcpy(dbname,"alarm");

	connection1 = mysql_init (NULL);
	if (!connection1)
	{
		fprintf (stderr, "MySQL initialization failed\n");
		exit(EXIT_FAILURE);
	}	

	connection1 = mysql_real_connect (connection1, server,dbuser,dbpassword,dbname, 0, NULL, 0);

	if (connection1)
	{
		printf ("Connection successful\n");
	}
	else
	{
		printf ("Connection failed\n");
		return;
	}
}

/** get_time returns values of system date & time
 * @returns void
 * @param h Pointer variable where hour will be returned
 * @param m Pointer variable where min will be returned
 * @param s Pointer variable where secs will be returned
 * @param dt Pointer where system date will be returned
 * @param day Pointer where system day of the week will be returned
 * @param dat Pointer variable where day of month will be returned as integer
 * @param mnt Pointer variable where month will be returned as integer
 * @param y Pointer variable where year will be returned as integer
 */
void get_time(int *h,int *m,int *s,char dt[15],char day[5],int *dat,int *mnt,int *y)
{
	time_t now;
	int n,dd,mnth,yr;
	char fields[5][15],str[50];
	char *pch=NULL;

	n=0;
	time(&now);
	strcpy(str,ctime(&now));
	pch = strtok (str," ");
	while (pch != NULL)
	{
		strcpy(fields[n++],pch);
		pch = strtok (NULL," ");
	}
	*h=atoi(fields[3]);
	*m=atoi(fields[3]+3);
	*s=atoi(fields[3]+6);

	dd=atoi(fields[2]);
	mnth=months(fields[1]);
	yr=atoi(fields[4]);

	*dat=dd;
	*y=yr;
	*mnt=mnth;

	strcpy(day,fields[0]);

	if(dd<10 && mnth>9)
		sprintf(dt,"%d-%d-0%d",yr,mnth,dd);
	else if(dd>9 && mnth<10)
		sprintf(dt,"%d-0%d-%d",yr,mnth,dd);
	else if(dd<9 && mnth<10)
		sprintf(dt,"%d-0%d-0%d",yr,mnth,dd);
	else
		sprintf(dt,"%d-%d-%d",yr,mnth,dd);

	printf("\nfn:get_time() system time:<%d:%d:%d>system date:<%s>sytem day:<%s>sys date:<%d/%d/%d>\n",*h,*m,*s,dt,day,*dat,*mnt,*y);
}

/** conv_date_integer converts a given date into its corresponding integer parts
 * @returns void
 * @param dt The date to be converted into integer parts
 * @param dat Pointer where day of dt will be returned as integer 
 * @param dat Pointer where month of dt will be returned as integer 
 * @param dat Pointer where year of dt will be returned as integer 
 */
void conv_date_integer(char dt[15],int *dat,int *mnt,int *yr)
{
	*dat=atoi(dt+8);
	*mnt=atoi(dt+5);
	*yr=atoi(dt);
	printf("\nconv_date_integer():database date:<%d/%d/%d>\n",*dat,*mnt,*yr);
}

/** time_comp given two times it checks if time one is greater than time two or not
 * @returns returns 1 if time one is greater else returns 2
 * @params h1 value of hour for time one 
 * @params m1 value of min for time one 
 * @params h2 value of hour for time two 
 * @params m2 value of min for time two
 */
int time_comp(int h1,int m1,int h2,int m2)
{
	int flg;
	if(h1>h2)
		flg=1;
	else if(h2>h1)
		flg=2;
	else if(h1==h2)
	{
		if(m1>m2)
			flg=1;
		else if(m2>m1)
			flg=2;
	}
	return flg;
}

/** query fires queries into the database to find out about any forthcoming events
 * @returns the difference of time of the next event
 * @param void
 */
long int query()
{
	int g_hour,g_min,g_o,g_d,g_w,g_m,g_y,g_eo,g_em,g_ey,g_curmnth,g_curyr;
	int return_value,hr,min,sec,flg=0,dat,mnt,yr,flg1=0;
	int db_dat,db_mnt,db_yr,r;

	long int diff=-1;
	long int diff_dt=0;

	char g_dt[15],g_day[5],g_event[100],g_ed[15],g_ew[15],g_currdate[15],g_curday[5];

	char dt[15],day[5],qry[500],line[500];
	FILE *fp;

	fp=fopen("t","w");

	get_time(&hr,&min,&sec,dt,day,&dat,&mnt,&yr);
	strcpy(g_currdate,dt);
	g_curmnth=mnt;
	g_curyr=yr;
	strcpy(g_curday,day);

	sprintf(qry,"update ers set dt='%s' where dt < '%s' and d=1",dt,dt);	/*Daily Event*/
	return_value=mysql_query(connection1,qry);
	if(return_value)
		printf("Update Failed!!");

	sprintf(qry,"select * from ers where ((eo=0 and o=1) or ('%s'>ed and d=1) or ('%s'>ew and w=1 and day='%s') or (%d>em and m=1) or (%d>ey and y=1)) and ('%s'>=dt) order by ed,hour,min",dt,dt,day,mnt,yr,dt);
	printf("\nSelect Query : %s",qry);	

	return_value =  mysql_query (connection1,qry);

	if (return_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
		result = mysql_use_result(connection1);
		if (result)
		{
			while ((sqlrow = mysql_fetch_row (result)))
			{
				display_row();
				diff=0;
				flg=0;
				flg1=0;
				diff_dt=0;

				strcpy(g_dt,sqlrow[0]);
				strcpy(g_day,sqlrow[1]);
				g_hour=atoi(sqlrow[2]);
				g_min=atoi(sqlrow[3]);
				strcpy(g_event,sqlrow[4]);
				g_o=atoi(sqlrow[5]);
				g_d=atoi(sqlrow[6]);
				g_w=atoi(sqlrow[7]);
				g_m=atoi(sqlrow[8]);
				g_y=atoi(sqlrow[9]);
				g_eo=atoi(sqlrow[10]);
				strcpy(g_ed,sqlrow[11]);
				strcpy(g_ew,sqlrow[12]);
				g_em=atoi(sqlrow[13]);
				g_ey=atoi(sqlrow[14]);

				sprintf(line,"./popup %s %s %d %d %d %d %d %d %d %d %s %s %d %d %s %d %d %s %d %s",g_dt,g_day,g_hour,g_min,g_o,g_d,g_w,g_m,g_y,g_eo,g_ed,g_ew,g_em,g_ey,g_currdate,g_curmnth,g_curyr,g_curday,1,g_event);
				printf("%s\n",line);

				if(g_o==1)		/*Once Event working fine*/
				{
					conv_date_integer(g_dt,&db_dat,&db_mnt,&db_yr);
					readdata(db_dat,db_mnt,db_yr,dat,mnt,yr);
					temp=fd;
					diff_dt=diff_date();
					printf("\nOnce difference=%ld\n",diff_dt);
					if(diff_dt>0)
					{
						printf("\n<Backlog 'once' event>\n");
						flg1=1;
						system(line);
					}
					else if(diff_dt==0)/*same day backlog*/
					{
						r=time_comp(g_hour,g_min,hr,min);
						if(r==2)
						{
							printf("\n<Backlog 'once' event same day>\n");
							flg1=1;
							system(line);
						}
					}
				}
				if(g_d==1)		/*Daily event ed-systemdate*/
				{
					conv_date_integer(g_ed,&db_dat,&db_mnt,&db_yr);
					readdata(db_dat,db_mnt,db_yr,dat,mnt,yr);
					temp=fd;
					diff_dt=diff_date();
					printf("\nDaily difference=%ld\n",diff_dt);
					if(diff_dt==1)
					{
						r=time_comp(g_hour,g_min,hr,min);
						if(r==2)
						{
							printf("\n<Backlog 'daily' event same day>\n");
							flg1=1;
							system(line);
						}
					}
				}
				if(g_w==1)
				{
					conv_date_integer(g_ew,&db_dat,&db_mnt,&db_yr);
					readdata(db_dat,db_mnt,db_yr,dat,mnt,yr);
					temp=fd;
					diff_dt=diff_date();
					printf("\nWeekly difference=%ld\n",diff_dt);
					if(diff_dt>7)
					{
						printf("\n<Backlog 'weekly' event>\n");
						flg1=1;
						system(line);
					}
					else if(diff_dt==1)
					{
						r=time_comp(g_hour,g_min,hr,min);
						if(r==2)
						{
							printf("\n<Backlog 'weekly' event same day>\n");
							flg1=1;
							system(line);
						}
					}
				}
				if(g_m==1)
				{
					if(g_em==12)
						diff_dt=mnt;
					else
						diff_dt=mnt-g_em;
					printf("\nMonthly difference=%ld\n",diff_dt);
					if(diff_dt>1)
					{
						printf("\n<Backlog 'monthly' event>\n");
						flg1=1;
						system(line);
					}
					else if(diff_dt==1)
					{
						r=time_comp(g_hour,g_min,hr,min);
						if(r==2)
						{
							printf("\n<Backlog 'monthly' event same day>\n");
							flg1=1;
							system(line);
						}
					}
				}
				if(g_y==1)
				{
					diff_dt=yr-g_ey;
					printf("\nYearly difference=%ld\n",diff_dt);
					if(diff_dt>1)
					{
						printf("\n<Backlog 'yearly' event>\n");
						flg1=1;
						system(line);
					}
					else if(diff_dt==1)
					{
						r=time_comp(g_hour,g_min,hr,min);
						if(r==2)
						{
							printf("\n<Backlog 'yearly' event same day>\n");
							flg1=1;
							system(line);
						}
					}
				}

				printf("\nquery():flg1=%d\n",flg1);

				if(flg1==0)
				{
					printf("\nNORMAL EVENT\n");
					if(g_hour==hr)
						diff=((g_min-min)*60);
					else if(g_hour>hr)
						diff=((g_hour-hr)*60*60)+((g_min-min)*60);

					diff-=sec;

					printf("\nquery():diff=%ld\n",diff);

					if(diff>0)
					{
						flg=1;
						printf("\nFiring Normal Query into file\n");
						sprintf(line,"./popup %s %s %d %d %d %d %d %d %d %d %s %s %d %d %s %d %d %s %d %s",g_dt,g_day,g_hour,g_min,g_o,g_d,g_w,g_m,g_y,g_eo,g_ed,g_ew,g_em,g_ey,g_currdate,g_curmnth,g_curyr,g_curday,2,g_event);
						fprintf(fp,"%s\n",line);
						break;
					}
				}
			}
			if (mysql_errno (connection1))
			{
				printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
		}
	}

	if(flg==1)
	{
		int l_hour,l_min,l_o,l_d,l_w,l_m,l_y,l_eo,l_em,l_ey,l_curmnth,l_curyr;
		char l_dt[15],l_day[5],l_event[100],l_ed[15],l_ew[15],l_currdate[15],l_curday[5];

		while ((sqlrow = mysql_fetch_row (result)))
		{
			l_hour=atoi(sqlrow[2]);
			l_min=atoi(sqlrow[3]);
			if(g_hour==l_hour && g_min==l_min)
			{
				display_row();
				strcpy(l_dt,sqlrow[0]);
				strcpy(l_day,sqlrow[1]);
				strcpy(l_event,sqlrow[4]);
				l_o=atoi(sqlrow[5]);
				l_d=atoi(sqlrow[6]);
				l_w=atoi(sqlrow[7]);
				l_m=atoi(sqlrow[8]);
				l_y=atoi(sqlrow[9]);
				l_eo=atoi(sqlrow[10]);
				strcpy(l_ed,sqlrow[11]);
				strcpy(l_ew,sqlrow[12]);
				l_em=atoi(sqlrow[13]);
				l_ey=atoi(sqlrow[14]);

				strcpy(l_currdate,g_currdate);
				l_curmnth=g_curmnth;
				l_curyr=g_curyr;
				strcpy(l_curday,g_curday);

				sprintf(line,"./popup %s %s %d %d %d %d %d %d %d %d %s %s %d %d %s %d %d %s %d %s",l_dt,l_day,l_hour,l_min,l_o,l_d,l_w,l_m,l_y,l_eo,l_ed,l_ew,l_em,l_ey,l_currdate,l_curmnth,l_curyr,l_curday,2,l_event);
				printf("\nFiring additional normal query with same time into file\n");
				fprintf(fp,"%s\n",line);
			}
		}
	}

	mysql_free_result(result);
	fclose(fp);
	if(flg==1)
		return diff;
	else if(flg1==1)
		return -1;
	else 
		return -1;
}

/** Main function from where execution starts
 * @returns 0 if success
 * @param argc number of command line arguments
 * @param argv command line arguments itself
 */
int main(int argc,char *argv[])
{
	daemon_init();

	int ret=-1;
	int cur_hr,cur_min,cur_sec,a,b,c;
	int hr=23,min=60;
	long int diff,diff_time;
	char comm[200],d[15],e[5];
	FILE *fp;

	databaseconnect();//connecting to the database

	signal(SIGUSR1,handler);

	while(g_flag!=1)
	{
		printf("Processing....Awake!!\n");
		diff=query();//calling the query function to find out nearest time
		printf("\nDiff inside main=%ld\n",diff);

		if(diff>=0)
		{
			printf("Put to sleep %ld seconds",diff);
			ret=sleep(diff);
		}

		printf("\nret=%d\n",ret);

		if(ret==0)
		{
			printf("\nExecuting normal/duplicate query\n");

			fp=fopen("t","r");
			while(fscanf(fp," %[^\n]",comm)>0)
			{
				//printf("%s\n",comm);
				system(comm);
			}

			fclose(fp);
			system("rm -f t");
			g_flag=0;
			ret=-1;

		}
		else if(ret==-1 && diff==-1)
		{
			printf("Sleeping till end of the day..!!\n");
			get_time(&cur_hr,&cur_min,&cur_sec,d,e,&a,&b,&c);
			if(cur_sec==0)
				diff_time=((hr-cur_hr)*60*60)+((min-cur_min)*60);
			else if(cur_sec!=0)
				diff_time=((hr-cur_hr)*60*60)+((min-(cur_min+1))*60)+(60-cur_sec);
			sleep(diff_time);
			g_flag=0;
		}
		else
		{
			printf("Sleep interrupted..!!\n");
			g_flag=0;
			ret=-1;
			continue;
		}
	}
	mysql_close(connection1);
	return 0;
}
