/**
*   @file stack.c
*   @brief this file will contain all required
*   definitions and basic stack functions.
*
*   @author Anshul Gupta,Nikhil Jain
*
*   @date 3/31/2010
*/
#include "stack.h"
#include<stdio.h>
#include<malloc.h>

/**
  * The structure used for stack
  */
struct node 
{
	int data;
	struct node *next;
};


/**
  * The function is used to push some value on to the stack
  *
  * @returns TRUE is the push was successfull, FALSE otherwise
  * @param s The reference to the stack
  * @param elt The element to be pushed
  *
  */
int push(Stack *s,int elt)
{
	Node *newnode=(Node*)malloc(sizeof(Node*));
	newnode->data=elt;
	newnode->next=s->stacktop;
	s->stacktop=newnode;
	return 1;
}

/**
  * The function is used to return top of the stack without popping it off
  *
  * @returns Top os the stack if successfull, FALSE otherwise
  * @param s The reference to the stack
  *
  */
int top(Stack *s)
{
	if(s->stacktop==NULL)
	{
		return -1;
	}
	else 
	{
		return s->stacktop->data;
	}
}

/**
  * The function is used to check whether the stack is empty or not
  *
  * @returns TRUE if empty, FALSE otherwise
  * @param s The reference to the stack
  *
  */
int isempty(Stack *s)
{
	if(s->stacktop==NULL)
	{
		return 1;
	}
	return 0;
}

/**
  * The function is used to initialize the top of the stack to NULL
  *
  * @returns Nothing
  * @param s The reference to the stack
  *
  */
void initialize(Stack *s)
{
	s->stacktop=NULL;
}

/**
  * The function is used to pop some value off the stack
  *
  * @returns The element popped if sucessfull, FALSE otherwise
  * @param s The reference to the stack
  *
  */
int pop(Stack *s)
{
	if(s->stacktop==NULL)
	{
		return -1;
	}
	Node *temp=s->stacktop;
	int data=s->stacktop->data;
	s->stacktop=s->stacktop->next;
	free(temp);
	return data;
}

