#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(),
#include <mysql/mysql.h>

#define BUFFER 4096
#define MSG_SIZE 200
#define MAX_CLIENTS 95
#define MYPORT 7400

void Read();
void loginFn();

MYSQL *connection1;
MYSQL_RES *result;
MYSQL_ROW sqlrow;

int value=0,success=0;
int fd;
int num_clients = 0,id=0,FID[100];
char SId[10],list[200];
int listen_file_descriptor;
int return1;

/** Used to store File descriptors of all the clients
  *
  */
char fd_array[MAX_CLIENTS];
char msg[MSG_SIZE + 1];     
char loginName[100],password[100],allNames[100][100];
int friends[100],num=0,ONLINE[100],opened[100];
int present;

char newMsg[200];

/** This function is used to close properly the server when ctrl+c/quit is entered.
  *
  */

void close_properly(int signal)
{
    printf("Shutting down...\n");
    mysql_close(connection1);
    exit(0);
}
    
/** This function clears the leaving client 
  * when signout.
  *
  */

void exitClient(int fd, fd_set *readfds, char fd_array[], int *num_clients)
{
	int i;
	close(fd);
 	FD_CLR(fd, readfds); //clear the leaving client from the set
    	for (i = 0; i < (*num_clients) - 1; i++)
        	if (fd_array[i] == fd)
       		     break;          
    	for (; i < (*num_clients) - 1; i++)
 	{
        	(fd_array[i]) = (fd_array[i + 1]);
		ONLINE[i]=ONLINE[i+1];
	}

    	(*num_clients)--;

}


/** This function checks the loginname and pasword entered
  * by the user with data in the database.If it matches set
  * success=0 else set success=1;
  *
  */

void display_row ()
{
	unsigned int field_count;
    	field_count = 0;
    	if(strcmp(loginName,sqlrow[1])==0&&strcmp(password,sqlrow[3])==0)
    	{

       		value=1;
       		success=1;
		strcpy(SId,sqlrow[0]);
    	}
   	else if(strcmp(loginName,sqlrow[1])==0&&strcmp(password,sqlrow[3])!=0)
   	{

     		value=1;
     		success=0;
   	}
}

/** This function connects to the database using mysql_real_connect()
  * If connection fails displays error message.
  *
  */

void connectToDB()
{
   
   	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "root", "sairamatulasi", "cs3002_database", 0, NULL, 0))
    	{
		//printf ("Connection successful\n");
	
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
   	printf("\n connected to DB\n");
  	fflush(stdout);

	return ;
}

/** This function inserts the new user detaiks into the database 
  * table Login.It returns login already exist if user already exist
  *
  */    

void newFn()
{
   	int i,j,return_value;
   	char query[200];
   	i=0;
   	j=0;

   	while(msg[i]!='&')
       	{
       		i++;
       	}
       	i=i+2;
   	while(msg[i]!='\0')
      		query[j++]=msg[i++];
   	msg[0]='\0';
   	query[j]='\0';
   	return_value =  mysql_query (connection1,query);
	if (return_value)
	{
		//printf ("insert failed as : %s\n", mysql_error (connection1));
            	if(strstr(mysql_error(connection1),"key 2")!=NULL)
               		write(fd,"Login Name Exist",17);
            	else
               		write(fd,"insert failed",14);
	}
       	else
        	write(fd,"insert success",15);
   	return;   
}


/** This function finds online friends by comparing with the login info
  * all clients.
  *
  */ 

void display_row2 ()
{
	int i;
	for(i=0;i<num_clients-1;i++)
	{		
	 	if(ONLINE[i]==atoi(sqlrow[1]))
			friends[num++]=atoi(sqlrow[1]);
    	}
}

/** This function identifies the friends who are online.
  *
  */

void findFriends()
{
	int return_value;
	char query[100];
   	
 	sprintf(query,"select * from friends where myId=%d",id);
	return_value =  mysql_query (connection1, query);
	if (return_value)
	{
	    	printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    	result = mysql_use_result (connection1);
	    	if (result)
	    	{
			while ((sqlrow = mysql_fetch_row (result)))
		    	display_row2 ();
		
			if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
	    	}
	    	mysql_free_result(result);
	}

	     
}

void display_row3 ()
{
	strcat(list,sqlrow[1]);
	strcat(list,"^^");
}

/** Retrieves the login name of clients who are logged in and sends the
  * the message to client.
  *
  */

void sendMsg()
{
	int i,return_value;
	char query[100];
	list[0]='\0';
	strcpy(list,"LIST^^");
   	for(i=0;i<num;i++)
	{
 	sprintf(query,"select * from  Login where ID=%d",friends[i]);
	return_value =  mysql_query (connection1, query);
	if (return_value)
	{
	    	printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    	result = mysql_use_result (connection1);
	    	if (result)
	    	{
			while ((sqlrow = mysql_fetch_row (result)))
		    	display_row3 ();
		
			if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
	    	}
	    	mysql_free_result(result);
	}
	}
	write(fd,list,MSG_SIZE-1);
}

/** This function checks the loginname and password with the data in the database.
  * If matches send "correct" msg to the client.If password does not matches send "check"
  * message to the client.If user name does not matches send "wrong" message to the client.
  *
  */
void loginFn()
{
       	int i,j,k,return_value;
       	i=0;
       	k=0;
       	j=0;
       	success=0;
       	value=0;

        fflush(stdout);
       	while(msg[i]!='$')
       	{
        	i++;
       	}
       	i=i+2;
        fflush(stdout);
        while(msg[i]!='&')
        	loginName[k++]=msg[i++];
       	loginName[k]='\0';
       	while(msg[i]=='&')
            	i++;
       	do
       	{
        	password[j++]=msg[i];
           	i++;
       	}  
       	while(i<strlen(msg));
       	msg[0]='\0';
       	password[j]='\0';
       	return_value =  mysql_query (connection1, "select * from Login");
	if (return_value)
	{
	    	printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    	result = mysql_use_result (connection1);
	    	if (result)
	    	{
			while ((sqlrow = mysql_fetch_row (result)))
		    	display_row ();
		
			if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
	    	}
	    	mysql_free_result(result);
	}
	if(value==1)
    	{
       		if(success==1)
		{
    	   		sprintf(msg,"correct");
			id=atoi(SId);
			ONLINE[num_clients-1]=id;
			strcpy(allNames[num_clients-1],loginName);
			num=0;
			return_value = write(fd, msg, strlen(msg));
			findFriends();	
			sendMsg();
		}
       		else
		{
        		sprintf(msg,"check");
			return_value = write(fd, msg, strlen(msg));
			close(fd_array[num_clients-1]);
			num_clients--;
		}
    	}
   	else
   	{ 

      		sprintf(msg,"wrong");
		return_value = write(fd, msg, strlen(msg));
		close(fd_array[num_clients-1]);
		num_clients--;
     
   	}



    	if(return_value < 0)
	{
	    	perror("write() failed.");
	    	exit(1);
	}
       
    

}

/** This function decodes the chatting message from the client
  * Saves the message information in the database.
  *
  */

void message(char *MSG)
{
	int i,j,return_value;
	char *part;
	char query[100];	
	char myname[100],fname[100],msg[200],DMSG[200],msg2[200];
	strcpy(DMSG,MSG);
 	part=strtok(MSG,"##");
	part=strtok(NULL,"##");
	strcpy(myname,part);
	part=strtok(NULL,"##");
	strcpy(fname,part);
	part=strtok(NULL,"##");
	strcpy(msg,part);
	fflush(stdout);
	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],fname)==0)
			write(fd_array[i],DMSG,strlen(DMSG));

	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],fname)==0)
			break;


	for(j=0;j<num_clients;j++)
		if(strcmp(allNames[j],myname)==0)
			break;	
	sprintf(msg2,"%s:%s",myname,msg);
	sprintf(query,"insert into history values(%d,%d,'%s')",ONLINE[i],ONLINE[j],msg2);
	return_value =  mysql_query (connection1,query );
	if (return_value)
	{
	    	printf ("select failed as : %s\n", mysql_error (connection1));
	}
	
	query[0]='\0';
	sprintf(query,"insert into history values(%d,%d,'%s')",ONLINE[j],ONLINE[i],msg2);
	return_value =  mysql_query (connection1,query );
	if (return_value)
	{
	    	printf ("select failed as : %s\n", mysql_error (connection1));
	}
				
}



void display_row4 (char fname[100])
{
	int i;
	for(i=0;i<num_clients-1;i++)
	{		
	 	if(strcmp(fname,sqlrow[1]))
			present=atoi(sqlrow[0]);
    	}
}



void display_row6 ()
{
	strcat(newMsg,sqlrow[2]);
	
}

/** This function receives the photo from the sender client 
    and sends to the receiver client.
  *
  */


void photo(char *MSG)
{
	int i,j;
	char *part;
	char myname[100],fname[100],DMSG[200];
	strcpy(DMSG,MSG);
	
 	part=strtok(MSG,"|||||");
	part=strtok(NULL,"|||||");
	strcpy(myname,part);
	part=strtok(NULL,"|||||");
	strcpy(fname,part);
	
	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],myname)==0)
			break;
	for(j=0;j<num_clients;j++)
		if(strcmp(allNames[j],fname)==0)
			break;
	part=strtok(NULL,"|||||");
	write(fd_array[j],DMSG,strlen(DMSG));
		
}

/** This function receives the accept/reject message from the sender client 
    and sends to the receiver client.
  *
  */


void startPhoto(char *MSG)
{
	int i,j;
	char *part;
	char myname[100],fname[100],DMSG[200];
	DMSG[0]='\0';
	strcpy(DMSG,MSG);
 	part=strtok(MSG,"|||||");
	part=strtok(NULL,"|||||");
	strcpy(myname,part);
	part=strtok(NULL,"|||||");
	strcpy(fname,part);

	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],myname)==0)
			break;
	for(j=0;j<num_clients;j++)
		if(strcmp(allNames[j],fname)==0)
			break;
	write(fd_array[j],DMSG,strlen(DMSG));
	return;	
}

/** This function retrieves the chatting history from
  * the database and send the chatting history to the client.
  *
  */

void history(char *MSG)
{
	int i,j,return_value;
	char *part;
	char query[100];	
	char myname[100],fname[100],DMSG[200];
	strcpy(DMSG,MSG);
 	part=strtok(MSG,"!!!");
	part=strtok(NULL,"!!!");
	strcpy(myname,part);
	part=strtok(NULL,"!!!");
	strcpy(fname,part);
	
	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],myname)==0)
			break;
	for(j=0;j<num_clients;j++)
		if(strcmp(allNames[j],fname)==0)
			break;
	sprintf(query,"select * from history where (myId=%d AND FID=%d)",ONLINE[i],ONLINE[j]);
	printf("\n |%s|\n",query);
	return_value =  mysql_query (connection1, query);
	if (return_value)
	{
	    	printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
		strcpy(newMsg,"HISTORY***");
	    	result = mysql_use_result (connection1);
	    	if (result)
	    	{
			while ((sqlrow = mysql_fetch_row (result)))
			{
		    		display_row6();
				if(strlen(newMsg)>=190)
				{
					write(fd_array[i],newMsg,strlen(newMsg));
					usleep(500);
					strcpy(newMsg,"HISTORY***");
				}
				else
					strcat(newMsg,"***");
			}
			
			strcat(newMsg,"OVER");
			write(fd_array[i],newMsg,strlen(newMsg));
			usleep(500);							
			if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
	    	}
	    	mysql_free_result(result);
	}	
	
}

/** This function decodes the message from the  receiver client that
  * he accepts the photo and sends the message to sender client.
  *
  */


void acceptPhoto(char *MSG)
{
	int i,j;
	char *part;
	char myname[100],fname[100],DMSG[200];
	strcpy(DMSG,MSG);
	
 	part=strtok(MSG,"&&&&");
	part=strtok(NULL,"&&&&");
	strcpy(fname,part);
	part=strtok(NULL,"&&&&");
	strcpy(myname,part);
	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],myname)==0)
			break;
	for(j=0;j<num_clients;j++)
		if(strcmp(allNames[j],fname)==0)
			break;
	write(fd_array[j],DMSG,strlen(DMSG));
}

/** This function decodes the message from the  receiver client that
  * he rejects the photo and sends the message to sender client.
  *
  */

void reject(char *MSG)
{
	int i,j;
	char *part;
	char myname[100],fname[100],DMSG[200];
	strcpy(DMSG,MSG);
	
 	part=strtok(MSG,"&&&&");
	part=strtok(NULL,"&&&&");
	strcpy(fname,part);
	part=strtok(NULL,"&&&&");
	strcpy(myname,part);
	for(i=0;i<num_clients;i++)
		if(strcmp(allNames[i],myname)==0)
			break;
	for(j=0;j<num_clients;j++)
		if(strcmp(allNames[j],fname)==0)
			break;
	write(fd_array[j],DMSG,strlen(DMSG));
}

/**
  * Used to create a tcp messenger server.
  * Note that it will work only for ipv4 servers.
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{

	int i=0,j=0;
	int port;

   	int server_sockfd, client_sockfd;
   	struct sockaddr_in server_address;
   	int addresslen = sizeof(struct sockaddr_in);

   	fd_set readfds, testfds;
	char kb_msg[MSG_SIZE + 10]; 
	char statement[200];
   
	/*Client variables=======================*/
   	int result;

   	connectToDB();
   	/*Server==================================================*/
	if(argc!=3)
	{
        	printf("Invalid parameter.\nUsage:./2Server -p portNumber\n");
        	exit(0);
       	}	
   	if(argc==1 || argc == 3)
	{
     		if(argc==3)
		{
       			if(!strcmp("-p",argv[1]))
			{
         			sscanf(argv[2],"%i",&port);
       			}
			else
			{
         			printf("Invalid parameter.\nUsage: chat [-p PORT] HOSTNAME\n");
         			exit(0);
       			}
     		}
		else
			port=MYPORT;
		printf("\n*** Server program starting (enter \"quit\" to stop): \n");
     		fflush(stdout);

     		/* Create and name a socket for the server */
     		server_sockfd = socket(AF_INET, SOCK_STREAM, 0);
                bzero(&server_address, sizeof(server_address));
     		server_address.sin_family = AF_INET;
   		server_address.sin_addr.s_addr = htonl(INADDR_ANY);
     		server_address.sin_port = htons(port);
     		bind(server_sockfd, (struct sockaddr *)&server_address, addresslen);
	        

     		/*Create a connection queue and initialize a file descriptor set */

     		listen(server_sockfd, 1);
               
 

     		FD_ZERO(&readfds);
     		FD_SET(server_sockfd, &readfds);
     		FD_SET(0, &readfds); 
               
                /* Add keyboard to file descriptor set */
     
		 struct sigaction act1;
    
    		act1.sa_handler = close_properly;
    		sigemptyset(&act1.sa_mask);
    		act1.sa_flags=0;
		sigaction(SIGINT, &act1, 0);
    
     		/*  Now wait for clients and requests */
     		while (1)
		{
        		testfds = readfds;
        		select(FD_SETSIZE, &testfds, NULL, NULL, NULL);
                    
        		/* If there is activity, find which descriptor it's on using FD_ISSET */
        		for (fd = 0; fd < FD_SETSIZE; fd++)
			 {
           			if (FD_ISSET(fd, &testfds))
				{
              
              				if (fd == server_sockfd)
					{ /* Accept a new connection request */
                 				client_sockfd = accept(server_sockfd, NULL, NULL);

                				if (num_clients < MAX_CLIENTS)
						{
                  					FD_SET(client_sockfd, &readfds);
                    					fd_array[num_clients]=client_sockfd;

                    					printf("\n Client %d joined\n",num_clients++);
                    					fflush(stdout);

                    					
						}
						else
						{
							sprintf(msg, "XSorry, too many clients.  Try again later.\n");
                    					write(client_sockfd, msg, strlen(msg));
                    					close(client_sockfd);
                 				}
              				}
              				else if (fd == 0)
					{   
                                                /* Process keyboard activity */                 
                 				fgets(kb_msg, MSG_SIZE + 1, stdin);

                  				if (strcmp(kb_msg, "quit\n")==0)
						{
                    					sprintf(msg, "XServer is shutting down.\n");
                    					for (i = 0; i < num_clients ; i++)
							{
                       						write(fd_array[i], msg, strlen(msg));
                       						close(fd_array[i]);  
                    					}
							for(i=0;i<num_clients;i++)
								close(fd_array[i]);
                    					close(server_sockfd);
                                                        mysql_close(connection1);
                    					exit(0);
                 				}
                 				else
						{

                    					sprintf(msg, "M%s", kb_msg);
                    					for (i = 0; i < num_clients ; i++)
                       						write(fd_array[i], msg, strlen(msg));
                 				}
              				}
              				else if(fd)
					 {  
 						/*Process Client specific activity*/
                				
						msg[0]='\0';
						memset(msg,MSG_SIZE,0);
                 				result = read(fd, msg, MSG_SIZE);
                 
                 				if(result==-1) perror(" error in read()");

                 				else if(result>0)
						{
			                    		msg[result]='\0';
                    					if(strstr(msg, "LOGIN")!=NULL)
                 					{

                        					
 								loginFn();
								for(i=0;i<num_clients;i++)
								{
                         					    for(j=0;j<num;j++)
									if(friends[j]==ONLINE[i])
									{
										
										sprintf(statement,"Friend-Client ^^%d joined with &&%s",ONLINE[i],loginName);
                                   						write(fd_array[i],statement,strlen(statement));
									}
                           					}
                 					}
							else if(strstr(msg, "NEWUSER")!=NULL)
                 					{
 								newFn();
                 					}
							else if(strstr(msg, "MSG")!=NULL)
                 					{

 								message(msg);
                 					}
							else if(strstr(msg, "HISTORY")!=NULL)
                 					{

 								history(msg);
                 					}
							else if(strstr(msg, "STARTPHT")!=NULL)
                 					{

 								startPhoto(msg);
                 					}
							else if(strstr(msg, "PHOTO")!=NULL)
                 					{

 								photo(msg);
                 					}
							else
                  					{
                    
                    						
								for(i=0;i<num_clients;i++)
								{
                       							if (fd_array[i] != fd)  /*dont write msg to same client*/
                          							write(fd_array[i],msg,strlen(msg));
                    						} 	                    						
								if(msg[0] == 'X')
								{
                       							exitClient(fd,&readfds, fd_array,&num_clients);
                    						}
								
                  					}  
                 				}                                   
              				}                  
              				else
					{  /* A client is leaving */
                 				exitClient(fd,&readfds, fd_array,&num_clients);
              				}//if
           			}//if
        		}//for
     		}//while
  	}//end Server code
  	return 0;
}

