#include "plot.h"

Plot::Plot()
{
    unsigned int i;
    for (i = 0; i < NUM_POINTS; i++)
        data[i] = 0.0;
}

Plot::~Plot()
{

}

void Plot::get_load()
{

    guint i;
    int j;
    glibtop_cpu cpu;
    glibtop_get_cpu (&cpu);
     for (j = NUM_POINTS - 1; j > 0; j--)
    {
        data[j] = data[j - 1];
    }

    this->cpu.times[this->cpu.now][0][CPU_TOTAL] = cpu.total;
    this->cpu.times[this->cpu.now][0][CPU_USED] = cpu.user + cpu.nice + cpu.sys;
    double load;
    double total, used;
    total = this->cpu.times[this->cpu.now][0][CPU_TOTAL] - this->cpu.times[this->cpu.now ^ 1][0][CPU_TOTAL];
    used  = this->cpu.times[this->cpu.now][0][CPU_USED]  - this->cpu.times[this->cpu.now ^ 1][0][CPU_USED];

    load = used / MAX(total, 1.0f);
    data[0] = load * 100;
    this->cpu.now ^= 1;

    FILE *fp = fopen("datafile", "w");
    if(fp)
    {
        for(i = 0; i < NUM_POINTS; i++)
        {
            fprintf(fp, "%d %lf\n", i, data[i]);
        }
        fclose(fp);
        system("graph -T png -x 60 0 -y 0 100 --bitmap-size 400x400 datafile > graph.png");
    }

}
