
#ifndef __PLOT_H__
#define __PLOT_H__

#include <QtCore/QDebug>
#include <QtCore/QTimer>
#include <QtCore/QTimerEvent>

#include <glibtop.h>
#include <glibtop/cpu.h>

static const unsigned NUM_POINTS = 60 + 1;
enum
{
    CPU_TOTAL,
    CPU_USED,
    N_CPU_STATES
};
class Plot
{
private:
    guint n;
    struct
    {
            guint now;
            guint64 times[2][GLIBTOP_NCPU][N_CPU_STATES];
    } cpu;
    float data[NUM_POINTS];
public:
    Plot();
    ~Plot();
    void get_load();

};

#endif // __PLOT_H__

