#include "previewwindow.h"


#define LSOF_OP_FILE "/tmp/lsof_op_file"

using namespace std;

/*!
 * The constructor is to initialize a preview window by placing a text-editor and close-button widgets in it.
 */

PreviewWindow::PreviewWindow(QWidget *parent)
    : QWidget(parent)
{
    textEdit = new QTextEdit;
    textEdit->setReadOnly(true);
    textEdit->setLineWrapMode(QTextEdit::NoWrap);

    closeButton = new QPushButton(tr("&Close"));
    connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

    layout = new QVBoxLayout;
    layout->addWidget(textEdit);
    layout->addWidget(closeButton);
    setLayout(layout);

    setWindowTitle(tr("Preview"));
}

 PreviewWindow::~PreviewWindow()
 {
     delete textEdit;
     delete closeButton;
     delete layout;
 }

 /*!
 * This function executes the lsof command and populates the result in an output file.
 */
void PreviewWindow::lsofPopulate(std::string lsof_pid)
{
    char cmd[256];
    sprintf(cmd,"lsof -p %s > %s",lsof_pid.c_str(),LSOF_OP_FILE);
    system(cmd);
}

/*!
 * This function sets the visibility options of the preview window. It fills the text-editor widget with contents of the file created in the
 * lsofPopulate() function.
 */
void PreviewWindow::updatePreview()
{
    QPoint pos = this->pos();
    QString text;
    FILE *fp;
    char line[1000];
    if (pos.x() < 0)
        pos.setX(0);
    if (pos.y() < 0)
        pos.setY(0);
    this->move(pos);
    this->show();
    fp = fopen(LSOF_OP_FILE,"r");
    while(fgets(line,1000,fp)!=NULL)
    {
        text += QString(line);
        text += "\n";
    }
    textEdit->setPlainText(text);
    fclose(fp);
}
