/*!
 * This class represents the table object in the Processes tab of main window.
 */

#ifndef TABLEMODEL_H
#define TABLEMODEL_H

#include <QAbstractTableModel>
#include <QPair>
#include <QList>
#include <QTimer>
#include <string>
#include "process.h"
#include "previewwindow.h"
#include "processextractor.h"

class TableModel : public QAbstractTableModel
{
    Q_OBJECT
    QTimer *timer;
public:
    TableModel(QObject *parent=0);
    TableModel(QList< Process > listofPairs, QObject *parent=0);
    ~TableModel();

    std::string lsof_pid;
    PreviewWindow fileList;

    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &parent) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    Qt::ItemFlags flags(const QModelIndex &index) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role=Qt::EditRole);
    bool insertRows(int position, int rows, const QModelIndex &index=QModelIndex());
    bool removeRows(int position, int rows, const QModelIndex &index=QModelIndex());
    bool refillRows(const QModelIndex &index=QModelIndex());
    QList< Process > getList();
 private slots:
    void refreshTable();
    void rowSelected(QModelIndex index);

private:
    QList< Process > listOfProcesses;
};
//! [0]

#endif
