/**This is an header file for "client.c" which includes all the header files and global variables used.
  *@file client.h
  *@author Ratna Kumar K.V.R
  */
#include <unistd.h>	//for close(), write(), read(), fstat(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(), atoi(),
#include <string.h>	//for strlen(),strcpy()
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(), fstat(), open()
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <sys/select.h> //for select(),
#include <fcntl.h>	//for open(),
#include <sys/time.h>	//for time(),
#include <arpa/inet.h>  //for inet_ntoa(), 
#include <pthread.h>	//for pthread_create(), pthread_exit()
#include <gtk/gtk.h>	//for all GTK functions..

#define BUFFER 4096 /**<defines maximum data transfer*/
#define DATASIZE 100 /**< defines data size for ip, nick*/

/**
  * Used for storing client information like file descriptor through which client is connected,   
  * nick name of the connected client, ip address of client machine.
  */	
struct client_data{
int fd;/**< file descriptor through which client is connected*/
char nick[DATASIZE];/**<nick name of the connected client*/
char ip[DATASIZE];/**<ip address of client machine.*/
};

/**
  *Used as the the basic unit of communication between client and server.
  *Each time the server communicates with the client, it sends this unit of information
  *It includes nick name of the client, ip address of client, message to be sent to 
  *the client and time stamp of client message
  */
struct transmit_unit{
char nick[DATASIZE];/**<nick name of the client*/
char time[DATASIZE];/**<time stamp of the client message*/
char ip[DATASIZE];/**<ip address of client*/
char msg[BUFFER];/**<message to be sent*/
};

GtkWidget *entry; /**< GTK entry for typing messages*/
GtkWidget *entry_ipaddress;/**< GTK entry for entering IP address of server*/
GtkWidget *entry_nick; /**<GTK entry for entering nick name*/
GtkWidget *entry_port; /**<GTK entry for entering the port number*/
GtkTextBuffer *buffer; /**<for Chat Window.*/
GtkTextIter iter; /**<iterator for Text Buffer used in chat window*/
GtkListStore *list_store; /**<List for showing all connected clients*/
GtkTreeIter   t_iter; /**<iterator for list used in List*/

int socket_file_descriptor; /**<used to store file descriptor of socket when opened.*/
char msg[BUFFER]; /**<used for storing message*/
char nick[BUFFER]; /**<used for storing nick name*/
char ip[BUFFER]; /**<used for storing ip address*/
