/**This is an header file for "server.c" which includes all the header files and global variables used.
  *@file server.h
  *@author Ratna Kumar K.V.R
  */

#include <unistd.h>	//for close(), write(), read(), fstat(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(), atoi(),
#include <string.h>	//for strlen(),strcpy()
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(), fstat(), open()
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <sys/select.h> //for select(),
#include <fcntl.h>	//for open(),
#include <sys/time.h>	//for time(),
#include <arpa/inet.h>  //for inet_ntoa(), 
#include <pthread.h> 	//for pthread_create(), pthread_exit()
#include <gtk/gtk.h>	//for all gtk functions..
#include <time.h>	//for time(),
#include <mysql/mysql.h>// for mysql_real_connect(), mysql_query()

#define BUFFER 4096 /**<defines maximum data transfer*/
#define DATASIZE 100 /**< defines data size for ip, nick*/

/**
  * Used for storing client information like file descriptor through which client is connected,   
  * nick name of the connected client, ip address of client machine.
  */	
struct client_data{
int fd; /**< file descriptor through which client is connected*/
char nick[DATASIZE]; /**<nick name of the connected client*/
char ip[DATASIZE]; /**<ip address of client machine.*/
};

/**
  *Used as the the basic unit of communication between client and server.
  *Each time the server communicates with the client, it sends this unit of information
  *It includes nick name of the client, ip address of client, message to be sent to 
  *the client and time stamp of the message
  */
struct transmit_unit{
char nick[DATASIZE];/**<nick name of the client*/
char time[DATASIZE];/**<time stamp of the client message*/
char ip[DATASIZE];/**<ip address of client*/
char msg[BUFFER];/**<message to be sent*/
};


GtkWidget *entry_port; /**< GTK entry for entering the port number on which server should listen*/
GtkTextBuffer *buffer; /**<for chat window*/
GtkTextIter iter; /**<iterator for textbuffer used in chat window*/

GtkListStore *list_store; /**<for showing the list of connected clients*/
GtkTreeIter   t_iter;	/**<iterator for list which is used for listing connected clients*/


int listen_file_descriptor; /**<the file descriptor on which server listens*/

struct client_data client[FD_SETSIZE]; /**<For storing each client information. The server can handle maximum FD_SETSIZE number of clients*/

int maxi; /**<temporary variable used for storing the number of clients connected currently*/
char err_msg[BUFFER]; /**< used for storing error message when there are any errors*/
char ip[BUFFER]; /**<used for storing ip address of client*/
char nick[BUFFER];/**<used for storing nick name of client*/
int success; /**<temporary variable used for proper server set up*/


MYSQL *connection1;/**<Handler for mysql connection*/
