#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtk/gtksignal.h>
#include <gtk/gtktable.h>
#include <gtk/gtktogglebutton.h>
#include "tictactoe_game.h"
#include<sys/types.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include "connect.h"
#include<mysql/mysql.h>
#include<string.h>
#define SERV_TCP_PORT 9999
#define BUFSIZE 1024

MYSQL *connection1;
MYSQL_RES *result;
MYSQL_ROW sqlrow;
GtkWidget *view;
GtkTextBuffer *buffer;
GtkTextIter iter;
GtkToggleButton *button;

struct sockaddr_in server_address;

enum 
{
  TICTACTOE_SIGNAL,
  LAST_SIGNAL
};
struct myparam
{
	GtkEntry *name_entry;
	GtkLabel *status_label;
};
gint close_application( GtkWidget *widget,GdkEvent  *event,gpointer   data )
{
  gtk_main_quit();
  return(FALSE);
}
static void tictactoe_class_init (TictactoeClass *class);
static void tictactoe_init       (Tictactoe      *tictac);
static void tictactoe_toggle     (GtkWidget *widget, Tictactoe *tictac);
static void check (GtkWidget *widget, Tictactoe *tictac);
static guint tictactoe_signals[LAST_SIGNAL] = { 0 };

GType tictactoe_get_type (void)
{
  static GType tictac_type = 0;

  if (!tictac_type)
    {
      static const GTypeInfo tictac_info =
      {
	sizeof (TictactoeClass),
	NULL, /* base_init */
        NULL, /* base_finalize */
	(GClassInitFunc) tictactoe_class_init,
        NULL, /* class_finalize */
	NULL, /* class_data */
        sizeof (Tictactoe),
	0,
	(GInstanceInitFunc) tictactoe_init,
      };

      tictac_type = g_type_register_static (GTK_TYPE_TABLE, "Tictactoe", &tictac_info, 0);
    }

  return tictac_type;
}

static void tictactoe_class_init (TictactoeClass *class)
{
  
  tictactoe_signals[TICTACTOE_SIGNAL] =  g_signal_new ("tictactoe",
					 G_TYPE_FROM_CLASS (class),
	                                 G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
	                                 G_STRUCT_OFFSET (TictactoeClass, tictactoe),
                                         NULL, 
                                         NULL,                
					 g_cclosure_marshal_VOID__VOID,
                                         G_TYPE_NONE, 0);
}
void button1(GtkToggleButton *button)
{
	gtk_button_set_label(GTK_BUTTON(button),"X");
}
void button2(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[1][1],"O");
	
}
void button3(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[0][2],"O");
	
}
void button4(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[0][1],"O");
	
}
void button5(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[2][0],"O");
	
}
void button6(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[0][0],"O");
	
}
void button7(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[2][2],"O");
	
}
void button8(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[1][2],"O");
	
}
void button9(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[2][1],"O");
	
}
void button10(GtkToggleButton *button, Tictactoe *tictac)
{
	gtk_button_set_label(tictac->buttons[1][0],"O");
	
}
void label1 (GtkWidget *entry1, GdkEventKey *event, gpointer label1)
{
	// Check for text in the text entry box   
     if ( (int) g_utf8_strlen(gtk_entry_get_text(GTK_ENTRY(entry1)), -1) != 0)
     {
       gchar *str = NULL;
       str = g_strconcat("Player Name : ", gtk_entry_get_text(GTK_ENTRY(entry1)), NULL);

       // Set the label text
       gtk_label_set_text(GTK_LABEL(label1), str);

       // Free up the memory
       g_free(str);
     }
     else // There are no characters in the text entry box
     {
       // Clear the label
       gtk_label_set_text(GTK_LABEL(label1), NULL);
     }
	
}
void add_records(GtkWidget *button, gpointer data)
{

	struct myparam *mp = data;
	
        const char *name_text =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->name_entry));
        const char *status_label1 =gtk_label_get_text(GTK_LABEL((GtkWidget *)mp->status_label));

    	char sql_statement[BUFFER];
   
    	int result2;
	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
	 	sprintf(sql_statement,"insert into player (name,status)values('%s','%s')",name_text,status_label1);
	
	 	result2 = mysql_query (connection1, sql_statement);
	
		if (result2==0)
		{
	    		printf ("Row inserted successfully.\n");
		}
		else
		{
	    		fprintf (stderr, "Could not insert data");
	    		mysql_close (connection1);
	    		exit(EXIT_FAILURE);
		}
		mysql_close (connection1);
   	 }
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
    	}
}
void fetch_records(GtkWidget *entry1, GdkEventKey *event, GtkWidget *label1)
{
    char sql_statement[BUFFER];
    int return_value;

    connection1=mysql_init (NULL);
    if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    {
	
    	sprintf(sql_statement, "SELECT * from player");
    	return_value = mysql_query (connection1, sql_statement);

   	if (return_value)
	{
	    printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    result = mysql_use_result (connection1);
	    if (result)
	    {
		if (mysql_use_result (connection1)==0)
		{
			
			while ((sqlrow = mysql_fetch_row (result)))
		    		display_row ();
		}
		else
		{	
			printf("Data that you search not in the database");
			
		}
		
			if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
		
	    }
	    mysql_free_result(result);
	}
	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
	exit(EXIT_FAILURE);
    }
	
}
void count_records(GtkWidget *entry1, GdkEventKey *event, GtkWidget *label1)
{
    char sql_statement[BUFFER];
    int return_value;

    connection1=mysql_init (NULL);
    if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    {
	
    	sprintf(sql_statement, "SELECT count(*) from player");
    	return_value = mysql_query (connection1, sql_statement);

   	if (return_value)
	{
	    printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    result = mysql_use_result (connection1);
	    if (result)
	    {
		if (mysql_use_result (connection1)==0)
		{
			
			while ((sqlrow = mysql_fetch_row (result)))
		    		display_row1 ();
		}
		else
		{	
			printf("Data that you search not in the database");
			
		}
		
			if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}
		
	    }
	    mysql_free_result(result);
	}
	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
	exit(EXIT_FAILURE);
    }
	
}
void display_row ()
{
    unsigned int field_count;

    buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
	
    gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
    
    field_count = 0;
	
    while (field_count < mysql_field_count (connection1))
    {
	printf ("%s ", sqlrow[field_count]);
	
	gtk_text_buffer_insert(buffer, &iter, sqlrow[field_count], -1);
	gtk_text_buffer_insert(buffer, &iter, "\t", -1);
	

	field_count++;
    }
	gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	
    printf ("\n");
}
void display_row1 ()
{
    unsigned int field_count;

    buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
	
    gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
    
    field_count = 0;
    while (field_count < mysql_field_count (connection1))
    {
	printf ("%s ", sqlrow[field_count]);
	gtk_text_buffer_insert(buffer, &iter, "Number of player : \t", -1);
	gtk_text_buffer_insert(buffer, &iter, sqlrow[field_count], -1);
	
	gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	gtk_text_buffer_insert(buffer, &iter, "List of player: \t", -1);
	gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	gtk_text_buffer_insert(buffer, &iter, "\nName Status\n", -1);
	gtk_text_buffer_insert(buffer, &iter, "--------------\n", -1);

	field_count++;
    }
	
    printf ("\n");
}

static void tictactoe_init (Tictactoe *tictac)
{
   	gint i,j,k,l;
   	GdkColor color1;
   	GdkColor color2;
   
  	gtk_table_resize (GTK_TABLE (tictac), 3, 3);
  	gtk_table_set_homogeneous (GTK_TABLE (tictac), TRUE);
  	gdk_color_parse( "orange", &color1 );
  	gdk_color_parse( "green", &color2 );

  	for (i=0;i<3; i++)
    		for (j=0;j<3; j++)
   		{
			tictac->buttons[i][j] = gtk_toggle_button_new ();
			gtk_table_attach_defaults (GTK_TABLE (tictac), tictac->buttons[i][j],i, i+1, j, j+1);
			g_signal_connect (G_OBJECT (tictac->buttons[i][j]), "toggled",G_CALLBACK (tictactoe_toggle), (gpointer) tictac);
			g_signal_connect (G_OBJECT (tictac->buttons[i][j]), "toggled",G_CALLBACK (button1), (gpointer) tictac);
		
			gtk_widget_set_size_request (tictac->buttons[i][j], 50, 50);
        		gtk_widget_modify_bg ( GTK_WIDGET(tictac->buttons[i][j]), GTK_STATE_NORMAL, &color1);
        		gtk_widget_modify_bg( GTK_WIDGET(tictac->buttons[i][j]), GTK_STATE_SELECTED, &color2 );
        		gtk_widget_show (tictac->buttons[i][j]); 	
    		}

		g_signal_connect (G_OBJECT (tictac->buttons[0][0]), "toggled",G_CALLBACK (button2), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[0][1]), "toggled",G_CALLBACK (button8), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[0][2]), "toggled",G_CALLBACK (button7), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[1][0]), "toggled",G_CALLBACK (button5), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[1][1]), "toggled",G_CALLBACK (button6), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[1][2]), "toggled",G_CALLBACK (button10), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[2][0]), "toggled",G_CALLBACK (button3), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[2][1]), "toggled",G_CALLBACK (button4), (gpointer) tictac);
		g_signal_connect (G_OBJECT (tictac->buttons[2][2]), "toggled",G_CALLBACK (button9), (gpointer) tictac);
  
}

GtkWidget* tictactoe_new ()
{
  	return GTK_WIDGET (g_object_new (tictactoe_get_type (), NULL));
}
/* See if there is a winner. */
static void check (GtkWidget *widget, Tictactoe *tictac)
{
  	int i;

  	for(i=0; i<3; i++)  /* check rows */
    		if(gtk_button_get_label(tictac->buttons[i][0])==gtk_button_get_label(tictac->buttons[i][1]) &&
      		 gtk_button_get_label(tictac->buttons[i][0])==gtk_button_get_label(tictac->buttons[i][2])) return gtk_button_get_label(tictac->buttons[i][0]);

  	for(i=0; i<3; i++)  /* check columns */
    		if(gtk_button_get_label(tictac->buttons[0][i])==gtk_button_get_label(tictac->buttons[1][i]) &&
      		gtk_button_get_label(tictac->buttons[0][i])==gtk_button_get_label(tictac->buttons[2][i])) return gtk_button_get_label(tictac->buttons[0][i]);

  	/* test diagonals */
  	if(gtk_button_get_label(tictac->buttons[0][0])==gtk_button_get_label(tictac->buttons[1][1]) &&
     		gtk_button_get_label(tictac->buttons[1][1])==gtk_button_get_label(tictac->buttons[2][2]))
     		printf("Won!!");

  	if(gtk_button_get_label(tictac->buttons[0][2])==gtk_button_get_label(tictac->buttons[1][1]) &&
    		gtk_button_get_label(tictac->buttons[1][1])==gtk_button_get_label(tictac->buttons[2][0]))
      		printf("Won!!");

	

  	return ' ';
}
static void tictactoe_toggle (GtkWidget *widget, Tictactoe *tictac)
{
  	int i,k;

  	static int row_wins[8][3] = { { 0, 0, 0 }, { 1, 1, 1 }, { 2, 2, 2 },
			    	 { 0, 1, 2 }, { 0, 1, 2 }, { 0, 1, 2 },
			     	 { 0, 1, 2 }, { 0, 1, 2 } };
  	static int clmn_wins[8][3] = { { 0, 1, 2 }, { 0, 1, 2 }, { 0, 1, 2 },
			     	 { 0, 0, 0 }, { 1, 1, 1 }, { 2, 2, 2 },
			     	 { 0, 1, 2 }, { 2, 1, 0 } };

  	int success, found;

  	for (k = 0; k<8; k++)
    	{
      		success = TRUE;
      		found = FALSE;

      		for (i = 0; i<3; i++)
		{
	  		success = success && GTK_TOGGLE_BUTTON (tictac->buttons[row_wins[k][i]][clmn_wins[k][i]])->active;
	  		found = found ||tictac->buttons[row_wins[k][i]][clmn_wins[k][i]] == widget;
		}
      
      		if (success && found)
		{
	  		g_signal_emit (G_OBJECT (tictac), tictactoe_signals[TICTACTOE_SIGNAL], 0);
	  		break;
		}
		check(widget,tictac);
    	 }
}


void win(  GtkWidget *widget,gpointer   data)
{
	gtk_label_set_text(GTK_LABEL(data), "Won!!");
	
}
void button_pressed1(GtkWidget *widget, gpointer entry3)
{
   	gchar *str;

   	str = g_strdup_printf("%s", gtk_button_get_label(GTK_BUTTON(widget)));
        gtk_entry_set_text(GTK_ENTRY(entry3),"");
   	g_free(str);
}

int main( int   argc, char *argv[] )
{
  	GtkWidget *window;
  	GtkWidget *tictac;
 	GtkWidget *box_A;
  	GtkWidget *box_B;
  	GtkWidget *label_A;
 	GtkWidget *separator;
  	GtkWidget *image;
        GtkWidget *fixed;
  	GtkWidget *label_C;
  	GtkWidget *buttonSubmit;
  	GtkWidget *buttonClear;
	GtkWidget *fixed_A;
	GtkWidget *buttonHistory;
	GtkWidget *label_D;
	GtkWidget *buttonExit;
	
	struct myparam mp;
   
	int socket1;

	if(argc != 2)
   	{
		fprintf(stderr, "%s: usage: %s <server_ip_address>\n", argv[0], argv[0]);
		exit(1);
    	}
	printf("\n");
	
	bzero ((char *) &server_address, sizeof(server_address));
	server_address.sin_family = AF_INET;
	server_address.sin_port = htons (SERV_TCP_PORT);
	inet_pton (AF_INET, argv[1], &server_address.sin_addr);
	
	if( (socket1 = socket(AF_INET, SOCK_STREAM, 0) ) < 0) perror("Client:  socket()error\n");

        if(connect(socket1,(struct sockaddr *)&server_address,sizeof(server_address)) < 0)
	{
		perror("Client: error connect() \n"); 
	}
	else
        {	
		printf("___________________Client______________________\n\n");
		printf("Connection success with server ip: %s \n",
		inet_ntoa(server_address.sin_addr));

	connection1 = mysql_init(NULL);
   	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
		printf ("Connection successful\n");
	}
	 else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
		}
   	 }
        
  	gtk_init (&argc, &argv);

  	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  	gtk_window_set_title (GTK_WINDOW (window), "Aspect Frame");
  
  	g_signal_connect (G_OBJECT (window), "destroy",G_CALLBACK (exit), NULL);
  
  	gtk_window_set_title (GTK_WINDOW (window), "Tic Tac Toe Game");
  	gtk_container_set_border_width (GTK_CONTAINER (window), 10);
  	gtk_window_set_default_size(GTK_WINDOW(window),250,200);

  	box_A = gtk_vbox_new (FALSE, 5);
  	gtk_container_set_border_width (GTK_CONTAINER (box_A), 5);
  	gtk_container_add (GTK_CONTAINER (window), box_A);
  	gtk_widget_show (box_A);

    	image = gtk_image_new_from_file ("tictactoe1.jpeg");
    	gtk_box_pack_start (GTK_BOX (box_A), image, FALSE, FALSE, 0);
    	gtk_widget_grab_focus(image);
    	gtk_widget_show (image);    

	label_D = gtk_label_new ("Human vs Computer");
        gtk_box_pack_start (GTK_BOX (box_A),  label_D, FALSE, TRUE, 0);
  	gtk_widget_grab_focus(label_D);
  	gtk_widget_show (label_D);

        fixed = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_A), fixed, FALSE, FALSE, 0);

  	label_C = gtk_label_new ("Enter your name :");
 	gtk_fixed_put(GTK_FIXED(fixed), label_C, 50, 50);
  	gtk_widget_grab_focus(label_C);
  	gtk_widget_show (label_C);

  	mp.name_entry= gtk_entry_new_with_max_length (10);
  	gtk_fixed_put(GTK_FIXED(fixed), mp.name_entry, 180, 50);

  	buttonClear = gtk_button_new_with_label("Clear Name");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonClear, 150, 100);
  	gtk_widget_set_size_request(buttonClear, 100, 35);
  	g_signal_connect(G_OBJECT(buttonClear), "clicked", G_CALLBACK(button_pressed1), G_OBJECT(mp.name_entry));

        gtk_widget_show_all(fixed);

        separator = gtk_hseparator_new ();
    	gtk_box_pack_start (GTK_BOX (box_A), separator, FALSE, TRUE, 0);
    	gtk_widget_show (separator);

    	label_A = gtk_label_new ("Player Name :");
    	gtk_box_pack_start (GTK_BOX (box_A), label_A, FALSE, FALSE, 0);
    	gtk_widget_grab_focus(label_A);
    	gtk_widget_show (label_A);
	
    	box_B = gtk_vbox_new (FALSE, 5);
    	gtk_container_set_border_width (GTK_CONTAINER (box_B), 5);
    	gtk_box_pack_start (GTK_BOX (box_A), box_B, FALSE, TRUE, 0);
    	gtk_widget_show (box_B);

        tictac = tictactoe_new ();

    	gtk_container_set_border_width (GTK_CONTAINER ( tictac), 10);
    	gtk_box_pack_start (GTK_BOX (box_B),  tictac, FALSE, TRUE, 0);
    	gtk_widget_show (tictac);
  
        separator = gtk_hseparator_new ();
    	gtk_box_pack_start (GTK_BOX (box_A), separator, FALSE, TRUE, 0);
    	gtk_widget_show (separator);

    	mp.status_label = gtk_label_new (NULL);
    	gtk_box_pack_start (GTK_BOX (box_B), mp.status_label, FALSE, FALSE, 0);
    	GTK_WIDGET_SET_FLAGS (mp.status_label, GTK_CAN_DEFAULT);
    	gtk_widget_grab_focus(mp.status_label);
    	gtk_widget_show (mp.status_label);

	separator = gtk_hseparator_new ();
        gtk_box_pack_start (GTK_BOX (box_B), separator, FALSE, TRUE, 0);
        gtk_widget_show (separator);

        fixed_A = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_B),  fixed_A, FALSE, FALSE, 0);

	buttonSubmit = gtk_button_new_with_label("Submit Result");
  	gtk_fixed_put(GTK_FIXED(fixed_A), buttonSubmit, 20, 50);
  	gtk_widget_set_size_request(buttonSubmit, 60, 35);

        buttonHistory = gtk_button_new_with_label("View All Players History");
        gtk_fixed_put(GTK_FIXED( fixed_A), buttonHistory, 130, 50);
 	gtk_widget_set_size_request(buttonHistory, 180, 35);

        buttonExit = gtk_button_new_with_label("Quit");
  	gtk_fixed_put(GTK_FIXED(fixed_A), buttonExit, 330, 50);
  	gtk_widget_set_size_request(buttonExit, 60, 35);
  	g_signal_connect_swapped(G_OBJECT(buttonExit), "clicked", G_CALLBACK(close_application),GTK_OBJECT(window));
        
 	gtk_widget_show_all (fixed_A);
        
	view = gtk_text_view_new();
  	gtk_box_pack_start(GTK_BOX(box_B), view, FALSE, FALSE, 0);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (view), FALSE);
        gtk_widget_set_size_request(  view, 100, 100);
    	GTK_WIDGET_SET_FLAGS ( view, GTK_CAN_DEFAULT);
    	gtk_widget_grab_focus( view);
    	gtk_widget_show ( view);

	//display player name
	g_signal_connect(G_OBJECT(mp.name_entry), "key-release-event", G_CALLBACK(label1), label_A);

	/* And attach to its "tictactoe" signal */
  	g_signal_connect (G_OBJECT (tictac), "tictactoe",G_CALLBACK (win), mp.status_label);
	
	//insert into db
	g_signal_connect(G_OBJECT(buttonSubmit), "clicked", G_CALLBACK(add_records), &mp);

	//display player history
	g_signal_connect(G_OBJECT(buttonHistory), "clicked", G_CALLBACK(fetch_records),NULL);
	g_signal_connect(G_OBJECT(buttonHistory), "clicked", G_CALLBACK(count_records),NULL);

  	gtk_widget_show (window);
	
  	gtk_main ();

	send (socket1,"Player finish the game!!", BUFSIZE,0); 
     }

	close (socket1); 
  
  	return 0;
}
