//With Doxygen..

#include <unistd.h>		//for close(), write(),
#include <stdio.h>		//for fprintf(), perror(), snprintf(),
#include <stdlib.h>		//for exit(),
#include <string.h>		//for strlen(),
#include <strings.h>		//for bzero(),
#include <sys/socket.h>		//for socket(), bind(), listen(), accept(),
#include <sys/types.h>		//for socket(), bind(), accpet(),
#include <netinet/in.h>		//for struct sockaddr_in,
#include <time.h>		//for time(), time_t,
#include <signal.h>		//for sigaction(),
#include <poll.h>
#include <pthread.h>
#include <mysql/mysql.h>

#define BUFFER_SIZE 4096

#define SERVER_PORT 8000
#define NUM_STUDENTS 1000


#define LEN 1000
int NUM_QS;
int TOTAL_QS;
int LISTEN_PORT;
MYSQL *connection1;
MYSQL *connection2;
MYSQL_RES *result1;
MYSQL_RES *result2;
MYSQL_ROW sqlrow;

int listen_file_descriptor;//used to store file descriptor of port we are listing to
int connection_file_descriptor[NUM_STUDENTS];

/**
  * Display a row from the table and stores it in string.
  *
  * @returns nothing.
  *
  * @param ques Takes a question.
  */
void display_row (char ques[])
{
    unsigned int field_count;
    field_count = 1;
    while (field_count < mysql_field_count (connection1)-1)
    {
	if(field_count==mysql_field_count(connection1)-2)
	{	
		strcat(ques,sqlrow[field_count]);
//		printf("%s",sqlrow[field_count]);
	}
	else
	{	
		strcat(ques,sqlrow[field_count]);
		strcat(ques,"|");
//		printf ("%s|", sqlrow[field_count]);
	}
	field_count++;
    }
    strcat(ques,"#");
    strcat(ques,sqlrow[field_count]);
    printf ("\n");
}

/**
  * Searches for the specified question in the database and stores in ques.
  *
  * returns nothing.
  * @param quesno question number to send.
  * @param ques to store question from database.
  * @param level level of question.
  */
void search(int quesno,char ques[],int level)
{
	char query[LEN];
	int return_value;
	strcpy(ques,"");
	//printf("ENTER THE STUDENT ID\n");
	//scanf("%ld",&stdid);
	sprintf(query,"select * from exam%d where quesno=%d",level,quesno);
	//printf("%s\n",query);
        return_value =  mysql_query (connection1, query);
	if (return_value)
	{
	    printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    result1 = mysql_use_result (connection1);
	    if (result1)
	    {
		if ((sqlrow = mysql_fetch_row (result1)))
		    display_row (ques);
		   
		
		if (mysql_errno (connection1))
		{
		    printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
		}
	    }
	    mysql_free_result(result1);
	}
	//printf("In search %s\n",ques);
	//return ques;
}

/**
  * Returns the marks corresponding to particular level.
  *
  * @returns Marks for the specified level.
  *
  * @param level Level of the question.
  */
int find(int level)
{
	if(level==1)
		return 4;
	else if(level==2)
		return 6;
	else if(level==3)
		return 8;
	else if(level==4)
		return 10;
}

/** Used to search whether the question generated by random function , rand() is already generated or not
  *
  * @returns the question number generated by random function.
  *
  * @param levels Array of levels.
  * @param qno Array of question numbers already sent.
  * @param numqs Number of questions answered by the client till now.
  * @curlevel Current level of the client.
  */
int found(int levels[],int qno[],int numqs,int curlevel)
{
	int ret,i;
	int flag=0;
	srand(time(NULL));
	while(1)
	{
		flag=0;		
		ret=rand()%TOTAL_QS+1;
		for(i=0;i<numqs;i++)
		{
			if((levels[i]==curlevel)&&qno[i]==ret)
			{
				flag=1;
				break;
			}	
		}
		if(flag==0)
		{
			break;
		}
	}
	return ret;
}

/**
  * Thread function that is specific to each client. Used to send question to client, reads answer and sends the result back to client. 
  * It calls functions found(),search().
  *
  * @params arg Argument to the thread function
  */
void *sendques(void *arg)
{
    struct pollfd pollfd1[1];
    char input_data[LEN];
    int characters_read;
    int characters_written;
    int client;
    int i;
    int totalmarks;
    int levels[1000];
    int questions[1000];
    char *split;
    int quesno;
    client=(int)arg;
    int ans,marks=0;
    int level=4;
    totalmarks=NUM_QS*10;
    printf("client no: %d\n",client);

 	//WRITE THE QUESTION TO THE CLIENT
	for(i=0;i<NUM_QS;i++)
	{
		strcpy(input_data,"");    

		//find the non repeated question number
		quesno=found(levels,questions,i,level);
		levels[i]=level;
		questions[i]=quesno;
		//search for the question number
	        search(quesno,input_data,level);
		split=strtok(input_data,"#");
		printf("Question is %s\n",split);
    		//write(connection_file_descriptor[client],input_data,strlen(input_data));
		write(connection_file_descriptor[client],split,strlen(split));				//WRITE
		split=strtok(NULL,"#");
		ans=atoi(split);
		printf("ANSWER is %d\n",ans);
       		characters_read=read(connection_file_descriptor[client],input_data,BUFFER_SIZE-1);      //READ
    		input_data[1]='\0';
		if(strcmp(split,input_data)==0)
		{
			marks=marks+find(level);
			if(level!=4)
				level++;
			printf("ANSWER is correct\n");
		}
		else
		{	
			if(level!=1)
				level--;
			printf("ANSWER is wrong\n");
		}
	//printf("%s\n%d\n",input_data,level);
			
	}
	sprintf(input_data,"end %d %d",marks,totalmarks);
        write(connection_file_descriptor[client],input_data,strlen(input_data));
    pthread_exit(NULL);
    return NULL;
}

/**
  * To shut down a signal properly.
  *
  * @param signal Signal identifier.
  */
void close_properly (int signal)
{
    int return_value;
    int i;
    printf ("Shutting down...\n");
    return_value = close (listen_file_descriptor);
    if (return_value < 0)
    {
	perror ("Cannot close listening socket 1.");
	exit (EXIT_FAILURE);
    }
    printf ("Shutdown complete.\n");
    exit (0);
}


/**
  * The program will listen on some port defined in LISTEN_PORT (default 8000)  at top and call read with large
  * value (default sizeof(BUFFER)). The program takes database details and no. of questions as input.
  * It creates one thread for each client connection.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main (int argc, char *argv[])
{
    struct sockaddr_in server_address;
    int return_value;
    struct sigaction act1;
    pthread_t child[NUM_STUDENTS];
    void *child_return_value;
    int i;
    int result;
    char url[LEN],username[LEN],password[LEN],databasename[LEN];
    connection1 = mysql_init(NULL);
    strcpy(url,"localhost");
  
    printf("Enter the database username:\n");
    scanf("%s",username);
	//strcpy(username,"sandeep");
    printf("Enter the database password:\n");
    scanf("%s",password);
	//strcpy(password,"sandeep");
    printf("Enter the database name:\n");
    scanf("%s",databasename);
	//strcpy(databasename,"examdb");
    printf("Enter the number of questions in each level of questions:\n");
    scanf("%d",&TOTAL_QS);
    printf("Enter the number of questions in the exam:\n");
    scanf("%d",&NUM_QS);
    LISTEN_PORT=SERVER_PORT;
    /*strcpy(url,argv[1]);
    strcpy(username,argv[2]);
    strcpy(password,argv[3]);
    strcpy(databasename,argv[4]);*/
    if (mysql_real_connect (connection1, url, username, password,databasename, 0, NULL, 0))
    {
	printf ("Database Connection successful\n");
    }
    else
    {
	fprintf (stderr, "Database Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Database Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
    }

    //close connections when Ctrl+C is pressed
    act1.sa_handler = close_properly;
    sigemptyset (&act1.sa_mask);
    act1.sa_flags = 0;
    sigaction (SIGINT, &act1, 0);


    //listening on LISTEN_PORT1

    	 listen_file_descriptor = socket (AF_INET, SOCK_STREAM, 0);
   	 if (listen_file_descriptor < 0)
    	 {
		fprintf (stderr, "%s: cannot open socket.\n", argv[0]);
		exit (EXIT_FAILURE);
    	 } 	
         bzero (&server_address, sizeof (server_address));
         server_address.sin_family = AF_INET;
         server_address.sin_addr.s_addr = htonl (INADDR_ANY);
         server_address.sin_port = htons (LISTEN_PORT);
         return_value =bind (listen_file_descriptor, (struct sockaddr *) &server_address,sizeof (server_address));
         if (return_value < 0)
     	 {
	 	perror ("Cannot bind");
		exit (EXIT_FAILURE);
    	 }
    	 return_value = listen (listen_file_descriptor, 5);
   	 if (return_value < 0)
    	 {
		perror ("Cannot listen");
		exit (EXIT_FAILURE);
    	 } 

    while (1)
    {
	//Get connection
	for(i=0;i<NUM_STUDENTS;i++)
	{
		connection_file_descriptor[i] = accept (listen_file_descriptor, (struct sockaddr *) NULL, NULL);
		if (connection_file_descriptor[i] < 0)
		{
	    		perror ("accept() failed.");
	    		exit (EXIT_FAILURE);
		}
		else
		{
			return_value = 	pthread_create(&child[i], NULL, sendques, (void*)i);
			if(return_value !=0)
			{
			    perror("Thread 1  creation failed");
			    exit(EXIT_FAILURE);
			}
       	        	printf ("Got client for connection %d",i);
		}
         }	



	//close connections, should only be done once, hence preferably in parent
	for(i=0;i<NUM_STUDENTS;i++)
	{
		return_value = close (connection_file_descriptor[i]);
		if (return_value < 0)
		{
	    		perror ("close failed");
	    		exit (EXIT_FAILURE);
		}
	}
    }
    return 0;
}
