  /**
 * Server.c
 * @author:Prashant sharma & Narendra Singh
 * @version:1.0
 */
  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include<gtk-2.0/gtk/gtk.h>
#include <mysql/mysql.h>
#include<regex.h>
#include<pthread.h>
#include<arpa/inet.h>
#include<sys/socket.h>
#include<sys/types.h>
#include<netinet/in.h>
#include<sys/stat.h>
#include<unistd.h>
#include<fcntl.h>
#include<time.h>


#define BUFFER 1024
#define PORT_NUMBER 9999
#define MAX_MARKS 800
#define MIN_MARKS 200
#define STARTING_MARKS 400
#define TOTAL_QUESTION 10
#define TOTAL_TIME 1




/** mysql connection parameter global */
MYSQL *connection1, *connection2;
/** mysql result parameter global */
MYSQL_RES *result;
/** mysql row parameter global */
MYSQL_ROW sqlrow;
/** Global Variable storing the sql statement to be executed which is set by the thread in execution.*/
char sql_statement[BUFFER];

/** to store a string ACK to acknowledge the receipt of input from socket */
char ack[10];

/** data file descripter for image file */
int data_file_descriptor;

/** file status */
struct stat file_status;

/** student_id **/
char student_id[BUFFER];

//SERVER socket functions

/**
 * bind implementation with error handling.
 *
 */
void Bind(int sockfd, const struct sockaddr *my_addr, socklen_t addrlen) {
    int return_value;
    return_value = bind(sockfd, my_addr, addrlen);
    if (return_value < 0) {
        perror("Cannot bind");
        exit(1);
    }
}

/**
 * Listen implementation with error handling.
 *
 */

void Listen(int sockfd, int backlog) {
    int return_value;
    return_value = listen(sockfd, backlog);
    if (return_value < 0) {
        perror("Cannot listen");
        exit(1);
    }
}

/**
 * Socket function reimplementation with error handling .
 *
 * @param   domain Domain value passed to the socket
 * @param   type Type of socket.TCP/UDP
 * @param   protocol    protocol of the socket being created.
 * */

int Socket(int domain, int type, int protocol) {
    int return_value;
    return_value = socket(domain, type, protocol);
    if (return_value < 0) {
        fprintf(stderr, "Cannot open socket.\n");
        perror("REASON:");
        exit(1);
    }
    return return_value;
}

/**
 * Read function reimplementation with error handling .
 *
 * @param   fd  filedescriptor to read
 * @param   buf Buffer it is read into
 * @param   count   no of bytes to read.
 * */


ssize_t Read(int fd, void *buf, size_t count) {
    ssize_t characters_read;
    characters_read = read(fd, buf, count);
    return characters_read;
}

/**
 * write function reimplementation with error handling .
 *
 * @param   fd  filedescriptor to read
 * @param   buf Buffer it is read into
 * @param   count   no of bytes to read.
 * */


ssize_t Write(int fd, const void *buf, size_t count) {
    ssize_t return_value;
    return_value = write(fd, buf, count);
    return return_value;
}

/**
 * Close function reimplementation with error handling. 
 *
 * @param   fd  filedescriptor to close
 * */

void Close(int fd) {
    int return_value;
    return_value = close(fd);
    if (return_value < 0) {
        fprintf(stderr, "Cannot close\n");
        perror("REASON");

    }
}
/**
 * accept function reimplementaion with error handling.
 * @see accept()
 */
int Accept(int sockfd, struct sockaddr *addr, socklen_t *addrlen) {
    int file_descriptor;
    file_descriptor = accept(sockfd, addr, addrlen);
    if (file_descriptor < 0) {
        perror("accept() failed.");
        Close(sockfd);

    }
    return file_descriptor;
}
/**
 * to open a file 
 * @param pathname path of the file 
 * @param flags    read,write etc
 */
int Open(const char *pathname, int flags)
{
    int file_descriptor;
    file_descriptor=open(pathname,flags);
    if(file_descriptor < 0)
    {
        fprintf(stderr, "Cannot open file\n");
	perror("REASON");
	
    }
    return file_descriptor;
}
   
/**
 * to check the status of the file
 * @param filedes file_descriptor
 * @param buf to store the status of the file
 */
void Fstat(int filedes, struct stat *buf)
{
    int return_value;
    return_value = fstat(filedes,buf);
    if(return_value == -1)
    {
	fprintf(stderr, "Cannot read file status\n");
	perror("REASON");
    }
}
/**
 * Used to connect to the mysql database and set the connection1 global variable.
 * @see connection1
 * @return 1 on success else -1.
 */
int connect_database() {
    /* connect to mysql database */
    connection1 = mysql_init(NULL);
    if (!connection1) {
        fprintf(stderr, "MySQL initialization failed\n");
        return -1;
    }
    if (mysql_real_connect(connection1, "localhost", "naru", "naru", "onlineexam", 0, NULL, 0)) {
        return 1;
    } else {
        fprintf(stderr, "Connection failed\n");
        if (mysql_errno(connection1)) {
            fprintf(stderr, "Connection error %d: %s\n",
                    mysql_errno(connection1),
                    mysql_error(connection1));
        }
        mysql_close(connection1);
        return -1;
    }
}

/**
 * Used to check that a question in the pool 
 * already asked question
 * @param   pool  pointer to the pool.
 * @param   qno   question number to be searched.
 * @return  Return 0 if question is already in the pool 1 otherwise.
 */
int search(int *pool,int qno,int len)
{
    int i;
    for(i=0;i<len;i++)
    {
	if(*(pool+i) == qno)
	{
	    return 0;
	}
    }
    
    return 1;
}

/**
 * Used to verify the user name and passwrod
 * @param   username    Username of the user.
 * @param   password    password of the user.
 * @return  Return 1 on success -1 otherwise.
 */
int verify_user(char *username, char *password) {
    int ret;
    int flag;

    flag = 0;

    sprintf(sql_statement, "select * from login_username where uname = '%s'", username);
    ret = mysql_query(connection1, sql_statement);

    if (ret) {
        printf("select failed as : %s\n", mysql_error(connection1));
        flag = 1;
    } else {
        result = mysql_use_result(connection1);
        if (result) {

            if ((sqlrow = mysql_fetch_row(result)) && !strcmp(sqlrow[1], password)) {
                strcpy(student_id,sqlrow[2]);
            } else {
                flag = 2;
            }
            if (mysql_errno(connection1)) {
                printf("Error occurred while retrieving data : %s\n", mysql_error(connection1));
                flag = 1;
            }
        }
        mysql_free_result(result);
    }


    return flag;
}
/**
 * This is the thread that is created each time a client connects to take the test.
 * It is responsible for all the test question selection and adaptive test algorithm for selecting criteria.
 *
 * @param   sockfd  connection descriptor of the client.
 * 
 * */
void handle_client_thread(void *sockfd) {

    int connection_file_descriptor = *((int *) sockfd);
    int characters_read;
    int ret;
    int flag;


    int count_tuples;
    int random_qno;
    char temp_table[BUFFER];

    char question_imageurl[BUFFER];
    char question_statement[BUFFER];
    char question_optiona[BUFFER];
    char question_optionb[BUFFER];
    char question_optionc[BUFFER];
    char question_optiond[BUFFER];

    /* other global parameter */
    char username[BUFFER];
    char password[BUFFER];
    char answer[BUFFER];
    char question_answer[BUFFER];
    char input_data[BUFFER];
    char login_status[10];
    int current_question;
    int marks;

    
    int *poola;
    int *poolb;
    int *poolc;
    int *poold;
    
    int ai,af;
    int bi,bf;
    int ci,cf;
    int di,df;
    
    flag = 0;
    marks = STARTING_MARKS;
    current_question = 1;
    ai=0;
    bi=0;
    ci=0;
    di=0;
    
    //allocation of the memory to already asked questions from various pools     
    poola=(int*)malloc(sizeof(int)*TOTAL_QUESTION);
    poolb=(int*)malloc(sizeof(int)*TOTAL_QUESTION);
    poolc=(int*)malloc(sizeof(int)*TOTAL_QUESTION);
    poold=(int*)malloc(sizeof(int)*TOTAL_QUESTION);
    
  

    if (connect_database() <= 0) {
        flag = 1;
    }


    do {

        //username read
        characters_read = Read(connection_file_descriptor, username, BUFFER - 1);

        username[characters_read] = '\0';
        //write back acknowledgement to client
        Write(connection_file_descriptor, ack, strlen(ack));


        //password read
        characters_read = Read(connection_file_descriptor, password, BUFFER - 1);
        password[characters_read] = '\0';
        //write back acknowledgement to client
        Write(connection_file_descriptor, ack, strlen(ack));

        ret = verify_user(username, password);
        if (ret == 1 || flag == 1) {
            strcpy(login_status, "DBF");
        } else if (ret == 2) {
            strcpy(login_status, "UPNM");
        } else {
            strcpy(login_status, "OK");
        }
        //Read ack ignore
        characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);
        input_data[characters_read] = '\0';

        //write login status
        Write(connection_file_descriptor, login_status, strlen(login_status));
        //Read ack ignore
        characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);
        input_data[characters_read] = '\0';
    } while (strcmp(login_status, "OK"));


    //write total_question
    sprintf(input_data, "%d", TOTAL_QUESTION);
    Write(connection_file_descriptor, input_data, strlen(input_data));
    //Read ack ignore
    characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';

    //write total time
    sprintf(input_data, "%d", TOTAL_TIME);
    Write(connection_file_descriptor, input_data, strlen(input_data));
    //Read ack ignore
    characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';

    for (current_question = 1; current_question <= TOTAL_QUESTION + 1; current_question++) {
        //fill Question from mysql
        
	af=0;
	bf=0;
	cf=0;
	df=0;
        if (current_question > 1 && current_question <= TOTAL_QUESTION + 1) {
            if (!strcmp(answer, question_answer)) {
                if (marks >= 900) {
                    ;
                } else {
                    marks = marks + 50;
                }
            } else {
                if (marks <= 100) {
                    ;
                } else {
                    marks = marks - 50;
                }

            }
            if (current_question == TOTAL_QUESTION + 1) {
                if (marks < 200) {
                    marks = 200;
                }
                if (marks > 800) {
                    marks = 800;
                }

            }

        }
	
	//printf("%d %s %s\n",marks,answer,question_answer);
	
        if (current_question <= TOTAL_QUESTION) {
            strcpy(question_imageurl, "NO IMAGE");

            if (marks < 500) {
                strcpy(temp_table, "question_poola");
		af=1;
            } else if (marks < 600) {
                strcpy(temp_table, "question_poolb");
		bf=1;
            } else if (marks < 700) {
                strcpy(temp_table, "question_poolc");
		cf=1;
            } else {
                strcpy(temp_table, "question_poold");
		df=1;
            }
	    

            sprintf(sql_statement, "select q_id from %s", temp_table);
            ret = mysql_query(connection1, sql_statement);
            result = mysql_store_result(connection1);
            count_tuples = mysql_num_rows(result);
            mysql_free_result(result);


            random_qno = rand() % count_tuples;
            while (random_qno <= 0) {
                random_qno = rand() % count_tuples;
            }
	    
	    while(1) {
		if(af==1) {
		    if(search(poola,random_qno,ai)==0) {
			random_qno=rand()%count_tuples;
			 while (random_qno <= 0) {
			    random_qno = rand() % count_tuples;
			 }
			continue;
		    } else {
			poola[ai++]=random_qno;
			break;
		    }
		} else if(bf==1) {
		    if(search(poolb,random_qno,bi)==0) {
			random_qno=rand()%count_tuples;
			 while (random_qno <= 0) {
			    random_qno = rand() % count_tuples;
			 }
			continue;
		    } else {
			poolb[bi++]=random_qno;
			break;
		    }
		} else if(cf==1)
		{
		    if(search(poolc,random_qno,ci)==0)
		    {
			random_qno=rand()%count_tuples;
			 while (random_qno <= 0) {
			    random_qno = rand() % count_tuples;
			 }
			continue;
		    }
		    else
		    {
			poolc[ci++]=random_qno;
			break;
		    }
		}
		else
		{
		    if(search(poold,random_qno,di)==0)
		    {
			random_qno=rand()%count_tuples;
			 while (random_qno <= 0) {
			    random_qno = rand() % count_tuples;
			 }
			continue;
		    }
		    else
		    {
			poold[di++]=random_qno;
			break;
		    }
		}
	    }
	    
	    
            sprintf(sql_statement, "select * from %s where q_id= %d", temp_table, random_qno);
            ret = mysql_query(connection1, sql_statement);
            

            if (ret) {
                printf("select failed as : %s\n", mysql_error(connection1));
            } else {
                result = mysql_use_result(connection1);
                if (result) {
                   
                    sqlrow = mysql_fetch_row(result);
		    if (sqlrow[1] != NULL) {
                        strcpy(question_imageurl, sqlrow[1]);
                    }
                    strcpy(question_statement, sqlrow[2]);
                    strcpy(question_optiona, sqlrow[3]);
                    strcpy(question_optionb, sqlrow[4]);
                    strcpy(question_optionc, sqlrow[5]);
                    strcpy(question_optiond, sqlrow[6]);
                    strcpy(question_answer, sqlrow[7]);
                    if (mysql_errno(connection1)) {
                        printf("Error occurred while retrieving data : %s\n", mysql_error(connection1));
                    }
                }
		
                mysql_free_result(result);
            } 
	  
            //Send ImageUrl
            Write(connection_file_descriptor, question_imageurl, strlen(question_imageurl)); 
            //recieve ack it may be timeout check it
            characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);  
	    //broken pipe check
            if (characters_read <= 0) {
	        Close(connection_file_descriptor);
                pthread_exit(0);
		return;
            }
	   
            input_data[characters_read] = '\0';

	    if(!strcmp(input_data,"Timeout"))
	    {
		break;
	    }
	    //if there is an image url
	    if(strcmp(question_imageurl,"NO IMAGE"))
	    {
	        
		data_file_descriptor = Open(question_imageurl, O_RDONLY);
		if(data_file_descriptor < 0)
		{
		    printf("Image file can not be opened\n");		      
		}
		else
		{
		  
		    Fstat(data_file_descriptor, &file_status);
		   
		    characters_read = Read(data_file_descriptor, input_data, BUFFER -1);
		    while(characters_read > 0)
		    {
		        
			 Write(connection_file_descriptor, input_data, characters_read);
			 characters_read = Read(data_file_descriptor, input_data, BUFFER -1);
		    }
		   
		    //recieve ack ignore
                    characters_read=Read(connection_file_descriptor, input_data, BUFFER - 1);
                    input_data[characters_read] = '\0';
		    Close(data_file_descriptor);
		}
		
	    }
           
           
            //Send Question Statement
            Write(connection_file_descriptor, question_statement, strlen(question_statement));
            //recieve ack ignore
            characters_read=Read(connection_file_descriptor, input_data, BUFFER - 1);
            input_data[characters_read] = '\0';

            //Send question_optiona
            Write(connection_file_descriptor, question_optiona, strlen(question_optiona));
            //recieve ack ignore
            characters_read=Read(connection_file_descriptor, input_data, BUFFER - 1);
            input_data[characters_read] = '\0';

            //Send question_optionb
            Write(connection_file_descriptor, question_optionb, strlen(question_optionb));
            //recieve ack ignore
            characters_read=Read(connection_file_descriptor, input_data, BUFFER - 1);
            input_data[characters_read] = '\0';

            //Send question_optionc
            Write(connection_file_descriptor, question_optionc, strlen(question_optionc));
            //recieve ack ignore
            characters_read=Read(connection_file_descriptor, input_data, BUFFER - 1);
            input_data[characters_read] = '\0';

            //Send question_optiond
            Write(connection_file_descriptor, question_optiond, strlen(question_optiond));
            //recieve ack ignore
            characters_read=Read(connection_file_descriptor, input_data, BUFFER - 1);
            input_data[characters_read] = '\0';

            //write back acknowledgement to client
            Write(connection_file_descriptor, ack, strlen(ack));
            //recieve answer
            characters_read=Read(connection_file_descriptor, answer, BUFFER - 1);
	    //broken pipe check
            if (characters_read <= 0) {
	        Close(connection_file_descriptor);
                pthread_exit(0);
		return;
            }
	    answer[characters_read] = '\0';
	  


            //no ack is sent for answer

        }
    }

    //write total marks

    sprintf(input_data, "%d", marks);
    Write(connection_file_descriptor, input_data, strlen(input_data));
    

    //Read ack ignore
    characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';
    
    
    sprintf(sql_statement, "update student_record set student_marks='%d' where student_id='%s'", marks, student_id);
    ret = mysql_query(connection1, sql_statement);
    

    if(!strcmp(input_data,"Timeout"))
    {
	//write total marks

	sprintf(input_data, "%d", marks);
	Write(connection_file_descriptor, input_data, strlen(input_data));
	
	sprintf(sql_statement, "update student_record set student_marks='%d' where student_id='%s'", marks, student_id);
        ret = mysql_query(connection1, sql_statement);

	//Read ack ignore
	characters_read = Read(connection_file_descriptor, input_data, BUFFER - 1);
	input_data[characters_read] = '\0';
    }

  


    Close(connection_file_descriptor);
    pthread_exit(0);
    return;

}
/**
 * Main function declares all variables and accepts connections from the clients and assign them a thread
 * with a connection file descriptor describing their connection.
 * @return returns Zero on success.
 */

int main() {

    int connection_file_descriptor, listen_file_descriptor;
    int num_clients, i;
    struct sockaddr_in server_address;
    pthread_t thread[1000];

    listen_file_descriptor = Socket(AF_INET, SOCK_STREAM, 0);
    bzero(&server_address, sizeof (server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = htonl(INADDR_ANY);
    server_address.sin_port = htons(PORT_NUMBER);
    Bind(listen_file_descriptor, (struct sockaddr *) & server_address, sizeof (server_address));
    Listen(listen_file_descriptor, 1000);

    strcpy(ack, "ACK");
    num_clients = 0;
    while (1) {

        if (num_clients > 999) {
            printf("System has reached Maximum Limit:1000 clients");
            break;
        }
        connection_file_descriptor = Accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);

        //read username after connect success from client
        pthread_create(&thread[num_clients], NULL, (void *) & handle_client_thread, (void *) & connection_file_descriptor);
        num_clients++;
    }

    for (i = 0; i <= num_clients; i++) {
        pthread_join(thread[i], NULL);
    }

    Close(listen_file_descriptor);
    return 0;
}
