#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <sys/select.h>
#include <sys/time.h>

#define BUFFER_SIZE 4096
#define LISTEN_PORT1 8887
#define LISTEN_PORT2 9997

//used to store file descriptor of port we are listing to
int listen_file_descriptor1;
int listen_file_descriptor2;

char message[10*BUFFER_SIZE];

void close_properly(int signal)
{
	int return_value;    
    	printf("Shutting down...\n");
    	return_value =close(listen_file_descriptor1);
    
	if(return_value <0)
	{
		perror("Cannot close listening socket 1.");
		exit(EXIT_FAILURE);
    	}
	return_value =close(listen_file_descriptor2);

	if(return_value <0)
    	{
		perror("Cannot close listening socket 2.");
		exit(EXIT_FAILURE);
    	}
	printf("Shutdown complete.\n");
	exit(0);
}
    
int main(int argc, char *argv[])
{
	int connection_file_descriptor1; 
    	int connection_file_descriptor2; 
    	char input_data[BUFFER_SIZE];
    	struct sockaddr_in server_address;
    	int return_value;
    	struct sigaction act1;
    	int characters_read;
    	fd_set read_file_descriptor_set;
    	int read_descriptor;
    	int write_descriptor;
    	int f=-1;

    	//close connections when Ctrl+C is pressed
    	act1.sa_handler = close_properly;
    	sigemptyset(&act1.sa_mask);
    	act1.sa_flags=0;
    	sigaction(SIGINT, &act1, 0);
    
    	//listening on LISTEN_PORT1
    	listen_file_descriptor1 = socket(AF_INET, SOCK_STREAM, 0);
    
	if(listen_file_descriptor1 < 0)
    	{
		fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
		exit(EXIT_FAILURE);
    	}

    	bzero(&server_address, sizeof(server_address));
    	server_address.sin_family = AF_INET;
    	server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    	server_address.sin_port = htons(LISTEN_PORT1);
    	return_value = bind(listen_file_descriptor1, (struct sockaddr *) &server_address, sizeof(server_address));
    
	if(return_value < 0)
	{
		perror("Cannot bind");
		exit(EXIT_FAILURE);
    	}
    	return_value = listen(listen_file_descriptor1, 5);
    
	if(return_value < 0)
    	{
		perror("Cannot listen");
		exit(EXIT_FAILURE);
    	}

    	//listening on LISTEN_PORT2
    	listen_file_descriptor2 = socket(AF_INET, SOCK_STREAM, 0);
    
	if(listen_file_descriptor2 < 0)
    	{
		fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
		exit(EXIT_FAILURE);
    	}

    	bzero(&server_address, sizeof(server_address));
    	server_address.sin_family = AF_INET;
    	server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    	server_address.sin_port = htons(LISTEN_PORT2);
    	return_value = bind(listen_file_descriptor2, (struct sockaddr *) &server_address, sizeof(server_address));
    
	if(return_value < 0)
    	{
		perror("Cannot bind");
		exit(EXIT_FAILURE);
    	}

    	return_value = listen(listen_file_descriptor2, 5);
    
	if(return_value < 0)
    	{
		perror("Cannot listen");
		exit(EXIT_FAILURE);
    	}
   
    	while(1)
    	{
		connection_file_descriptor1 = accept(listen_file_descriptor1, (struct sockaddr *) NULL, NULL);
		if(connection_file_descriptor1 < 0)
		{
	    		perror("accept() failed.");
	    		exit(EXIT_FAILURE);
		}
		else
		{
	    		printf("Got client for connection1.\n");
	}
	connection_file_descriptor2 = accept(listen_file_descriptor2, (struct sockaddr *) NULL, NULL);
	if(connection_file_descriptor2 < 0)
	{
		perror("accept() failed.");
	    	exit(EXIT_FAILURE);
	}
	else
	{
		printf("Got client for connection2.\n");
	}
	strcpy(message,"");
	while(1)
	{
	    //should be under while loop 
	    //as select would modify this set and clear fds where we cant read without getting blocked
	    FD_ZERO(&read_file_descriptor_set);
	    FD_SET(connection_file_descriptor1, &read_file_descriptor_set);
	    FD_SET(connection_file_descriptor2, &read_file_descriptor_set);

	    //block till can read from one of the two file descriptors
	    return_value =select(connection_file_descriptor2+1, &read_file_descriptor_set, NULL, NULL, NULL);
	    if(return_value<0)
	    {
	     		perror("Select failed");
			exit(EXIT_FAILURE);
	    }
	    //see from which descriptor we can read and set variables
	    //read_descriptor and write_descriptor appropriately
	    char temp[BUFFER_SIZE];
	    if(FD_ISSET(connection_file_descriptor1, &read_file_descriptor_set))
	    {
			read_descriptor=connection_file_descriptor1;
			write_descriptor=connection_file_descriptor2;
			sprintf(temp,"%d->\t",read_descriptor);
			strcat(message,temp);
			printf("%s",temp);	
			f=1;
	    }
	    else
	    {
			read_descriptor=connection_file_descriptor2;
			write_descriptor=connection_file_descriptor1;
			f=2;
			sprintf(temp,"%d->\t",read_descriptor);
			strcat(message,temp);
			printf("%s",temp);	
	    }
	    //read from read_descriptor and write to write_descriptor
	    characters_read=read(read_descriptor, input_data, BUFFER_SIZE-1);
	    if(characters_read > 0)
	    {
			input_data[characters_read]='\0';
			sprintf(temp,"%s\n",input_data);
			strcat(message,temp);
			printf("%s",temp);	
			printf("\nMEssage is %s:\n",message);
			write(write_descriptor,message,strlen(message));
			//write(connection_file_descriptor2,message,strlen(message));
	    }
	    else if(characters_read<0)
	    {
			perror("Read failed");
			exit(EXIT_FAILURE);
	    }
	    else
	    {
			// characters_read=0, and return on blocking IO means connection1 closed.
			printf("Connection seems to be closed\n");
			break;
	    }
	}
	//close connections
	return_value = close(connection_file_descriptor1);
	if(return_value <0)
	{
	    	perror("close failed");
	    	exit(EXIT_FAILURE);
	}
	return_value = close(connection_file_descriptor2);
	if(return_value <0)
	{
	    	perror("close failed");
	    	exit(EXIT_FAILURE);
	}
    }
        
    return 0;
}

