#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdlib.h>

#define BUFFER_SIZE 4096

int main ()
{
    int server_socket_file_descriptor, client_socket_file_descriptor;
    int server_socket_address_length;
    unsigned int client_socket_address_length;
    struct sockaddr_un server_address;
    struct sockaddr_un client_address;
    char buffer1[BUFFER_SIZE];
    int characters_read;

    //delete old socket file if it already exists.
    unlink ("echo_socket");
    server_socket_file_descriptor = socket (AF_UNIX, SOCK_STREAM, 0);

    server_address.sun_family = AF_UNIX;
    strcpy (server_address.sun_path, "echo_socket");
    server_socket_address_length = sizeof (server_address);
    bind (server_socket_file_descriptor, (struct sockaddr *) &server_address,
	  server_socket_address_length);
    listen (server_socket_file_descriptor, 5);

    printf ("Server started\n");
    while (1)
    {
	client_socket_address_length = sizeof (client_address);
	client_socket_file_descriptor = accept (server_socket_file_descriptor,
						(struct sockaddr *)
						&client_address,
						&client_socket_address_length);
	characters_read = read (client_socket_file_descriptor, buffer1, BUFFER_SIZE);
	write (client_socket_file_descriptor, buffer1, characters_read);
	close (client_socket_file_descriptor);
    }

    exit(EXIT_SUCCESS);
    return 0;
}
