<?php
/** This program is used to demonstrate various types of PHP variables
	and how they are assigned and used
	
	@author Saurabh Barjatiya
	@version 1.0
	@file 06-variables/index.php
*/

/** This variable is declared just to demonstrate that global
	variables can be accessed in function by declaring them
	as global
*/
$global1='This is global';


/** This variable is declared to show that we cannot use global
	variables unless they are declared using global keyword.
	Any attempt of using global variables unless declared so
	would simply affect local variable with same name.
*/
$global2='This is global too';

/** This function outputs various values of variables
	to demonstrate usage of variables, arrays, scope
	of variables in PHP.

	@returns Nothing
*/
function main()
{
	global $global1;

	$local1="String variable";
	$local2=5;

	//Trying to access global variable global1
	if(isset($global1))
		echo "A. Value of global global1 - $global1 <br/>\n";


	//Demonstrating that global2 is not accessible
	if(isset($global2))
		echo "B. Value of no so global global2 - $global2 <br/>\n";
	else
		echo "B. global2 is not yet set.<br/>\n";


	//Creating local variable with name global2
	$global2="Local value of global2";


	//Demonstrating that local global2 is now accessible
	if(isset($global2))
		echo "C. Value of no so local global2 - $global2 <br/>\n";
	else
		echo "C. Local global2 is not yet set.<br/>\n";


	//Show value of local variables both numeric and strings
	echo "D. Value of local1 is $local1 <br/>\n";
	echo "D. Value of local2 is $local2 <br/>\n";


	//Generating line breaks for cleaner output
	echo "<br/>\n<br/>\n";


	//Demonstrating that PHP arrays can use both numbers
	//and strings as indexes
	$array1[5]="Value at index 5 of array1";
	$array1["five"]="Value at index 'five' of array1";

	echo 'E. $array1[5] is ' . $array1[5] . "<br/>\n";
	echo 'E. $array1["five"] is ' . $array1["five"] . "<br/>\n";


	//Array indexes can be supplied using variables
	$local1=5;
	$local2="five";
	echo 'F. $array1[5] is ' . $array1[$local1] . "<br/>\n";
	echo 'F. $array1["five"] is ' . $array1[$local2] . "<br/>\n";
 

	//Generating line breaks for cleaner output
	echo "<br/>\n<br/>\n";


	//Showing that arrays can be nested / recursive
	$array2["array1"]=$array1;
	echo "G. Value of \$array2 is <br/>\n";
	//print_r can print recursive arrays without ending in infinite loop
	print_r($array2);
	echo "<br/>\n";
	echo "H. Use view source to see how print_r actually prints output <br/>\n";
	echo 'H. Value of $array2["array1"]["five"] is ' . $array2["array1"]["five"] . "<br/>\n";
	

	//Generating line breaks for cleaner output
	echo "<br/>\n<br/>\n";


	//Values of variables and \r\n etc. get substituted in double quotes ""
	echo "I. Value of \$local1 is $local1 <br/>\n";
	echo 'I. Value of $local1 is ' . $local1 . "<br/>\n";

}

main();

?>
