<?php
/** This program demonstrates how we can display HTML form and accept
	values of same form using same PHP page. Some programmers
	prefer this so that all logic related to one page is present
	in one single PHP file.

	@author Saurabh Barjatiya
	@version 1.0
	@file 12-get_variables/add2.php
*/

//This is to include file common_functions.php which has
//common functions which are required in more than one page.
require("common_functions.php");


/** This function checks if form was submitted or not. If form was
	submitted then it uses check_and_get() function to obtain values
	of num1 and num2 after ensuring that they were indeed supplied.
	Then this function adds those two numbers and displays sum on
	screen. If form was not submitted indicating refresh or opening
	of page for first time, then it displays form.
	
	@returns Nothing.
*/
function main()
{
	//Here we are checking whether form was submitted or not by looking
	//at value of submit1 (name of submit button). If form is submitted
	//using given button it would be set and value would be equal to
	//'Add' (what is displayed on button)
	if(isset($_GET['submit1']))
	{
		$num1=check_and_get('num1');
		$num2=check_and_get('num2');
		echo "Sum of $num1 and $num2 is " . ($num1 + $num2) . "<br/>\n";
	}
	else
		display_add_form("add2.php", "");
}


main();

?>
