<?php
/** This PHP page is not intended to be executed directly from browser.
	This has definitions of functions that can be reused in more than
	one page.

	@author Saurabh Barjatiya
	@file 12-get_variables/common_functions.php
	@version 1.0
*/

/** This function displays form that gives two text-boxes and 
	a submit button. When users clicks submit button values are
	passed to same page using form action attribute with GET method.
	
	@param action Name of page to be used as value for action attribute
				of form being generated.
	@param message Optional message to be displayed at top of page.
	@returns Nothing
*/
function display_add_form($action, $message)
{
	?>
		<html>
			<head>
				<title>Add numbers form</title>
			</head>
			<body>
				<h3>Add two numbers:</h3>
				<?php echo $message; ?>
				<form action="<?php echo $action; ?>" method="GET">
					Number 1 : <input type="text" name="num1" value=""/> <br/>
					Number 2 : <input type="text" name="num2" value=""/> <br/>
					<input type="submit" name="submit1" value="Add"/> <br/>
				</form>
				<?php display_links(); ?>
			</body>
		</html>
	<?php
}


/** This function takes name of variable as parameter. It then
	checks whether the variables value has been supplied using
	GET method or not. 

	@returns Returns value of variable given as argument passed via GET.
			If given variable is not passed then function prints error 
			message and exits script.
*/
function check_and_get($variable1)
{
	if(isset($_GET[$variable1]))
		return $_GET[$variable1];
	else
		die("$variable1 not passed as GET variable. Exiting <br/>\n");
}


/** This function is used to display links for all three types of add
	implementations in form using anchor tags.

	@returns Nothing
*/
function display_links()
{
	echo "<h3>Related pages:</h3>\n";
	echo "<ol>\n";
	echo "<li><a href='index.php'>Add two numbers using two PHP pages. One page displays 
			form and other adds values </a></li>\n";
	echo "<li><a href='add2.php'>Add two numbers using single PHP pages. Same page displays 
			form and also adds values </a></li>\n";	
	echo "<li><a href='add3.php'>Add two numbers using single PHP page. Now form is displayed
			even while displays sum so that next two numbers can be added easily.</a></li>\n";
	echo "</ol>\n";
}


?>
