<?php
/** This page demonstrates use of POST method for passing form values.
	This page will display login form and if username and password 
	'match' it displays login succesful else it displays username
	and password do not match.
	
	@author Saurabh Barjatiya
	@version 1.0
	@file 13-post_variables/index.php
*/

/** Will be used to pass message to show_login_page() to be displayed
	before login form. */
$message='';

/** This function returns value of POST variable whose name is
	given as argument. If variable is not set it returns empty
	string "" as variable value.
	
	@param var1	Name of variable whose value should be searched in
				POST array
	@returns 	Value of variable in POST array. It returns empty
				string if variable is not present in POST array.
*/
function get_post($var1)
{
	if(isset($_POST[$var1]))
		return $_POST[$var1];
	else
		return "";
}


/** This function displays login page which prints value of 
	global variable message, followed by form for entering
	username and password.

	@returns Nothing
*/
function show_login_page()
{
	global $message;
	?>
		<html>
			<head>
				<title>Login page</title>
			</head>
			<body>
				<?php echo $message; ?>
				<form action="index.php" method="POST">
					Username: <input type="text" name="username1" value="" /> <br/>
					Password: <input type="password" name="password1" value="" /> <br/>
					<input type="submit" value="Login" name="submit1" /><br/>
				</form>
			</body>
		</html>
	<?php
}


/** This is where program execution starts. It checks whether form
	was submitted or is being displayed for first time. If form
	is being displayed for first time it simply calls show_login_page(),
	If form was submitted it displays 'Username and password match' if
	username and password match. Otherwise it displays login form again
	with message 'Username and password do not match'.

	@returns Nothing.
*/
function main()
{
	global $message;

	if(get_post('submit1')=="")
	{
		//if page is being displayed for first time
		show_login_page();
	}
	else
	{
		$username1=get_post('username1');
		$password1=get_post('password1');
		if($username1==$password1 && $username1!="")
		{
			echo "Congratulations! Username and Password match.";
		}
		else
		{	//Note that $message must be declared as global in main()
			//for this to work.
			$message="Sorry! Username and password do not match.<br/>\n";
			show_login_page();
		}
	}
}

main();

?>
