<?php
/** This page demonstrates use of SESSION variables to keep track
	of user session. This page will display login form and if 
	username and password 'match' it redirects to welcome page.
	
	@author Saurabh Barjatiya
	@version 1.0
	@file 14-session_variables/index.php
*/

//When using sessions we must start session as early in program
//as possible, preferably first line.
session_start();

/** This is used to store username of user who logged in to keep
	track of logged in user */
session_register('logged_in');


//including file which has common functions like redirect
//and get_session which will be reused in many scripts
require('common_functions.php');


/** Will be used to pass message to show_login_page() to be displayed
	at top of login form. */
$message='';


/** This function returns value of POST variable whose name is
	given as argument. If variable is not set it returns empty
	string "" as variable value.
	
	@param var1	Name of variable whose value should be searched in
				POST array
	@returns 	Value of variable in POST array. It returns empty
				string if variable is not present in POST array.
*/
function get_post($var1)
{
	if(isset($_POST[$var1]))
		return $_POST[$var1];
	else
		return "";
}



/** This function displays login page which prints value of 
	global variable message, followed by form for entering
	username and password.

	@returns Nothing
*/
function show_login_page()
{
	global $message;
	?>
		<html>
			<head>
				<title>Login page</title>
			</head>
			<body>
				<?php echo $message; ?>
				<form action="index.php" method="POST">
					Username: <input type="text" name="username1" value="" /> <br/>
					Password: <input type="password" name="password1" value="" /> <br/>
					<input type="submit" value="Login" name="submit1" /><br/>
				</form>
			</body>
		</html>
	<?php
}


/** This is where program execution starts. It checks if user is already
	logged in or not. If user is already logged in this page redirects
	to welcome.php page. If user is not logged in then it checks whether form
	was submitted or is being displayed for first time. If form
	is being displayed for first time it simply calls show_login_page()
	to display form. If form was submitted it redirects to welcome page
	if username and password match after setting proper session values,
	otherwise it displays login form again with message 
	'Username and password do not match'.

	@returns Nothing.
*/
function main()
{
	global $message;

	//Get value of session variable with name 'logged_in'
	$username1=get_session('logged_in');

	//If user has already logged in this value should not
	//be null. In that case redirect user to welcome page.
	if($username1!="")
		redirect('welcome.php');
	else if(get_post('submit1')=="")
	{	
		//if page is being displayed for first time
		//show login page without doing anything to session variables
		show_login_page();
	}
	else
	{	
		//if page is being submitted, check if username 
		//and password match
		$username1=get_post('username1');
		$password1=get_post('password1');

		if($username1==$password1 && $username1!="")
		{
			//if username and passwod match, then redirect
			//to welcome page after setting proper value of
			//session variable 'logged_in'
			$_SESSION['logged_in']=$username1;
			redirect('welcome.php');
		}
		else
		{	
			//If username and password do not match, show login
			//page again with error message.
			//Note that $message must be declared as global in main()
			//for this to work.
			$message="Sorry! Username and password do not match.<br/>\n";
			show_login_page();
		}
	}
}


main();

?>
