<?php
/** This program is used to demonstrate use of Cookies from PHP
	program. This is used as example for teaching PHP.

	@file 16-cookies/index.php
	@author Saurabh Barjatiya
	@version 1.0
*/

/**Used to define life of cookie in seconds with respect to now. */
define('COOKIE_LIFE', 3600);

/** Used to store value of first submit button 'Add' */
$submit1=get_post('submit1');

/** Used to store value of first submit button 'Subtract' */
$submit2=get_post('submit2');

/** Used to store name of new cookie to be added */
$cookie_name=get_post('cookie_name');

/** Used to store value of new cookie to be added */
$cookie_value=get_post('cookie_value');

/** Used to store array of cookies to be deleted */
$cookie_list=get_post('cookie_list');


/** This function returns value of POST variable whose name is
	given as argument. If variable is not set it returns empty
	string "" as variable value.
	
	@param var1	Name of variable whose value should be searched in
				POST array
	@returns 	Value of variable in POST array. It returns empty
				string if variable is not present in POST array.
*/
function get_post($var1)
{
	if(isset($_POST[$var1]))
		return $_POST[$var1];
	else
		return "";
}


/** This function displays a form with text areas and buttons for
	adding cookies. Below the form existing cookies are listed in
	select list and delete option for deleting existing cookies
	is provided.

	@param message 	Message to be displayed at top of page.
	@returns Nothing
*/
function show_cookies_page($message)
{
	global $submit1;
	global $cookie_name;
	global $cookie_value;
	?>
		<html>
			<head>
				<title>Cookies example</title>
			</head>
			<body>
				<?php echo htmlspecialchars($message); ?>
				<form action="index.php" method="POST">
					Add cookie: <br/>
					Name : <input type="text" name="cookie_name" /> <br/>
					Value : <input type="text" name="cookie_value" /> <br/>
					<input type="submit" value="Add" name="submit1" /> <br/>
					<br/>
					
					Following cookies are already stored: <br/>
					<select name="cookie_list[]" multiple="yes">
						<?php
							foreach($_COOKIE as $key1 => $value1)
							{
								echo "<option value='$key1'>$key1 -> $value1</option>\n";
							}
							if($submit1=='Add' && $cookie_name!="" && $cookie_value!="")
								echo "<option value='$cookie_name'>$cookie_name -> $cookie_value </option>\n";
								
						?>
					</select> <br/>
					<input type="submit" value="Delete" name="submit2" /> <br/>
				</form>
			</body>
		</html>
	<?php
}


/** This function checks if page was submitted using 'Add' or 'Delete' or not.
	If one of those buttons was pressed then corresponding action is performed
	before displaying the page.

	@returns Nothing
*/
function main()
{
	global $submit1;
	global $submit2;
	global $cookie_name;
	global $cookie_value;
	global $cookie_list;
	$message='';

	if($submit1=='Add')
	{
		//if 'Add' button was pressed to submit page.
		if($cookie_name!="" and $cookie_value!="")
			setcookie($cookie_name, $cookie_value, time()+COOKIE_LIFE);
		$message="Cookie $cookie_name added successfully.<br/>";
	}
	else if($submit2=='Delete')
	{
		if($cookie_list!="")
		{
			//if 'Delete button was pressed to submit page
			foreach($cookie_list as $key1 => $value1)
				setcookie($value1, "", time() - COOKIE_LIFE); //Any negative value
															  //woud do
		}
	}

	show_cookies_page($message);
}

main();
?>
