<?php
/** This file is used to provide message book to visitors through
   * which they can leave a message.
   *
   * @file address_book.php
   * @author Saurabh Barjatiya
   * @version 2.0
   */

//This file is used to define common functions which are used in
//implementing address book code
require_once('common_functions.php');


/** This function displays address book page
  */
function address_book_page()
{
	global $message;
	global $name;
	global $mobile_number;
	global $room_number;
	global $roll_number;
	global $iiit_mail_id;
	global $other_mail_id;
	global $pc_name;
	global $date_of_birth;
	global $gaming_nick;
	global $peer_web_nick;
	global $remote_address;
	
	//create a different random image each time page is dispayed
	create_random_image();
	
	?>
		<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
		<html>
		<head>
			<title> Address Book for www.sbarjatiya.in </title>
			<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			<link rel="stylesheet" type="text/css" href="style1.css" />
		</head>
		<body style="background-color:black; color:white">
			<form method="POST" action="address_book.php?<?php echo session_id() . "\">"; ?>
				<span class="large arial blue">
					<?php echo "<br/>$message"; ?>
				</span>
				<div class="arial">
					Currently stored details:<br>
					<table border=1 cellspacing=2 cellpadding=2>
						<thead>
							<tr>
								<th>S. No. </th>
								<th>Name </th>
								<th>Mobile No</th>
								<th>Room No</th>
								<th>Roll number</th>
								<th>IIIT mail id</th>
								<th>Other mail id</th>
								<th>IP address</th>
								<th>Date Of Birth</th>
								<th>Gaming Nick </th>
								<th>Peer Web Nick</th>
							</tr>
						</thead>
						<tbody>
							<?php
								$connection=connect_to_database();
							
								$sql = "SELECT * from directory";
								$result= mysql_query($sql, $connection);
						
								if(!$result)
									die("Cannot select from table directory since, " . mysql_error());

								$total = mysql_num_rows($result);
								for ($counter1 = 0; $counter1 < $total; $counter1++) 
								{
									echo "<tr>\n";
									//Use mysql_fetch_array instead of mysql_array_row for more
									//robust code which does not depends on order of columns.
									$row_array = mysql_fetch_array($result, MYSQL_ASSOC);
									echo "<td>" . ($counter1+1) . ". </td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["name"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["mobile_number"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["room_number"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["roll_number"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["iiit_mail_id"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["other_mail_id"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["pc_name"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["date_of_birth"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["gaming_nick"])) . "</td>\n";
									echo "<td>" . htmlspecialchars( stripslashes( $row_array["peer_web_nick"])) . "</td>\n";
									echo "</tr>\n";
								}

								mysql_free_result($result);
								mysql_close($connection);
							?>
						</tbody>
					</table>
					<br/><br/>
					You can add your own details to the list:<br>
					<table>
						<tr>
							<td>*Name : </td>
							<td> <input type=text name="name" <?php echo "value='$name'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Mobile No : </td>
							<td> <input type=text name="mobile_number" <?php echo "value='$mobile_number'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Room No : </td>
							<td> <input type=text name="room_number" <?php echo "value='$room_number'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>*Roll number : </td>
							<td> <input type=text name="roll_number" <?php echo "value='$roll_number'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>IIIT mail id : </td>
							<td> <input type=text name="iiit_mail_id" <?php echo "value='$iiit_mail_id'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Other mail id : </td>
							<td> <input type=text name="other_mail_id" <?php echo "value='$other_mail_id'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>PC Name : </td>
							<td> <input type=text name="pc_name" <?php echo "value='$pc_name'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Date Of Birth : </td>
							<td> <input type=text name="date_of_birth" <?php echo "value='$date_of_birth'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Gaming Nick : </td>
							<td> <input type=text name="gaming_nick" <?php echo "value='$gaming_nick'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Peer Web Nick : </td>
							<td> <input type=text name="peer_web_nick" <?php echo "value='$peer_web_nick'"; ?> /><br/></td>
						</tr>
						<tr>
							<td>Verification Code : </td>
							<td>
								<input type=text name=random_code value="" />
								<?php 
									echo '<img alt="random image" src="' . IMAGE_FILENAME . '"/>';
								?>
							</td>
					</table>
					<br/>
					<input type=submit value="Submit" name="submit1" />
				</div>
			</form>
			</body>
		</html>
	<?php
	
}


/** This is used to verify data posted by user so that it does not 
  * causes database overflow errors. This function is filled with
  * magic values which ideally should be parameters. To keep
  * number of parameters less the values are left as it is.
  *
  * @returns true if error is found, false otherwise
  */
function verify_post_data()
{
	global $message;
	global $name;
	global $mobile_number;
	global $room_number;
	global $roll_number;
	global $iiit_mail_id;
	global $other_mail_id;
	global $pc_name;
	global $date_of_birth;
	global $gaming_nick;
	global $peer_web_nick;	
	
	$error_found=false;

	if(strlen($name) > 50 || strlen($name) <3)
	{
		$message .= "Name must be between 3 and 50 characters.<br/>";
		$error_found=true;
	}
	
	if(strlen($mobile_number) > 20)
	{
		$message .= "Mobile no must be less than 20 characters.<br/>";
		$error_found=true;
	}

	if(strlen($room_number) > 10)
	{
		$message .= "Room no must be less than 10 characters.<br/>";
		$error_found=true;
	}

	if(strlen($roll_number) != 9)
	{
		$message .= "Roll number must be of 9 characters.<br/>";
		$error_found=true;
	}

	if(strlen($iiit_mail_id) > 50)
	{
		$message .= "IIIT mail id must be less than 50 characters.<br/>";
		$error_found=true;
	}
	
	if(strlen($other_mail_id) > 50)
	{
		$message .= "Other mail id must be less than 50 characters.<br/>";
		$error_found=true;
	}

	if(strlen($pc_name) > 20)
	{
		$message .= "PC name must be less than 20 characters.<br/>";
		$error_found=true;
	}

	if(strlen($date_of_birth) > 20)
	{
		$message .= "Date Of Birth must be less than 20 characters.<br/>";
		$error_found=true;
	}
	
	if(strlen($gaming_nick) > 20)
	{
		$message .= "Gaming nick must be less than 20 characters.<br/>";
		$error_found=true;
	}
	
	if(strlen($peer_web_nick) > 20)
	{
		$message .= "Peer web nick must be less than 20 characters.<br/>";
		$error_found=true;
	}

	return $error_found;
}


/** This is where program execution starts. If page is opened for first time it displays
  * user the message book. If message is being submitted it mails the message to
  * proper user in case verification code is correct.
  *
  */
function main()
{
	global $random_code;
	global $verification_code;
	global $message;
	global $name;
	global $mobile_number;
	global $room_number;
	global $roll_number;
	global $iiit_mail_id;
	global $other_mail_id;
	global $pc_name;
	global $date_of_birth;
	global $gaming_nick;
	global $peer_web_nick;	
	global $remote_address;
	
	//get proper i.p. address of client, if he has not bypassed proxy
	//calculate it before displaying the page, so that user can be 
	//informed about his i.p. address.
	$remote_address = get_remote_address();
	
	//check whether page is opened for first time.
	if($random_code == "" && $name=="" && $mobile_number=="" && $room_number == ""
	          && $roll_number=="" && $iiit_mail_id=="" && $other_mail_id=="" && $pc_name ==""
			  && $date_of_birth == "" && $gaming_nick =="" && $peer_web_nick == "" )
		$first_time=true;
	else
		$first_time=false;
		
	//if it is opened for first time display the page and exit.
	if($first_time)
	{
		address_book_page();
		exit;
	}

	$error_found=verify_post_data();
	
	if($error_found==true)
	{
		address_book_page();
		exit;
	}

	//first verify that random_code submitted is correct. If it is incorrect
	//display the error message and do not process further.
	if($random_code!=$verification_code)
	{
		$message .= "Verification code is incorrect<br/>";
		address_book_page();
		exit; 	
	}

	
	$connection=connect_to_database();
	
	$sql = "INSERT INTO directory VALUES(";
	$sql .= "'" . addslashes($name) . "',";
	$sql .= "'" . addslashes($mobile_number) . "',";
	$sql .= "'" . addslashes($room_number) . "',";
	$sql .= "'" . addslashes($roll_number) . "',";
	$sql .= "'" . addslashes($iiit_mail_id) . "',";
	$sql .= "'" . addslashes($other_mail_id) . "',";
	$sql .= "'" . addslashes($pc_name) . "',";
	$sql .= "'" . addslashes($date_of_birth) . "',";
	$sql .= "'" . addslashes($gaming_nick) . "',";
	$sql .= "'" . addslashes($peer_web_nick) . "',";
	$sql .= "'" . addslashes($remote_address) . "')";
	
	$result = mysql_query($sql, $connection);
	
	if(!$result)
		die("Query failed since, " . mysql_error() . "<br/> Query was " .  $sql);

	mysql_free_result($result);
	mysql_close($connection);		
	
	redirect('thank_you.php');
}



/** Used to store random code submitted by user through form.
  * It is later compared with session variable 'verification_code' to
  * avoid automated submissions.
  */
$random_code=trim(get_post('random_code'));


/** It is used to store verification code during the session. 
  * It helps is avoiding automated submissions.
  */
$verification_code=get_session('verification_code');


/** It is used to store remote address of client who has opened page.
  * It is used to avoid duplicate entries from same client and helps
  * in making sure that proxy is bypassed before visiting the site.
  */
$remote_address = ""; 


/** It is used to store all the messages to be displayed to user in
  * html format. It helps is combining all messages from all functions
  * before displaying output to user.
  */
$message="";


$name=trim(get_post('name'));
$mobile_number=trim(get_post('mobile_number'));
$room_number=trim(get_post('room_number'));
$roll_number=trim(get_post('roll_number'));
$iiit_mail_id=trim(get_post('iiit_mail_id'));
$other_mail_id=trim(get_post('other_mail_id'));
$pc_name=trim(get_post('pc_name'));
$date_of_birth=trim(get_post('date_of_birth'));
$gaming_nick=trim(get_post('gaming_nick'));
$peer_web_nick=trim(get_post('peer_web_nick'));
	
main();
?>
