<?php
/** This file is not intended to be run independently as program. It is used to define
	various parameters that can be used by address book page/module.

	@file parameters.php
	@author Saurabh Barjatiya
	@version 1.0
*/


/** Used to specify address of database server. We can also use name like
	'localhost' instead of IP address to refer to database server. */
define('DATABASE_HOST','127.0.0.1');


/** Used to specify username with which one should connect to database
	server. */
define('DATABASE_USERNAME','address_book');


/** Used to specify password with which one can connect to database. */
define('DATABASE_PASSWORD', 'address_book_secret');


/** Used to specify database name to select / use for address book operations. */
define('DATABASE_DBNAME', 'address_book');


/** Used to specify minimum number that can be displayed on random image being generated. */
define('IMAGE_MINIMUM_NUMBER', 1000000);


/** Used to specify maximum number that can be displayed on random image being generated. */
define('IMAGE_MAXIMUM_NUMBER', 9999999);


/** Used to specify maxmimum number of character that may be displayed on image. This must
	be adjusted manually whenever IMAGE_MINIMUM_NUMBER or IMAGE_MAXIMUM_NUMBER or
	both are modified. */
define('IMAGE_NUMBER_OF_CHARS', 7);


/** Used to specify how many lines (cuts) should be drawn on generated image so that
	it is hard to read using computer vision techniques. */
define('IMAGE_CUTS', 3);


/** Used to specify font size to be used to write numbers on image. Refer to php-gd
	manual pages to know acceptable minimum and maximum font sizes. */
define('IMAGE_FONT_SIZE', 5);


/** Used to specify left, right, top and bottom spacing to be left between numbers and
	image borders so that numbers are easy to read. The number is specifed in pixels. */
define('IMAGE_SPACING', 2);


/** Used to specfiy red component of image color to be used as background. Note that
	in computers colors are specified using their Red, Green and Blue (RGB) components. */
define('IMAGE_BACKGROUND_RED', 0);


/** Used to specfiy green component of image color to be used as background. Note that
	in computers colors are specified using their Red, Green and Blue (RGB) components. */
define('IMAGE_BACKGROUND_GREEN', 0);


/** Used to specfiy blue component of image color to be used as background. Note that
	in computers colors are specified using their Red, Green and Blue (RGB) components. */
define('IMAGE_BACKGROUND_BLUE', 0);


/** Used to specfiy red component of image color to be used as foreground. Note that
	in computers colors are specified using their Red, Green and Blue (RGB) components. */
define('IMAGE_FOREGROUND_RED', 255);


/** Used to specfiy green component of image color to be used as background. Note that
	in computers colors are specified using their Red, Green and Blue (RGB) components. */
define('IMAGE_FOREGROUND_GREEN', 255);


/** Used to specfiy blue component of image color to be used as background. Note that
	in computers colors are specified using their Red, Green and Blue (RGB) components. */
define('IMAGE_FOREGROUND_BLUE', 255);


/** Used to specify name (including location) of image to be generated. The path can be
	relative and folder specified must be writable by web server for things to work. If
	path is not specified current folder is used, in that case current folder should be
	writable by web server. */
define('IMAGE_FILENAME', "random_image.png");
?>
