#include <gdbm.h>	//for gdbm_* functions
#include <stdio.h>	//for *printf, *scanf functions
#include <stdlib.h>	//for exit, free funcions
#include <string.h>	//for memcpy functions

#include "gdbm_example.h"

GDBM_FILE database1;

int main(int argc, char *argv[])
{
    if(argc==1)
    {
	fprintf(stderr,"Syntax: %s <test_database_file_name>\n", argv[0]);
    	exit(EXIT_FAILURE);
    }

    database1=gdbm_open(argv[1], sizeof(struct student_email_record), GDBM_WRCREAT, 0666, NULL);
    if(database1==NULL)
    {
	fprintf(stderr, "Cant create file with name %s\n. %s\n", argv[1], gdbm_strerror(gdbm_errno));
	exit(EXIT_FAILURE);
    }

    show_menu();
    gdbm_close(database1);

    exit(EXIT_SUCCESS);
    return 0;
}


void show_menu()
{
    int choice=0;

    while(choice!=5)
    {
	printf("\n\nOPTIONS\n");
	printf("1. Store record\n");
	printf("2. Fetch record\n");
	printf("3. Print all records\n");
	printf("4. Delete record\n");
	printf("5. Exit\n");
	printf("Enter your choice:");
	scanf("%d", &choice);

	if(choice<1 || choice > 5)
	    printf("Invalid choice. Choice must be between 1 and 5.\n");
	else
	{
	    switch(choice)
	    {
		case 1:
		    store_record();
		    break;

		case 2:
		    fetch_record();
		    break;

		case 3:
		    print_all_records();
		    break;

		case 4:
		    delete_record();
		    break;
	    }
	}
    }
}


void store_record()
{
    struct student_email_record record1;
    datum record1_content;
    datum record1_key;
    int error_occurred;

    printf("Enter student ID (no spaces) : ");
    scanf("%s", record1.student_id);
    printf("Enter email address (no spaces) : ");
    scanf("%s", record1.email_address);

    record1_content.dptr=(char *)&record1;
    record1_content.dsize=sizeof(record1);
    record1_key.dptr=record1.student_id;
    record1_key.dsize=strlen(record1.student_id)+1;

    error_occurred = gdbm_store(database1, record1_key, record1_content, GDBM_INSERT); 

    if(error_occurred)
    {
	if(error_occurred==1)
	{
	    fprintf(stderr, "Can't store record as another record with same student ID already exists.\n");
	}
	else
	{
	    fprintf(stderr, "Could not insert record as %s\n", gdbm_strerror(gdbm_errno));
	    exit(EXIT_FAILURE);
	}
    }
    else
    {
	printf("Record stored successfully.\n");
    }
    gdbm_sync(database1);
}


void fetch_record()
{
    struct student_email_record record1;
    datum record1_content;
    datum record1_key;
    char student_id[20];

    printf("Enter student id for which email address should be searched : ");
    scanf("%s",student_id);

    record1_key.dptr=student_id;
    record1_key.dsize=strlen(student_id)+1;

    record1_content = gdbm_fetch(database1, record1_key);
    if(record1_content.dptr==NULL)
    {
	fprintf(stderr, "Could not fetch record as %s\n", gdbm_strerror(gdbm_errno));
    }
    else
    {
	memcpy(&record1, record1_content.dptr, sizeof(struct student_email_record));
	printf("Student ID : %s\n", record1.student_id);
	printf("Email address : %s\n", record1.email_address);
	free(record1_content.dptr);	//VERY IMPORTANT to avoid memory leaks
    }
}

void print_all_records()
{
    struct student_email_record record1;
    datum record1_content;
    datum record1_key;
    int counter1=0;
    
    record1_key = gdbm_firstkey(database1);
    while(record1_key.dptr!=NULL)
    {
	counter1++;
	record1_content = gdbm_fetch(database1, record1_key);
	memcpy(&record1, record1_content.dptr, sizeof(struct student_email_record));
	printf("%2d. Student ID : %s\n", counter1, record1.student_id);
	printf("    Email address : %s\n", record1.email_address);
	record1_key=gdbm_nextkey(database1, record1_key);
    }

    if(counter1==0)
    {
	printf("Database is empty\n");
    }
}

void delete_record()
{
    datum record1_key;
    int error_occurred;
    char student_id[20];

    printf("Enter student id for whose record should be : ");
    scanf("%s",student_id);

    record1_key.dptr=student_id;
    record1_key.dsize=strlen(student_id)+1;

    error_occurred = gdbm_delete(database1, record1_key);
    if(error_occurred)
    {
	fprintf(stderr, "Could not delete record as %s\n", gdbm_strerror(gdbm_errno));
    }
    gdbm_reorganize(database1);
}

