#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <fcntl.h>
#include <errno.h>

#define BUFFER_SIZE 4096
#define LISTEN_PORT1 8888
#define LISTEN_PORT2 9999

//used to store file descriptor of port we are listing to
int listen_file_descriptor1;
int listen_file_descriptor2;

void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(listen_file_descriptor1);
    if(return_value <0)
    {
	perror("Cannot close listening socket 1.");
	exit(EXIT_FAILURE);
    }

    return_value =close(listen_file_descriptor2);
    if(return_value <0)
    {
	perror("Cannot close listening socket 2.");
	exit(EXIT_FAILURE);
    }

    printf("Shutdown complete.\n");
    exit(0);
}
    

/**
  * Used to create a example for blocking input. The program will listen on some
  * port defined in LISTEN_PORT (default 9999)  at top and call read with large
  * value (default sizeof(BUFFER)).
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{
    int connection_file_descriptor1; 
    int connection_file_descriptor2; 
    char input_data[BUFFER_SIZE];
    struct sockaddr_in server_address;
    int return_value;
    struct sigaction act1;
    int characters_read;
    int flags;


    //close connections when Ctrl+C is pressed
    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;
    sigaction(SIGINT, &act1, 0);
    

    //listening on LISTEN_PORT1
    listen_file_descriptor1 = socket(AF_INET, SOCK_STREAM, 0);
    if(listen_file_descriptor1 < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(LISTEN_PORT1);
    return_value = bind(listen_file_descriptor1, (struct sockaddr *) &server_address, sizeof(server_address));
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(EXIT_FAILURE);
    }

    return_value = listen(listen_file_descriptor1, 5);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(EXIT_FAILURE);
    }


    //listening on LISTEN_PORT2
    listen_file_descriptor2 = socket(AF_INET, SOCK_STREAM, 0);
    if(listen_file_descriptor2 < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(LISTEN_PORT2);
    return_value = bind(listen_file_descriptor2, (struct sockaddr *) &server_address, sizeof(server_address));
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(EXIT_FAILURE);
    }

    return_value = listen(listen_file_descriptor2, 5);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(EXIT_FAILURE);
    }
    
    while(1)
    {
	connection_file_descriptor1 = accept(listen_file_descriptor1, (struct sockaddr *) NULL, NULL);
	if(connection_file_descriptor1 < 0)
	{
	    perror("accept() failed.");
	    exit(EXIT_FAILURE);
	}
	else
	{
	    printf("Got client for connection1.\n");
	}

	connection_file_descriptor2 = accept(listen_file_descriptor2, (struct sockaddr *) NULL, NULL);
	if(connection_file_descriptor2 < 0)
	{
	    perror("accept() failed.");
	    exit(EXIT_FAILURE);
	}
	else
	{
	    printf("Got client for connection2.\n");
	}


	//set sockets to not block
	//do not use direct fcntl(connection_file_descriptor1, F_SETFL, O_NONBLOCK);
	//as that would remove other set flags and set only O_NONBLOCK
	flags=fcntl(connection_file_descriptor1, F_GETFL, 0);
	if(flags<0)
	{
	    perror("F_GETFL failed");
	    exit(EXIT_FAILURE);
	}
	flags|=O_NONBLOCK;
	fcntl(connection_file_descriptor1, F_SETFL, flags);
	if(flags<0)
	{
	    perror("F_GETFL failed");
	    exit(EXIT_FAILURE);
	}

	flags=fcntl(connection_file_descriptor2, F_GETFL, 0);
	if(flags<0)
	{
	    perror("F_GETFL failed");
	    exit(EXIT_FAILURE);
	}
	flags|=O_NONBLOCK;
	fcntl(connection_file_descriptor2, F_SETFL, flags);
	if(flags<0)
	{
	    perror("F_GETFL failed");
	    exit(EXIT_FAILURE);
	}

	while(1)
	{
	    characters_read=read(connection_file_descriptor1, input_data, BUFFER_SIZE-1);
	    if(characters_read > 0)
	    {
		input_data[characters_read]='\0';
		printf("Received %d bytes from connection1 : %s\n", characters_read, input_data);
		write(connection_file_descriptor2, input_data, characters_read);
		printf("Wrote %d bytes to connection2\n", characters_read);
	    }
	    else if(characters_read<0)
	    {
		//now return value -1 does not necessarily mean that error occurred.
		if(errno!=EWOULDBLOCK)
		{
		    perror("Read from connection1 failed");
		    exit(EXIT_FAILURE);
		}
	    }
	    else
	    {
		// characters_read=0, and return on blocking IO means connection1 closed.
		printf("Connection1 seems to be closed\n");
		break;
	    }

	    characters_read=read(connection_file_descriptor2, input_data, BUFFER_SIZE-1);
	    if(characters_read > 0)
	    {
		input_data[characters_read]='\0';
		printf("Received %d bytes from connection2 : %s\n", characters_read, input_data);
		write(connection_file_descriptor1, input_data, characters_read);
		printf("Wrote %d bytes to connection1\n", characters_read);
	    }
	    else if(characters_read<0)
	    {
		//now return value -1 does not necessarily mean that error occurred.
		if(errno!=EWOULDBLOCK)
		{
		    perror("Read from connection2 failed");
		    exit(EXIT_FAILURE);
		}
	    }
	    else
	    {
		// characters_read=0, and return on blocking IO means connection2 closed.
		printf("Connection2 seems to be closed\n");
		break;
	    }
	}


	//close connections
	return_value = close(connection_file_descriptor1);
	if(return_value <0)
	{
	    perror("close failed");
	    exit(EXIT_FAILURE);
	}
	return_value = close(connection_file_descriptor2);
	if(return_value <0)
	{
	    perror("close failed");
	    exit(EXIT_FAILURE);
	}
    }
        
    return 0;
}

