#include <stdio.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>

#define KEY 200401196
#define MEMORY_SIZE 4096 

int main()
{
    int shmid;
    char *shared_memory;
    int return_value;
   
   shmid = shmget(KEY, MEMORY_SIZE, 0666|IPC_CREAT);
   if(shmid<0)
   {
       fprintf(stderr, "Error occurred while using shmget for KEY %d\n", KEY);
       perror("");
       exit(EXIT_FAILURE);
   }

   shared_memory = (char *) shmat(shmid, NULL, 0);
   if(shared_memory < 0)
   {
       fprintf(stderr, "Error occurred while using shmat for shmid %d\n", shmid);
       perror("");
       exit(EXIT_FAILURE);
   }

   printf("Value stored in shared memory is : %s\n", shared_memory);

   return_value=shmdt(shared_memory);
   if(return_value <0)
   {
       fprintf(stderr, "Error occurred while using shmdt for shmid %d\n", shmid);
       perror("");
       exit(EXIT_FAILURE);
   }

   exit(EXIT_SUCCESS);
   return 0;
}
